/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.URL;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateParsingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSocket;
import javax.security.cert.CertificateEncodingException;
import javax.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CertificateUtils {
    private static final Logger logger = LoggerFactory.getLogger(CertificateUtils.class);
    private static final String PEER_NOT_AUTHENTICATED_MSG = "peer not authenticated";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isStoreValid(URL keystore, KeystoreType keystoreType, char[] password) {
        if (keystore == null) {
            throw new IllegalArgumentException("keystore may not be null");
        }
        if (keystoreType == null) {
            throw new IllegalArgumentException("keystore type may not be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password may not be null");
        }
        BufferedInputStream bis = null;
        try {
            bis = new BufferedInputStream(keystore.openStream());
            KeyStore ks = KeyStore.getInstance(keystoreType.name());
            ks.load(bis, password);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (bis != null) {
                try {
                    bis.close();
                }
                catch (IOException ioe) {
                    logger.warn("Failed to close input stream", (Throwable)ioe);
                }
            }
        }
    }

    public static String extractUsername(String dn) {
        String username = dn;
        if (StringUtils.isNotBlank((CharSequence)dn)) {
            String separator = StringUtils.indexOfIgnoreCase((CharSequence)dn, (CharSequence)"/cn=") > 0 ? "/" : ",";
            String cnPattern = "cn=";
            int cnIndex = StringUtils.indexOfIgnoreCase((CharSequence)dn, (CharSequence)"cn=");
            if (cnIndex >= 0) {
                int separatorIndex = StringUtils.indexOf((CharSequence)dn, (CharSequence)separator, (int)cnIndex);
                username = separatorIndex > 0 ? StringUtils.substring((String)dn, (int)(cnIndex + "cn=".length()), (int)separatorIndex) : StringUtils.substring((String)dn, (int)(cnIndex + "cn=".length()));
            }
        }
        return username;
    }

    public static List<String> getSubjectAlternativeNames(java.security.cert.X509Certificate certificate) throws CertificateParsingException {
        Collection<List<?>> altNames = certificate.getSubjectAlternativeNames();
        if (altNames == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> result = new ArrayList<String>();
        for (List<?> generalName : altNames) {
            Object value = generalName.get(1);
            if (!(value instanceof String)) continue;
            result.add(((String)value).toLowerCase());
        }
        return result;
    }

    public static String extractPeerDNFromSSLSocket(Socket socket) throws CertificateException {
        String dn = null;
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            boolean clientMode = sslSocket.getUseClientMode();
            logger.debug("SSL Socket in {} mode", (Object)(clientMode ? "client" : "server"));
            ClientAuth clientAuth = CertificateUtils.getClientAuthStatus(sslSocket);
            logger.debug("SSL Socket client auth status: {}", (Object)clientAuth);
            if (clientMode) {
                logger.debug("This socket is in client mode, so attempting to extract certificate from remote 'server' socket");
                dn = CertificateUtils.extractPeerDNFromServerSSLSocket(sslSocket);
            } else {
                logger.debug("This socket is in server mode, so attempting to extract certificate from remote 'client' socket");
                dn = CertificateUtils.extractPeerDNFromClientSSLSocket(sslSocket);
            }
        }
        return dn;
    }

    private static String extractPeerDNFromClientSSLSocket(SSLSocket sslSocket) throws CertificateException {
        String dn = null;
        ClientAuth clientAuth = CertificateUtils.getClientAuthStatus(sslSocket);
        logger.debug("SSL Socket client auth status: {}", (Object)clientAuth);
        if (clientAuth != ClientAuth.NONE) {
            try {
                Certificate[] certChains = sslSocket.getSession().getPeerCertificates();
                if (certChains != null && certChains.length > 0) {
                    java.security.cert.X509Certificate x509Certificate = CertificateUtils.convertAbstractX509Certificate(certChains[0]);
                    dn = x509Certificate.getSubjectDN().getName().trim();
                    logger.debug("Extracted DN={} from client certificate", (Object)dn);
                }
            }
            catch (SSLPeerUnverifiedException e) {
                if (e.getMessage().equals(PEER_NOT_AUTHENTICATED_MSG)) {
                    logger.error("The incoming request did not contain client certificates and thus the DN cannot be extracted. Check that the other endpoint is providing a complete client certificate chain");
                }
                if (clientAuth == ClientAuth.WANT) {
                    logger.warn("Suppressing missing client certificate exception because client auth is set to 'want'");
                    return dn;
                }
                throw new CertificateException(e);
            }
        }
        return dn;
    }

    private static String extractPeerDNFromServerSSLSocket(Socket socket) throws CertificateException {
        String dn = null;
        if (socket instanceof SSLSocket) {
            SSLSocket sslSocket = (SSLSocket)socket;
            try {
                Certificate[] certChains = sslSocket.getSession().getPeerCertificates();
                if (certChains != null && certChains.length > 0) {
                    java.security.cert.X509Certificate x509Certificate = CertificateUtils.convertAbstractX509Certificate(certChains[0]);
                    dn = x509Certificate.getSubjectDN().getName().trim();
                    logger.debug("Extracted DN={} from server certificate", (Object)dn);
                }
            }
            catch (SSLPeerUnverifiedException e) {
                if (e.getMessage().equals(PEER_NOT_AUTHENTICATED_MSG)) {
                    logger.error("The server did not present a certificate and thus the DN cannot be extracted. Check that the other endpoint is providing a complete certificate chain");
                }
                throw new CertificateException(e);
            }
        }
        return dn;
    }

    private static ClientAuth getClientAuthStatus(SSLSocket sslSocket) {
        return sslSocket.getNeedClientAuth() ? ClientAuth.NEED : (sslSocket.getWantClientAuth() ? ClientAuth.WANT : ClientAuth.NONE);
    }

    public static java.security.cert.X509Certificate convertLegacyX509Certificate(X509Certificate legacyCertificate) throws CertificateException {
        if (legacyCertificate == null) {
            throw new IllegalArgumentException("The X.509 certificate cannot be null");
        }
        try {
            return CertificateUtils.formX509Certificate(legacyCertificate.getEncoded());
        }
        catch (CertificateEncodingException e) {
            throw new CertificateException(e);
        }
    }

    public static java.security.cert.X509Certificate convertAbstractX509Certificate(Certificate abstractCertificate) throws CertificateException {
        if (abstractCertificate == null || !(abstractCertificate instanceof java.security.cert.X509Certificate)) {
            throw new IllegalArgumentException("The certificate cannot be null and must be an X.509 certificate");
        }
        try {
            return CertificateUtils.formX509Certificate(abstractCertificate.getEncoded());
        }
        catch (java.security.cert.CertificateEncodingException e) {
            throw new CertificateException(e);
        }
    }

    private static java.security.cert.X509Certificate formX509Certificate(byte[] encodedCertificate) throws CertificateException {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream bais = new ByteArrayInputStream(encodedCertificate);
            return (java.security.cert.X509Certificate)cf.generateCertificate(bais);
        }
        catch (CertificateException e) {
            logger.error("Error converting the certificate", (Throwable)e);
            throw e;
        }
    }

    public static boolean compareDNs(String dn1, String dn2) {
        if (dn1 == null) {
            dn1 = "";
        }
        if (dn2 == null) {
            dn2 = "";
        }
        if (StringUtils.isEmpty((CharSequence)dn1) || StringUtils.isEmpty((CharSequence)dn2)) {
            return dn1.equals(dn2);
        }
        try {
            List<Rdn> rdn1 = new LdapName(dn1).getRdns();
            List<Rdn> rdn2 = new LdapName(dn2).getRdns();
            return rdn1.size() == rdn2.size() && rdn1.containsAll(rdn2);
        }
        catch (InvalidNameException e) {
            logger.warn("Cannot compare DNs: {} and {} because one or both is not a valid DN", (Object)dn1, (Object)dn2);
            return false;
        }
    }

    private CertificateUtils() {
    }

    public static enum ClientAuth {
        NONE(0, "none"),
        WANT(1, "want"),
        NEED(2, "need");

        private int value;
        private String description;

        private ClientAuth(int value, String description) {
            this.value = value;
            this.description = description;
        }

        public String toString() {
            return "Client Auth: " + this.description + " (" + this.value + ")";
        }
    }
}

