/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.security.util.crypto.SecureHasher;
import org.bouncycastle.crypto.generators.Argon2BytesGenerator;
import org.bouncycastle.crypto.params.Argon2Parameters;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.encoders.Hex;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Argon2SecureHasher
implements SecureHasher {
    private static final Logger logger = LoggerFactory.getLogger(Argon2SecureHasher.class);
    private static final int DEFAULT_HASH_LENGTH = 32;
    private static final int DEFAULT_PARALLELISM = 1;
    private static final int DEFAULT_MEMORY = 4096;
    private static final int DEFAULT_ITERATIONS = 3;
    private final int hashLength;
    private final int memory;
    private final int parallelism;
    private final int iterations;
    private final int saltLength;
    private final boolean usingStaticSalt;
    private static final byte[] staticSalt = "NiFi Static Salt".getBytes(StandardCharsets.UTF_8);

    public Argon2SecureHasher() {
        this(32, 4096, 1, 3, 0);
    }

    public Argon2SecureHasher(int hashLength, int memory, int parallelism, int iterations) {
        this(hashLength, memory, parallelism, iterations, 0);
    }

    public Argon2SecureHasher(int hashLength, int memory, int parallelism, int iterations, int saltLength) {
        this.hashLength = hashLength;
        this.memory = memory;
        this.parallelism = parallelism;
        this.iterations = iterations;
        this.saltLength = saltLength;
        if (saltLength > 0) {
            this.usingStaticSalt = false;
        } else {
            this.usingStaticSalt = true;
            logger.debug("Configured to use static salt");
        }
    }

    public boolean isUsingStaticSalt() {
        return this.usingStaticSalt;
    }

    byte[] getSalt() {
        if (this.isUsingStaticSalt()) {
            return staticSalt;
        }
        SecureRandom sr = new SecureRandom();
        byte[] salt = new byte[this.saltLength];
        sr.nextBytes(salt);
        return salt;
    }

    @Override
    public String hashHex(String input) {
        if (input == null) {
            logger.warn("Attempting to generate an Argon2 hash of null input; using empty input");
            input = "";
        }
        return Hex.toHexString((byte[])this.hash(input.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public String hashBase64(String input) {
        if (input == null) {
            logger.warn("Attempting to generate an Argon2 hash of null input; using empty input");
            input = "";
        }
        return Base64.toBase64String((byte[])this.hash(input.getBytes(StandardCharsets.UTF_8)));
    }

    @Override
    public byte[] hashRaw(byte[] input) {
        return this.hash(input);
    }

    private byte[] hash(byte[] input) {
        byte[] salt = this.getSalt();
        byte[] hash = new byte[this.hashLength];
        logger.debug("Creating {} byte Argon2 hash with salt [{}]", (Object)this.hashLength, (Object)Hex.toHexString((byte[])salt));
        long startNanos = System.nanoTime();
        Argon2Parameters params = new Argon2Parameters.Builder(2).withSalt(salt).withParallelism(this.parallelism).withMemoryAsKB(this.memory).withIterations(this.iterations).build();
        Argon2BytesGenerator generator = new Argon2BytesGenerator();
        generator.init(params);
        long initNanos = System.nanoTime();
        generator.generateBytes(input, hash);
        long generateNanos = System.nanoTime();
        long initDurationMicros = TimeUnit.NANOSECONDS.toMicros(initNanos - startNanos);
        long generateDurationMicros = TimeUnit.NANOSECONDS.toMicros(generateNanos - initNanos);
        long totalDurationMillis = TimeUnit.MICROSECONDS.toMillis(initDurationMicros + generateDurationMicros);
        logger.debug("Generated Argon2 hash in {} ms (init: {} \u00b5s, generate: {} \u00b5s)", new Object[]{totalDurationMillis, initDurationMicros, generateDurationMicros});
        return hash;
    }
}

