/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.security.util.EncryptionMethod;
import org.apache.nifi.security.util.crypto.CipherProvider;
import org.apache.nifi.security.util.crypto.CipherUtility;

public abstract class KeyedCipherProvider
implements CipherProvider {
    static final byte[] IV_DELIMITER = "NiFiIV".getBytes(StandardCharsets.UTF_8);
    static final int MAX_IV_LIMIT = 16;

    public abstract Cipher getCipher(EncryptionMethod var1, SecretKey var2, byte[] var3, boolean var4) throws Exception;

    public abstract Cipher getCipher(EncryptionMethod var1, SecretKey var2, boolean var3) throws Exception;

    abstract byte[] generateIV();

    public byte[] readIV(InputStream in) throws IOException, ProcessException {
        return CipherUtility.readBytesFromInputStream(in, "IV", 16, IV_DELIMITER);
    }

    public void writeIV(byte[] iv, OutputStream out) throws IOException {
        CipherUtility.writeBytesToOutputStream(out, iv, "IV", IV_DELIMITER);
    }
}

