/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.security.util;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Properties;
import org.apache.nifi.security.util.KeyStoreUtils;
import org.apache.nifi.security.util.KeystoreType;
import org.apache.nifi.security.util.TlsConfiguration;
import org.apache.nifi.security.util.TlsPlatform;
import org.apache.nifi.util.NiFiProperties;

public class StandardTlsConfiguration
implements TlsConfiguration {
    protected static final String SSL_PROTOCOL = "SSL";
    protected static final String TLS_PROTOCOL = "TLS";
    private static final String TLS_PROTOCOL_VERSION = TlsPlatform.getLatestProtocol();
    private static final String MASKED_PASSWORD_LOG = "********";
    private static final String NULL_LOG = "null";
    private final String keystorePath;
    private final String keystorePassword;
    private final String keyPassword;
    private final KeystoreType keystoreType;
    private final String truststorePath;
    private final String truststorePassword;
    private final KeystoreType truststoreType;
    private final String protocol;

    public StandardTlsConfiguration() {
        this(null, null, null, "", null, null, "", null);
    }

    public StandardTlsConfiguration(String keystorePath, String keystorePassword, KeystoreType keystoreType, String truststorePath, String truststorePassword, KeystoreType truststoreType) {
        this(keystorePath, keystorePassword, keystorePassword, keystoreType, truststorePath, truststorePassword, truststoreType, TLS_PROTOCOL_VERSION);
    }

    public StandardTlsConfiguration(String keystorePath, String keystorePassword, String keyPassword, KeystoreType keystoreType, String truststorePath, String truststorePassword, KeystoreType truststoreType) {
        this(keystorePath, keystorePassword, keyPassword, keystoreType, truststorePath, truststorePassword, truststoreType, TLS_PROTOCOL_VERSION);
    }

    public StandardTlsConfiguration(String keystorePath, String keystorePassword, String keyPassword, String keystoreType, String truststorePath, String truststorePassword, String truststoreType) {
        this(keystorePath, keystorePassword, keyPassword, KeystoreType.isValidKeystoreType((String)keystoreType) ? KeystoreType.valueOf((String)keystoreType.toUpperCase()) : null, truststorePath, truststorePassword, KeystoreType.isValidKeystoreType((String)truststoreType) ? KeystoreType.valueOf((String)truststoreType.toUpperCase()) : null, TLS_PROTOCOL_VERSION);
    }

    public StandardTlsConfiguration(String keystorePath, String keystorePassword, String keyPassword, String keystoreType, String truststorePath, String truststorePassword, String truststoreType, String protocol) {
        this(keystorePath, keystorePassword, keyPassword, KeystoreType.isValidKeystoreType((String)keystoreType) ? KeystoreType.valueOf((String)keystoreType.toUpperCase()) : null, truststorePath, truststorePassword, KeystoreType.isValidKeystoreType((String)truststoreType) ? KeystoreType.valueOf((String)truststoreType.toUpperCase()) : null, protocol);
    }

    public StandardTlsConfiguration(String keystorePath, String keystorePassword, String keyPassword, KeystoreType keystoreType, String truststorePath, String truststorePassword, KeystoreType truststoreType, String protocol) {
        this.keystorePath = keystorePath;
        this.keystorePassword = keystorePassword;
        this.keyPassword = keyPassword;
        this.keystoreType = keystoreType;
        this.truststorePath = truststorePath;
        this.truststorePassword = truststorePassword;
        this.truststoreType = truststoreType;
        this.protocol = protocol;
    }

    public StandardTlsConfiguration(TlsConfiguration other) {
        this.keystorePath = other.getKeystorePath();
        this.keystorePassword = other.getKeystorePassword();
        this.keyPassword = other.getKeyPassword();
        this.keystoreType = other.getKeystoreType();
        this.truststorePath = other.getTruststorePath();
        this.truststorePassword = other.getTruststorePassword();
        this.truststoreType = other.getTruststoreType();
        this.protocol = other.getProtocol();
    }

    public static TlsConfiguration fromNiFiProperties(NiFiProperties niFiProperties) {
        Properties properties = new Properties();
        niFiProperties.getPropertyKeys().forEach(key -> properties.setProperty((String)key, niFiProperties.getProperty(key)));
        return StandardTlsConfiguration.fromNiFiProperties(properties);
    }

    public static TlsConfiguration fromNiFiProperties(Properties niFiProperties) {
        Objects.requireNonNull(niFiProperties, "Properties required");
        return new StandardTlsConfiguration(niFiProperties.getProperty("nifi.security.keystore"), niFiProperties.getProperty("nifi.security.keystorePasswd"), niFiProperties.getProperty("nifi.security.keyPasswd"), niFiProperties.getProperty("nifi.security.keystoreType"), niFiProperties.getProperty("nifi.security.truststore"), niFiProperties.getProperty("nifi.security.truststorePasswd"), niFiProperties.getProperty("nifi.security.truststoreType"), TLS_PROTOCOL_VERSION);
    }

    public static StandardTlsConfiguration fromNiFiPropertiesTruststoreOnly(NiFiProperties niFiProperties) {
        Objects.requireNonNull(niFiProperties, "Properties required");
        return new StandardTlsConfiguration(null, null, null, null, niFiProperties.getProperty("nifi.security.truststore"), niFiProperties.getProperty("nifi.security.truststorePasswd"), niFiProperties.getProperty("nifi.security.truststoreType"), TLS_PROTOCOL_VERSION);
    }

    public String getKeystorePath() {
        return this.keystorePath;
    }

    public String getKeystorePassword() {
        return this.keystorePassword;
    }

    public String getKeystorePasswordForLogging() {
        return StandardTlsConfiguration.maskPasswordForLog(this.keystorePassword);
    }

    public String getKeyPassword() {
        return this.keyPassword;
    }

    public String getKeyPasswordForLogging() {
        return StandardTlsConfiguration.maskPasswordForLog(this.keyPassword);
    }

    public String getFunctionalKeyPassword() {
        return StandardTlsConfiguration.isNotBlank(this.keyPassword) ? this.keyPassword : this.keystorePassword;
    }

    public String getFunctionalKeyPasswordForLogging() {
        return StandardTlsConfiguration.maskPasswordForLog(this.getFunctionalKeyPassword());
    }

    public KeystoreType getKeystoreType() {
        return this.keystoreType;
    }

    public String getTruststorePath() {
        return this.truststorePath;
    }

    public String getTruststorePassword() {
        return this.truststorePassword;
    }

    public String getTruststorePasswordForLogging() {
        return StandardTlsConfiguration.maskPasswordForLog(this.truststorePassword);
    }

    public KeystoreType getTruststoreType() {
        return this.truststoreType;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public boolean isKeystorePopulated() {
        return this.isStorePopulated(this.keystorePath, this.keystorePassword, this.keystoreType, StoreType.KEY_STORE);
    }

    public boolean isAnyKeystorePopulated() {
        return this.isAnyPopulated(this.keystorePath, this.keystorePassword, this.keystoreType);
    }

    public boolean isKeystoreValid() {
        if (this.isStoreValid(this.keystorePath, this.keystorePassword, this.keystoreType, StoreType.KEY_STORE)) {
            return true;
        }
        if (StandardTlsConfiguration.isNotBlank(this.keyPassword) && !this.keyPassword.equals(this.keystorePassword)) {
            return this.isKeystorePopulated() && KeyStoreUtils.isKeyPasswordCorrect(this.getFileUrl(this.keystorePath), this.keystoreType, this.keystorePassword.toCharArray(), this.getFunctionalKeyPassword().toCharArray());
        }
        return false;
    }

    public boolean isTruststorePopulated() {
        return this.isStorePopulated(this.truststorePath, this.truststorePassword, this.truststoreType, StoreType.TRUST_STORE);
    }

    public boolean isAnyTruststorePopulated() {
        return this.isAnyPopulated(this.truststorePath, this.truststorePassword, this.truststoreType);
    }

    public boolean isTruststoreValid() {
        return this.isStoreValid(this.truststorePath, this.truststorePassword, this.truststoreType, StoreType.TRUST_STORE);
    }

    public String[] getKeystorePropertiesForLogging() {
        return new String[]{this.getKeystorePath(), this.getKeystorePasswordForLogging(), this.getFunctionalKeyPasswordForLogging(), this.getKeystoreType() != null ? this.getKeystoreType().getType() : NULL_LOG};
    }

    public String[] getTruststorePropertiesForLogging() {
        return new String[]{this.getTruststorePath(), this.getTruststorePasswordForLogging(), this.getKeystoreType() != null ? this.getTruststoreType().getType() : NULL_LOG};
    }

    public String[] getEnabledProtocols() {
        ArrayList<String> enabledProtocols = new ArrayList<String>();
        String configuredProtocol = this.getProtocol();
        if (TLS_PROTOCOL.equals(configuredProtocol)) {
            enabledProtocols.addAll(TlsPlatform.getPreferredProtocols());
        } else if (SSL_PROTOCOL.equals(configuredProtocol)) {
            enabledProtocols.addAll(TlsPlatform.getSupportedProtocols());
        } else if (configuredProtocol != null) {
            enabledProtocols.add(configuredProtocol);
        }
        return enabledProtocols.toArray(new String[0]);
    }

    public String toString() {
        return "[TlsConfiguration]keystorePath=" + this.keystorePath + ",keystorePassword=" + this.getKeystorePasswordForLogging() + ",keyPassword=" + this.getKeyPasswordForLogging() + ",keystoreType=" + String.valueOf(this.keystoreType) + ",truststorePath=" + this.truststorePath + ",truststorePassword=" + this.getTruststorePasswordForLogging() + ",truststoreType=" + String.valueOf(this.truststoreType) + ",protocol=" + this.protocol;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TlsConfiguration that = (TlsConfiguration)o;
        return Objects.equals(this.keystorePath, that.getKeystorePath()) && Objects.equals(this.keystorePassword, that.getKeystorePassword()) && Objects.equals(this.keyPassword, that.getKeyPassword()) && this.keystoreType == that.getKeystoreType() && Objects.equals(this.truststorePath, that.getTruststorePath()) && Objects.equals(this.truststorePassword, that.getTruststorePassword()) && this.truststoreType == that.getTruststoreType() && Objects.equals(this.protocol, that.getProtocol());
    }

    public int hashCode() {
        return Objects.hash(this.keystorePath, this.keystorePassword, this.keyPassword, this.keystoreType, this.truststorePath, this.truststorePassword, this.truststoreType, this.protocol);
    }

    private static String maskPasswordForLog(String password) {
        return StandardTlsConfiguration.isNotBlank(password) ? MASKED_PASSWORD_LOG : NULL_LOG;
    }

    private boolean isAnyPopulated(String path, String password, KeystoreType type) {
        return StandardTlsConfiguration.isNotBlank(path) || StandardTlsConfiguration.isNotBlank(password) || type != null;
    }

    private boolean isStorePopulated(String path, String password, KeystoreType type, StoreType storeType) {
        boolean populated;
        boolean bl = populated = StandardTlsConfiguration.isNotBlank(path) && type != null;
        if (StoreType.KEY_STORE == storeType) {
            populated = populated && StandardTlsConfiguration.isNotBlank(password);
        }
        return populated;
    }

    private boolean isStoreValid(String path, String password, KeystoreType type, StoreType storeType) {
        return this.isStorePopulated(path, password, type, storeType) && KeyStoreUtils.isStoreValid(this.getFileUrl(path), type, password.toCharArray());
    }

    private URL getFileUrl(String path) {
        try {
            return new File(path).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(String.format("File Path [%s] URL conversion failed", path), e);
        }
    }

    private static boolean isNotBlank(String string) {
        return string != null && !string.isBlank();
    }

    private static enum StoreType {
        KEY_STORE,
        TRUST_STORE;

    }
}

