/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.snmp.processors;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.snmp.processors.AbstractSNMPProcessor;
import org.apache.nifi.snmp.processors.SNMPSetter;
import org.apache.nifi.snmp.processors.SNMPUtils;
import org.snmp4j.PDU;
import org.snmp4j.ScopedPDU;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.AbstractVariable;
import org.snmp4j.smi.AssignableFromInteger;
import org.snmp4j.smi.AssignableFromLong;
import org.snmp4j.smi.AssignableFromString;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;

@Tags(value={"snmp", "set", "oid"})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@CapabilityDescription(value="Based on incoming FlowFile attributes, the processor will execute SNMP Set requests. When founding attributes with name like snmp$<OID>, the processor will atempt to set the value of attribute to the corresponding OID given in the attribute name")
public class SetSNMP
extends AbstractSNMPProcessor<SNMPSetter> {
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("All FlowFiles that have been successfully used to perform SNMP Set are routed to this relationship").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("All FlowFiles that failed during the SNMP Set care routed to this relationship").build();
    private static final List<PropertyDescriptor> propertyDescriptors;
    private static final Set<Relationship> relationships;

    @Override
    protected void onTriggerSnmp(ProcessContext context, ProcessSession processSession) throws ProcessException {
        block7: {
            FlowFile flowFile = processSession.get();
            if (flowFile != null) {
                Object pdu = null;
                pdu = this.snmpTarget.getVersion() == 3 ? new ScopedPDU() : new PDU();
                if (this.addVariables((PDU)pdu, flowFile.getAttributes())) {
                    pdu.setType(-93);
                    try {
                        ResponseEvent response = ((SNMPSetter)this.targetResource).set((PDU)pdu);
                        if (response.getResponse() == null) {
                            processSession.transfer(processSession.penalize(flowFile), REL_FAILURE);
                            this.getLogger().error("Set request timed out or parameters are incorrect.");
                            context.yield();
                            break block7;
                        }
                        if (response.getResponse().getErrorStatus() == 0) {
                            flowFile = SNMPUtils.updateFlowFileAttributesWithPduProperties((PDU)pdu, flowFile, processSession);
                            processSession.transfer(flowFile, REL_SUCCESS);
                            processSession.getProvenanceReporter().send(flowFile, this.snmpTarget.getAddress().toString());
                            break block7;
                        }
                        String error = response.getResponse().getErrorStatusText();
                        flowFile = SNMPUtils.addAttribute("snmp$error", error, flowFile, processSession);
                        processSession.transfer(processSession.penalize(flowFile), REL_FAILURE);
                        this.getLogger().error("Failed while executing SNMP Set [{}] via " + this.targetResource + ". Error = {}", new Object[]{response.getRequest().getVariableBindings(), error});
                    }
                    catch (IOException e) {
                        processSession.transfer(processSession.penalize(flowFile), REL_FAILURE);
                        this.getLogger().error("Failed while executing SNMP Set via " + this.targetResource, (Throwable)e);
                        context.yield();
                    }
                } else {
                    processSession.transfer(processSession.penalize(flowFile), REL_FAILURE);
                    this.getLogger().warn("No attributes found in the FlowFile to perform SNMP Set");
                }
            }
        }
    }

    private boolean addVariables(PDU pdu, Map<String, String> attributes) {
        boolean result = false;
        for (Map.Entry<String, String> attributeEntry : attributes.entrySet()) {
            if (!attributeEntry.getKey().startsWith("snmp$")) continue;
            String[] splits = attributeEntry.getKey().split("\\$");
            String snmpPropName = splits[1];
            String snmpPropValue = attributeEntry.getValue();
            if (!SNMPUtils.OID_PATTERN.matcher(snmpPropName).matches()) continue;
            OctetString var = null;
            if (splits.length == 2) {
                var = new OctetString(snmpPropValue);
            } else {
                int smiSyntax = Integer.valueOf(splits[2]);
                var = this.stringToVariable(snmpPropValue, smiSyntax);
            }
            if (var == null) continue;
            VariableBinding varBind = new VariableBinding(new OID(snmpPropName), (Variable)var);
            pdu.add(varBind);
            result = true;
        }
        return result;
    }

    private Variable stringToVariable(String value, int smiSyntax) {
        Variable var = AbstractVariable.createFromSyntax((int)smiSyntax);
        try {
            if (var instanceof AssignableFromString) {
                ((AssignableFromString)var).setValue(value);
            } else if (var instanceof AssignableFromInteger) {
                ((AssignableFromInteger)var).setValue(Integer.valueOf(value).intValue());
            } else if (var instanceof AssignableFromLong) {
                ((AssignableFromLong)var).setValue(Long.valueOf(value).longValue());
            } else {
                this.getLogger().error("Unsupported conversion of [" + value + "] to " + var.getSyntaxString());
                var = null;
            }
        }
        catch (IllegalArgumentException e) {
            this.getLogger().error("Unsupported conversion of [" + value + "] to " + var.getSyntaxString(), (Throwable)e);
            var = null;
        }
        return var;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return propertyDescriptors;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    @Override
    protected SNMPSetter finishBuildingTargetResource(ProcessContext context) {
        return new SNMPSetter(this.snmp, this.snmpTarget);
    }

    static {
        ArrayList _propertyDescriptors = new ArrayList();
        _propertyDescriptors.addAll(descriptors);
        propertyDescriptors = Collections.unmodifiableList(_propertyDescriptors);
        HashSet<Relationship> _relationships = new HashSet<Relationship>();
        _relationships.add(REL_SUCCESS);
        _relationships.add(REL_FAILURE);
        relationships = Collections.unmodifiableSet(_relationships);
    }
}

