/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.io.Closeable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.nifi.annotation.lifecycle.OnAdded;
import org.apache.nifi.annotation.lifecycle.OnConfigurationRestored;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnShutdown;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.annotation.lifecycle.OnUnscheduled;
import org.apache.nifi.components.ConfigurableComponent;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.provenance.ProvenanceEventRecord;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.stateless.bootstrap.InMemoryFlowFile;
import org.apache.nifi.stateless.core.AbstractStatelessComponent;
import org.apache.nifi.stateless.core.ReflectionUtils;
import org.apache.nifi.stateless.core.StatelessComponent;
import org.apache.nifi.stateless.core.StatelessControllerServiceLookup;
import org.apache.nifi.stateless.core.StatelessFlowFile;
import org.apache.nifi.stateless.core.StatelessProcessContext;
import org.apache.nifi.stateless.core.StatelessProcessSession;
import org.apache.nifi.stateless.core.StatelessProcessorInitializationContext;
import org.apache.nifi.stateless.core.StatelessStateManager;

public class StatelessProcessorWrapper
extends AbstractStatelessComponent
implements StatelessComponent {
    private final boolean materializeContent;
    private final Processor processor;
    private final StatelessProcessContext context;
    private final Queue<StatelessFlowFile> inputQueue;
    private final VariableRegistry variableRegistry;
    private final ClassLoader classLoader;
    private final Collection<ProvenanceEventRecord> provenanceEvents;
    private final Set<StatelessProcessSession> createdSessions;
    private final ComponentLog logger;
    private final StatelessControllerServiceLookup lookup;
    private volatile boolean stopRequested = false;
    private volatile boolean isStopped = true;
    private volatile boolean initialized = false;

    public StatelessProcessorWrapper(String id, Processor processor, StatelessProcessorWrapper parent, StatelessControllerServiceLookup lookup, VariableRegistry registry, boolean materializeContent, ClassLoader classLoader, ParameterContext parameterContext) throws InvocationTargetException, IllegalAccessException {
        this.processor = processor;
        this.classLoader = classLoader;
        this.addParent(parent);
        this.lookup = lookup;
        this.materializeContent = materializeContent;
        this.provenanceEvents = new ArrayList<ProvenanceEventRecord>();
        this.createdSessions = new CopyOnWriteArraySet<StatelessProcessSession>();
        this.inputQueue = new LinkedList<StatelessFlowFile>();
        this.variableRegistry = registry;
        this.context = new StatelessProcessContext((ConfigurableComponent)processor, lookup, processor.getIdentifier(), new StatelessStateManager(), this.variableRegistry, parameterContext);
        this.context.setMaxConcurrentTasks(1);
        StatelessProcessorInitializationContext initContext = new StatelessProcessorInitializationContext(id, processor, this.context);
        this.logger = initContext.getLogger();
        try (CloseableNarLoader c = this.withNarClassLoader();){
            processor.initialize((ProcessorInitializationContext)initContext);
            ReflectionUtils.invokeMethodsWithAnnotation(OnAdded.class, processor, new Object[0]);
            ReflectionUtils.quietlyInvokeMethodsWithAnnotation(OnConfigurationRestored.class, processor, new Object[0]);
        }
    }

    private Processor getProcessor() {
        return this.processor;
    }

    @Override
    public Set<Relationship> getRelationships() {
        return this.processor.getRelationships();
    }

    private void initialize() {
        Collection<ValidationResult> validationResult = this.context.validate();
        if (validationResult.stream().anyMatch(a -> !a.isValid()) || !this.validate()) {
            throw new IllegalArgumentException(this.processor + " is not valid: " + validationResult.stream().map(ValidationResult::toString).collect(Collectors.joining("\n")));
        }
        try (CloseableNarLoader c = this.withNarClassLoader();){
            ReflectionUtils.invokeMethodsWithAnnotation(OnScheduled.class, this.processor, this.context);
        }
        catch (Exception e) {
            this.logger.error("Failed to perform @OnScheduled Lifecycle method: ", (Throwable)e);
        }
        this.initialized = true;
    }

    private CloseableNarLoader withNarClassLoader() {
        final ClassLoader contextclassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.classLoader);
        return new CloseableNarLoader(){

            @Override
            public void close() {
                Thread.currentThread().setContextClassLoader(contextclassLoader);
            }
        };
    }

    @Override
    public boolean runRecursive(Queue<InMemoryFlowFile> output) {
        if (!this.initialized) {
            this.initialize();
        }
        AtomicBoolean processingSuccess = new AtomicBoolean(true);
        HashSet<Relationship> outputRelationships = new HashSet<Relationship>(this.getChildren().keySet());
        outputRelationships.addAll(this.getSuccessOutputPorts());
        outputRelationships.addAll(this.getFailureOutputPorts());
        do {
            this.isStopped = false;
            AtomicBoolean nextStepCalled = new AtomicBoolean(false);
            try {
                this.logger.debug("Running {}.onTrigger with {} FlowFiles", new Object[]{this.processor.getClass().getSimpleName(), this.inputQueue.size()});
                try (CloseableNarLoader c = this.withNarClassLoader();){
                    this.processor.onTrigger((ProcessContext)this.context, () -> {
                        StatelessProcessSession session = new StatelessProcessSession(this.inputQueue, this.provenanceEvents, this.processor, outputRelationships, this.materializeContent, () -> {
                            if (!nextStepCalled.get()) {
                                nextStepCalled.set(true);
                                boolean successfulRun = this.runChildren(output);
                                processingSuccess.set(successfulRun);
                            }
                        });
                        this.createdSessions.add(session);
                        return session;
                    });
                }
                if (!nextStepCalled.get()) {
                    nextStepCalled.set(true);
                    boolean successfulRun = this.runChildren(output);
                    processingSuccess.set(successfulRun);
                }
                this.provenanceEvents.clear();
            }
            catch (Exception t) {
                try (CloseableNarLoader c = this.withNarClassLoader();){
                    this.logger.error("Failed to trigger " + this.processor, (Throwable)t);
                }
                return false;
            }
        } while (!this.stopRequested && !this.inputQueue.isEmpty() && processingSuccess.get());
        this.isStopped = true;
        return processingSuccess.get();
    }

    private boolean runChildren(Queue<InMemoryFlowFile> output) {
        Queue<StatelessFlowFile> penalizedFlowFiles = this.getPenalizedFlowFiles();
        if (penalizedFlowFiles.size() > 0) {
            output.addAll(penalizedFlowFiles);
            return false;
        }
        for (Relationship relationship : this.getProcessor().getRelationships()) {
            List<StatelessComponent> childComponents;
            Queue<StatelessFlowFile> files;
            if (this.isAutoTerminated(relationship) || (files = this.getAndRemoveFlowFilesForRelationship(relationship)).size() == 0) continue;
            if (this.getFailureOutputPorts().contains(relationship)) {
                output.addAll(files);
                return false;
            }
            if (this.getSuccessOutputPorts().contains(relationship)) {
                output.addAll(files);
            }
            if ((childComponents = this.getChildren().get(relationship)) == null) continue;
            for (StatelessComponent child : childComponents) {
                child.enqueueAll(files);
                boolean successfulRun = child.runRecursive(output);
                if (successfulRun) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void shutdown() {
        this.stopRequested = true;
        for (Relationship relationship : this.getProcessor().getRelationships()) {
            if (this.isAutoTerminated(relationship)) continue;
            List<StatelessComponent> childComponents = this.getChildren().get(relationship);
            if (childComponents == null) {
                throw new IllegalArgumentException("No child for relationship: " + relationship.getName());
            }
            childComponents.forEach(StatelessComponent::shutdown);
        }
        while (!this.isStopped) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                break;
            }
        }
        try (CloseableNarLoader c = this.withNarClassLoader();){
            ReflectionUtils.invokeMethodsWithAnnotation(OnUnscheduled.class, this.processor, this.context);
            ReflectionUtils.invokeMethodsWithAnnotation(OnStopped.class, this.processor, this.context);
            ReflectionUtils.invokeMethodsWithAnnotation(OnShutdown.class, this.processor, new Object[0]);
        }
        catch (Exception e) {
            this.logger.error("Failed to properly shutdown " + this.processor + ": ", (Throwable)e);
        }
        this.logger.info(this.processor.getClass().getSimpleName() + " shutdown");
    }

    @Override
    public void enqueueAll(Queue<StatelessFlowFile> list) {
        this.inputQueue.addAll(list);
    }

    public Queue<StatelessFlowFile> getAndRemoveFlowFilesForRelationship(Relationship relationship) {
        Queue sortedList = this.createdSessions.stream().flatMap(s -> s.getAndRemoveFlowFilesForRelationship(relationship).stream()).sorted(Comparator.comparing(StatelessFlowFile::getCreationTime)).collect(Collectors.toCollection(LinkedList::new));
        return sortedList;
    }

    public Queue<StatelessFlowFile> getPenalizedFlowFiles() {
        Queue sortedList = this.createdSessions.stream().flatMap(s -> s.getPenalizedFlowFiles().stream()).sorted(Comparator.comparing(StatelessFlowFile::getCreationTime)).collect(Collectors.toCollection(LinkedList::new));
        return sortedList;
    }

    public ValidationResult setProperty(PropertyDescriptor property, String propertyValue) {
        return this.context.setProperty(property, propertyValue);
    }

    public ValidationResult setProperty(String propertyName, String propertyValue) {
        return this.context.setProperty(propertyName, propertyValue);
    }

    public void setAnnotationData(String annotationData) {
        this.context.setAnnotationData(annotationData);
    }

    @Override
    public boolean isMaterializeContent() {
        return this.materializeContent;
    }

    @Override
    public ComponentLog getLogger() {
        return this.logger;
    }

    @Override
    protected StatelessProcessContext getContext() {
        return this.context;
    }

    private static interface CloseableNarLoader
    extends Closeable {
        @Override
        public void close();
    }
}

