/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.bundle.BundleCoordinate;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.state.StateManager;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.exception.ControllerServiceInstantiationException;
import org.apache.nifi.controller.exception.ProcessorInstantiationException;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.nar.InstanceClassLoader;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.processor.Processor;
import org.apache.nifi.processor.ProcessorInitializationContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.registry.flow.Bundle;
import org.apache.nifi.registry.flow.VersionedControllerService;
import org.apache.nifi.registry.flow.VersionedProcessor;
import org.apache.nifi.stateless.core.SLF4JComponentLog;
import org.apache.nifi.stateless.core.StatelessControllerServiceInitializationContext;
import org.apache.nifi.stateless.core.StatelessControllerServiceLookup;
import org.apache.nifi.stateless.core.StatelessProcessorInitializationContext;
import org.apache.nifi.stateless.core.StatelessProcessorWrapper;
import org.apache.nifi.util.file.classloader.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComponentFactory {
    private static final Logger logger = LoggerFactory.getLogger(ComponentFactory.class);
    private final ExtensionManager extensionManager;

    public ComponentFactory(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }

    public StatelessProcessorWrapper createProcessor(VersionedProcessor versionedProcessor, boolean materializeContent, StatelessControllerServiceLookup controllerServiceLookup, VariableRegistry variableRegistry, Set<URL> classpathUrls, ParameterContext parameterContext) throws ProcessorInstantiationException {
        String type = versionedProcessor.getType();
        String identifier = versionedProcessor.getIdentifier();
        org.apache.nifi.bundle.Bundle bundle = this.getAvailableBundle(versionedProcessor.getBundle(), type);
        if (bundle == null) {
            throw new IllegalStateException("Unable to find bundle for coordinate " + versionedProcessor.getBundle().getGroup() + ":" + versionedProcessor.getBundle().getArtifact() + ":" + versionedProcessor.getBundle().getVersion());
        }
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Set<URL> additionalClasspathUrls;
            InstanceClassLoader detectedClassLoader = this.extensionManager.createInstanceClassLoader(type, identifier, bundle, classpathUrls == null ? Collections.emptySet() : classpathUrls);
            logger.debug("Setting context class loader to {} (parent = {}) to create {}", new Object[]{detectedClassLoader, detectedClassLoader.getParent(), type});
            Class<?> rawClass = Class.forName(type, true, (ClassLoader)detectedClassLoader);
            Thread.currentThread().setContextClassLoader((ClassLoader)detectedClassLoader);
            Object extensionInstance = rawClass.newInstance();
            SLF4JComponentLog componentLog = new SLF4JComponentLog(extensionInstance);
            Processor processor = (Processor)extensionInstance;
            StatelessProcessorInitializationContext initializationContext = new StatelessProcessorInitializationContext(versionedProcessor.getIdentifier(), processor, controllerServiceLookup);
            processor.initialize((ProcessorInitializationContext)initializationContext);
            if (classpathUrls == null && !(additionalClasspathUrls = this.getAdditionalClasspathResources(processor.getPropertyDescriptors(), processor.getIdentifier(), versionedProcessor.getProperties(), (ParameterLookup)parameterContext, variableRegistry, componentLog)).isEmpty()) {
                StatelessProcessorWrapper statelessProcessorWrapper = this.createProcessor(versionedProcessor, materializeContent, controllerServiceLookup, variableRegistry, additionalClasspathUrls, parameterContext);
                return statelessProcessorWrapper;
            }
            StatelessProcessorWrapper processorWrapper = new StatelessProcessorWrapper(versionedProcessor.getIdentifier(), processor, null, controllerServiceLookup, variableRegistry, materializeContent, (ClassLoader)detectedClassLoader, parameterContext);
            processorWrapper.setAnnotationData(versionedProcessor.getAnnotationData());
            versionedProcessor.getProperties().forEach(processorWrapper::setProperty);
            for (String relationship : versionedProcessor.getAutoTerminatedRelationships()) {
                processorWrapper.addAutoTermination(new Relationship.Builder().name(relationship).build());
            }
            StatelessProcessorWrapper statelessProcessorWrapper = processorWrapper;
            return statelessProcessorWrapper;
        }
        catch (Exception e) {
            throw new ProcessorInstantiationException(type, (Throwable)e);
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }

    private Set<URL> getAdditionalClasspathResources(List<PropertyDescriptor> propertyDescriptors, String componentId, Map<String, String> properties, ParameterLookup parameterLookup, VariableRegistry variableRegistry, ComponentLog logger) {
        LinkedHashSet<String> modulePaths = new LinkedHashSet<String>();
        for (PropertyDescriptor descriptor : propertyDescriptors) {
            String value;
            if (!descriptor.isDynamicClasspathModifier() || StringUtils.isEmpty((CharSequence)(value = properties.get(descriptor.getName())))) continue;
            StandardPropertyValue propertyValue = new StandardPropertyValue(value, null, parameterLookup, variableRegistry);
            modulePaths.add(propertyValue.evaluateAttributeExpressions().getValue());
        }
        LinkedHashSet<URL> additionalUrls = new LinkedHashSet<URL>();
        try {
            URL[] urls = ClassLoaderUtils.getURLsForClasspath(modulePaths, null, (boolean)true);
            if (urls != null) {
                additionalUrls.addAll(Arrays.asList(urls));
            }
        }
        catch (MalformedURLException mfe) {
            logger.error("Error processing classpath resources for " + componentId + ": " + mfe.getMessage(), (Throwable)mfe);
        }
        return additionalUrls;
    }

    public ControllerService createControllerService(VersionedControllerService versionedControllerService, VariableRegistry variableRegistry, ControllerServiceLookup serviceLookup, StateManager stateManager, ParameterLookup parameterLookup) {
        return this.createControllerService(versionedControllerService, variableRegistry, null, serviceLookup, stateManager, parameterLookup);
    }

    private ControllerService createControllerService(VersionedControllerService versionedControllerService, VariableRegistry variableRegistry, Set<URL> classpathUrls, ControllerServiceLookup serviceLookup, StateManager stateManager, ParameterLookup parameterLookup) {
        String type = versionedControllerService.getType();
        String identifier = versionedControllerService.getIdentifier();
        org.apache.nifi.bundle.Bundle bundle = this.getAvailableBundle(versionedControllerService.getBundle(), type);
        if (bundle == null) {
            throw new IllegalStateException("Unable to find bundle for coordinate " + versionedControllerService.getBundle().getGroup() + ":" + versionedControllerService.getBundle().getArtifact() + ":" + versionedControllerService.getBundle().getVersion());
        }
        ClassLoader ctxClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Set<URL> additionalClasspathUrls;
            InstanceClassLoader detectedClassLoader = this.extensionManager.createInstanceClassLoader(type, identifier, bundle, classpathUrls == null ? Collections.emptySet() : classpathUrls);
            logger.debug("Setting context class loader to {} (parent = {}) to create {}", new Object[]{detectedClassLoader, detectedClassLoader.getParent(), type});
            Class<?> rawClass = Class.forName(type, true, (ClassLoader)detectedClassLoader);
            Thread.currentThread().setContextClassLoader((ClassLoader)detectedClassLoader);
            Object extensionInstance = rawClass.newInstance();
            SLF4JComponentLog componentLog = new SLF4JComponentLog(extensionInstance);
            ControllerService service = (ControllerService)extensionInstance;
            StatelessControllerServiceInitializationContext initializationContext = new StatelessControllerServiceInitializationContext(identifier, service, serviceLookup, stateManager);
            service.initialize((ControllerServiceInitializationContext)initializationContext);
            if (classpathUrls == null && !(additionalClasspathUrls = this.getAdditionalClasspathResources(service.getPropertyDescriptors(), service.getIdentifier(), versionedControllerService.getProperties(), parameterLookup, variableRegistry, componentLog)).isEmpty()) {
                ControllerService controllerService = this.createControllerService(versionedControllerService, variableRegistry, additionalClasspathUrls, serviceLookup, stateManager, parameterLookup);
                return controllerService;
            }
            ControllerService controllerService = service;
            return controllerService;
        }
        catch (Exception e) {
            throw new ControllerServiceInstantiationException(type, (Throwable)e);
        }
        finally {
            if (ctxClassLoader != null) {
                Thread.currentThread().setContextClassLoader(ctxClassLoader);
            }
        }
    }

    private org.apache.nifi.bundle.Bundle getAvailableBundle(Bundle bundle, String componentType) {
        BundleCoordinate bundleCoordinate = new BundleCoordinate(bundle.getGroup(), bundle.getArtifact(), bundle.getVersion());
        org.apache.nifi.bundle.Bundle availableBundle = this.extensionManager.getBundle(bundleCoordinate);
        if (availableBundle != null) {
            return availableBundle;
        }
        List possibleBundles = this.extensionManager.getBundles(componentType);
        if (possibleBundles.isEmpty()) {
            throw new IllegalStateException("Could not find any NiFi Bundles that contain the Extension [" + componentType + "]");
        }
        if (possibleBundles.size() > 1) {
            throw new IllegalStateException("Found " + possibleBundles.size() + " different NiFi Bundles that contain the Extension [" + componentType + "] but none of them had a version of " + bundle.getVersion());
        }
        return (org.apache.nifi.bundle.Bundle)possibleBundles.get(0);
    }
}

