/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.core;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.controller.PropertyConfiguration;
import org.apache.nifi.parameter.ParameterContext;
import org.apache.nifi.parameter.ParameterLookup;
import org.apache.nifi.registry.VariableRegistry;
import org.apache.nifi.stateless.core.StatelessPropertyValue;

public class StatelessConfigurationContext
implements ConfigurationContext {
    private final Map<PropertyDescriptor, PropertyConfiguration> properties;
    private final ControllerServiceLookup serviceLookup;
    private final ControllerService service;
    private final VariableRegistry variableRegistry;
    private final ParameterContext parameterContext;

    public StatelessConfigurationContext(ControllerService service, Map<PropertyDescriptor, PropertyConfiguration> properties, ControllerServiceLookup serviceLookup, VariableRegistry variableRegistry, ParameterContext parameterLookup) {
        this.service = service;
        this.properties = properties;
        this.serviceLookup = serviceLookup;
        this.variableRegistry = variableRegistry;
        this.parameterContext = parameterLookup;
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        PropertyConfiguration setPropertyValue = this.properties.get(property);
        String propValue = setPropertyValue == null ? this.getActualDescriptor(property).getDefaultValue() : setPropertyValue.getEffectiveValue((ParameterLookup)this.parameterContext);
        return new StatelessPropertyValue(propValue, this.serviceLookup, (ParameterLookup)this.parameterContext, this.variableRegistry);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        List supported = this.service.getPropertyDescriptors();
        LinkedHashMap<PropertyDescriptor, String> effectiveValues = new LinkedHashMap<PropertyDescriptor, String>();
        for (PropertyDescriptor propertyDescriptor : supported) {
            effectiveValues.put(propertyDescriptor, null);
        }
        for (Map.Entry entry : this.properties.entrySet()) {
            PropertyDescriptor descriptor = (PropertyDescriptor)entry.getKey();
            PropertyConfiguration configuration = (PropertyConfiguration)entry.getValue();
            String value = configuration.getEffectiveValue((ParameterLookup)this.parameterContext);
            effectiveValues.put(descriptor, value);
        }
        return effectiveValues;
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    private PropertyDescriptor getActualDescriptor(PropertyDescriptor property) {
        if (this.service == null) {
            return property;
        }
        PropertyDescriptor resolved = this.service.getPropertyDescriptor(property.getName());
        return resolved == null ? property : resolved;
    }

    public String getSchedulingPeriod() {
        return "0 secs";
    }

    public Long getSchedulingPeriod(TimeUnit timeUnit) {
        return 0L;
    }

    public String getName() {
        return null;
    }
}

