/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.runtimes;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.apache.nifi.stateless.bootstrap.InMemoryFlowFile;
import org.apache.nifi.stateless.core.StatelessFlow;
import org.apache.nifi.stateless.core.security.StatelessSecurityUtility;
import org.apache.nifi.stateless.runtimes.openwhisk.StatelessNiFiOpenWhiskAction;
import org.apache.nifi.stateless.runtimes.yarn.YARNServiceUtil;

public class Program {
    public static final String RUN_FROM_REGISTRY = "RunFromRegistry";
    public static final String RUN_YARN_SERVICE_FROM_REGISTRY = "RunYARNServiceFromRegistry";
    public static final String RUN_OPENWHISK_ACTION_SERVER = "RunOpenwhiskActionServer";
    public static final String SENSITIVE_TRUE_JSON_SEGMENT = "\"sensitive\"\\s*:\\s*\"true\"";
    public static final String PASSWORD_SEGMENT = "password";
    public static final String TOKEN_SEGMENT = "token";
    public static final String ACCESS_SEGMENT = "access";
    public static final String SECRET_SEGMENT = "secret";
    public static final String API_KEY_SEGMENT = "api_key";
    public static final List<String> SENSITIVE_INDICATORS = Arrays.asList("\"sensitive\"\\s*:\\s*\"true\"", "password", "token", "access", "secret", "api_key");
    public static final String JSON_FLAG = "--json";
    public static final String FILE_FLAG = "--file";
    public static final String YARN_JSON_FLAG = "--yarnjson";
    private static boolean isVerbose = true;

    public static void launch(String[] args, ClassLoader systemClassLoader, File narWorkingDirectory) throws Exception {
        String hadoopTokenFileLocation = System.getenv("HADOOP_TOKEN_FILE_LOCATION");
        if (hadoopTokenFileLocation != null && !hadoopTokenFileLocation.equals("")) {
            File targetFile = new File(hadoopTokenFileLocation);
            File parent = targetFile.getParentFile();
            if (!parent.exists() && !parent.mkdirs()) {
                throw new IllegalStateException("Couldn't create dir: " + parent);
            }
            try (FileOutputStream fos = new FileOutputStream(targetFile);){
                fos.write("HDTS".getBytes(StandardCharsets.UTF_8));
                fos.write(0);
                fos.write(0);
                fos.write(0);
            }
            System.out.println("Created empty hadoop token file: " + System.getenv("HADOOP_TOKEN_FILE_LOCATION"));
        }
        if (args.length == 0) {
            Program.printUsage();
            System.exit(1);
        } else if (args[0].equals(RUN_FROM_REGISTRY) && (args[1].equalsIgnoreCase("Once") || args[1].equalsIgnoreCase("Continuous")) && args.length >= 4) {
            Program.runLocal(args, systemClassLoader, narWorkingDirectory);
        } else if (args[0].equals(RUN_YARN_SERVICE_FROM_REGISTRY) && args.length >= 7) {
            Program.runOnYarn(args);
        } else if (args[0].equals(RUN_OPENWHISK_ACTION_SERVER) && args.length == 2) {
            Program.runOnOpenWhisk(args, systemClassLoader, narWorkingDirectory);
        } else {
            System.out.println("Invalid input: " + Program.formatArgs(args));
            Program.printUsage();
            System.exit(1);
        }
    }

    private static void runOnOpenWhisk(String[] args, ClassLoader systemClassLoader, File narWorkingDirectory) throws IOException {
        StatelessNiFiOpenWhiskAction action = new StatelessNiFiOpenWhiskAction(Integer.parseInt(args[1]), systemClassLoader, narWorkingDirectory);
        action.start();
    }

    private static void runOnYarn(String[] args) throws IOException {
        String json;
        String YARNUrl = args[1];
        String imageName = args[2];
        String serviceName = args[3];
        int numberOfContainers = Integer.parseInt(args[4]);
        if (args[5].equals(FILE_FLAG)) {
            json = new String(Files.readAllBytes(Paths.get(args[6], new String[0])));
        } else if (args[5].equals(JSON_FLAG)) {
            json = args[6];
        } else {
            System.out.println("Invalid input: " + Program.formatArgs(args));
            Program.printUsage();
            System.exit(1);
            return;
        }
        String[] launchCommand = new String[]{RUN_FROM_REGISTRY, "Continuous", JSON_FLAG, new JsonParser().parse(json).toString()};
        StringBuilder message = new StringBuilder();
        YARNServiceUtil yarnServiceUtil = new YARNServiceUtil(YARNUrl, imageName);
        yarnServiceUtil.launchYARNService(serviceName, numberOfContainers, launchCommand, message);
        System.out.println(message);
    }

    private static void runLocal(String[] args, ClassLoader systemClassLoader, File narWorkingDirectory) throws Exception {
        String json;
        boolean once = args[1].equalsIgnoreCase("Once");
        if (args[2].equals(FILE_FLAG)) {
            json = new String(Files.readAllBytes(Paths.get(args[3], new String[0])));
        } else if (args[2].equals(JSON_FLAG)) {
            json = args[3];
        } else if (args[2].equals(YARN_JSON_FLAG)) {
            json = args[3].replace(';', ',');
        } else {
            System.out.println("Invalid input: " + Program.formatArgs(args));
            Program.printUsage();
            System.exit(1);
            return;
        }
        JsonObject jsonObject = new JsonParser().parse(json).getAsJsonObject();
        System.out.println("Running from json: " + StatelessSecurityUtility.formatJson(jsonObject));
        StatelessFlow flow = StatelessFlow.createAndEnqueueFromJSON(jsonObject, systemClassLoader, narWorkingDirectory);
        LinkedList<InMemoryFlowFile> outputFlowFiles = new LinkedList<InMemoryFlowFile>();
        boolean successful = once ? flow.runOnce(outputFlowFiles) : flow.run(outputFlowFiles);
        if (successful) {
            System.out.println("Flow Succeeded");
            if (isVerbose) {
                outputFlowFiles.forEach(f -> System.out.println(f.toStringFull()));
            }
        } else {
            System.out.println("Flow Failed");
            if (isVerbose) {
                outputFlowFiles.forEach(f -> System.out.println(f.toStringFull()));
            }
            System.exit(1);
        }
    }

    public static boolean isVerbose() {
        return isVerbose;
    }

    static String formatArgs(String[] args) {
        return StatelessSecurityUtility.formatArgs(args, Program.isVerbose());
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println("       RunFromRegistry [Once|Continuous] --json <JSON>");
        System.out.println("       RunFromRegistry [Once|Continuous] --file <File Name>");
        System.out.println();
        System.out.println("       RunYARNServiceFromRegistry        <YARN RM URL> <Docker Image Name> <Service Name> <# of Containers> --json <JSON>");
        System.out.println("       RunYARNServiceFromRegistry        <YARN RM URL> <Docker Image Name> <Service Name> <# of Containers> --file <File Name>");
        System.out.println();
        System.out.println("    3) RunOpenwhiskActionServer          <Port>");
        System.out.println();
        System.out.println("Examples:");
        System.out.println("    1) RunFromRegistry Once --json \"{\\\"registryUrl\\\":\\\"http://172.26.198.107:61080\\\",\\\"bucketId\\\":\\\"5eec8794-01b3-4cd7-8536-0167c8b4ce8c\\\",\\\"flowId\\\": \\\"c5fa1d4f-b453-4bf5-8ff3-352352c418f3\\\"}\"");
        System.out.println("    2) RunYARNServiceFromRegistry http://127.0.0.1:8088 nifi-stateless:latest kafka-to-solr 3 --file kafka-to-solr.json");
        System.out.println("    3) RunOpenwhiskActionServer 8080");
        System.out.println();
        System.out.println("Notes:");
        System.out.println("    1) The configuration file must be in JSON format. ");
        System.out.println("    2) When providing configurations via JSON, the following attributes must be provided: registryUrl, bucketId, flowId.");
        System.out.println("          All other attributes will be passed to the flow using the variable registry interface");
        System.out.println();
    }
}

