/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.stateless.runtimes.openwhisk;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.nifi.stateless.bootstrap.InMemoryFlowFile;
import org.apache.nifi.stateless.bootstrap.RunnableFlow;
import org.apache.nifi.stateless.core.StatelessFlow;
import org.apache.nifi.stateless.core.security.StatelessSecurityUtility;

public class StatelessNiFiOpenWhiskAction {
    private HttpServer server;
    private boolean initialized = false;
    private RunnableFlow flow = null;
    private ClassLoader systemClassLoader;
    private File narWorkingDirectory;

    public StatelessNiFiOpenWhiskAction(int port, ClassLoader systemClassLoader, File narWorkingDirectory) throws IOException {
        this.systemClassLoader = systemClassLoader;
        this.narWorkingDirectory = narWorkingDirectory;
        this.server = HttpServer.create(new InetSocketAddress(port), -1);
        this.server.createContext("/init", new InitHandler());
        this.server.createContext("/run", new RunHandler());
        this.server.setExecutor(null);
    }

    public void start() {
        this.server.start();
    }

    private static void writeResponse(HttpExchange t, int code, String content) throws IOException {
        if (content.isEmpty()) {
            content = "success";
        }
        JsonObject message = new JsonObject();
        message.addProperty("result", content);
        byte[] bytes = message.toString().getBytes(StandardCharsets.UTF_8);
        t.sendResponseHeaders(code, bytes.length);
        OutputStream os = t.getResponseBody();
        os.write(bytes);
        os.close();
    }

    private static void writeLogMarkers() {
        System.out.println("XXX_THE_END_OF_A_WHISK_ACTIVATION_XXX");
        System.err.println("XXX_THE_END_OF_A_WHISK_ACTIVATION_XXX");
        System.out.flush();
        System.err.flush();
    }

    private class RunHandler
    implements HttpHandler {
        private RunHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void handle(HttpExchange t) throws IOException {
            if (!StatelessNiFiOpenWhiskAction.this.initialized) {
                StatelessNiFiOpenWhiskAction.writeResponse(t, 500, "Cannot invoke an uninitialized action.");
                return;
            }
            try {
                boolean successful;
                InputStream is = t.getRequestBody();
                JsonParser parser = new JsonParser();
                JsonObject body = parser.parse((Reader)new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8))).getAsJsonObject();
                JsonObject inputObject = body.getAsJsonObject("value");
                LinkedList<InMemoryFlowFile> output = new LinkedList<InMemoryFlowFile>();
                if (StatelessNiFiOpenWhiskAction.this.flow == null) {
                    System.out.println(StatelessSecurityUtility.formatJson(inputObject));
                    JsonObject config = new JsonParser().parse(inputObject.get("code").getAsJsonPrimitive().getAsString()).getAsJsonObject();
                    StatelessFlow tempFlow = StatelessFlow.createAndEnqueueFromJSON(config, StatelessNiFiOpenWhiskAction.this.systemClassLoader, StatelessNiFiOpenWhiskAction.this.narWorkingDirectory);
                    successful = tempFlow.runOnce(output);
                } else {
                    System.out.println("Input: " + StatelessSecurityUtility.formatJson(inputObject));
                    Map<String, String> Attributes = inputObject.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, item -> ((JsonElement)item.getValue()).getAsString()));
                    ((StatelessFlow)StatelessNiFiOpenWhiskAction.this.flow).enqueueFlowFile(new byte[0], Attributes);
                    successful = StatelessNiFiOpenWhiskAction.this.flow.runOnce(output);
                }
                StringBuilder response = new StringBuilder();
                for (InMemoryFlowFile flowFile : output) {
                    response.append("\n").append(flowFile);
                }
                StatelessNiFiOpenWhiskAction.writeResponse(t, successful ? 200 : 500, response.toString());
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String sStackTrace = sw.toString();
                StatelessNiFiOpenWhiskAction.writeResponse(t, 500, "An error has occurred (see logs for details): " + e.getMessage() + "\n" + sStackTrace);
            }
            finally {
                StatelessNiFiOpenWhiskAction.writeLogMarkers();
            }
        }
    }

    private class InitHandler
    implements HttpHandler {
        private InitHandler() {
        }

        @Override
        public void handle(HttpExchange t) throws IOException {
            System.out.println("Initializing");
            try {
                InputStream is = t.getRequestBody();
                JsonParser parser = new JsonParser();
                JsonObject body = parser.parse((Reader)new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8))).getAsJsonObject();
                System.out.println("Init input: " + body);
                String code = body.get("value").getAsJsonObject().get("code").getAsJsonPrimitive().getAsString();
                System.out.println("Code input: " + code);
                if (code.equals("GENERIC")) {
                    StatelessNiFiOpenWhiskAction.this.initialized = true;
                    StatelessNiFiOpenWhiskAction.writeResponse(t, 200, "Initialized Generic Action");
                } else {
                    JsonObject config = new JsonParser().parse(code).getAsJsonObject();
                    StatelessNiFiOpenWhiskAction.this.flow = StatelessFlow.createAndEnqueueFromJSON(config, StatelessNiFiOpenWhiskAction.this.systemClassLoader, StatelessNiFiOpenWhiskAction.this.narWorkingDirectory);
                    StatelessNiFiOpenWhiskAction.this.initialized = true;
                    StatelessNiFiOpenWhiskAction.writeResponse(t, 200, "Initialized Flow");
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                e.printStackTrace(pw);
                String sStackTrace = sw.toString();
                StatelessNiFiOpenWhiskAction.writeResponse(t, 500, "Error: " + e.getMessage() + "\n" + sStackTrace);
            }
        }
    }
}

