/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store;

import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dd.TCleanup;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.ProcessConf;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessCleanupConfImpl {
    protected static Log __log = LogFactory.getLog(ProcessCleanupConfImpl.class);
    private final Set<ProcessConf.CLEANUP_CATEGORY> successCategories = EnumSet.noneOf(ProcessConf.CLEANUP_CATEGORY.class);
    private final Set<ProcessConf.CLEANUP_CATEGORY> failureCategories = EnumSet.noneOf(ProcessConf.CLEANUP_CATEGORY.class);

    public ProcessCleanupConfImpl(TDeployment.Process pinfo) {
        for (TCleanup cleanup : pinfo.getCleanupList()) {
            if (cleanup.getOn() == TCleanup.On.SUCCESS || cleanup.getOn() == TCleanup.On.ALWAYS) {
                this.processACleanup(this.successCategories, cleanup.getCategoryList());
            }
            if (cleanup.getOn() != TCleanup.On.FAILURE && cleanup.getOn() != TCleanup.On.ALWAYS) continue;
            this.processACleanup(this.failureCategories, cleanup.getCategoryList());
        }
        Set<ProcessConf.CLEANUP_CATEGORY> categories = this.getCleanupCategories(true);
        if (categories.contains(ProcessConf.CLEANUP_CATEGORY.INSTANCE) && !categories.containsAll(EnumSet.of(ProcessConf.CLEANUP_CATEGORY.CORRELATIONS, ProcessConf.CLEANUP_CATEGORY.VARIABLES))) {
            throw new ContextException("Cleanup configuration error: the instance category requires both the correlations and variables categories specified together!!!");
        }
        categories = this.getCleanupCategories(false);
        if (categories.contains(ProcessConf.CLEANUP_CATEGORY.INSTANCE) && !categories.containsAll(EnumSet.of(ProcessConf.CLEANUP_CATEGORY.CORRELATIONS, ProcessConf.CLEANUP_CATEGORY.VARIABLES))) {
            throw new ContextException("Cleanup configuration error: the instance category requires both the correlations and variables categories specified together!!!");
        }
    }

    private void processACleanup(Set<ProcessConf.CLEANUP_CATEGORY> categories, List<TCleanup.Category.Enum> categoryList) {
        if (categoryList.isEmpty()) {
            categories.addAll(EnumSet.allOf(ProcessConf.CLEANUP_CATEGORY.class));
        } else {
            for (TCleanup.Category.Enum aCategory : categoryList) {
                if (aCategory == TCleanup.Category.ALL) {
                    categories.addAll(EnumSet.allOf(ProcessConf.CLEANUP_CATEGORY.class));
                    continue;
                }
                categories.add(ProcessConf.CLEANUP_CATEGORY.fromString((String)aCategory.toString()));
            }
        }
    }

    public boolean isCleanupCategoryEnabled(boolean instanceSucceeded, ProcessConf.CLEANUP_CATEGORY category) {
        if (instanceSucceeded) {
            return this.successCategories.contains(category);
        }
        return this.failureCategories.contains(category);
    }

    public Set<ProcessConf.CLEANUP_CATEGORY> getCleanupCategories(boolean instanceSucceeded) {
        return instanceSucceeded ? this.successCategories : this.failureCategories;
    }
}

