/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.wsdl.Definition;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.dd.TInvoke;
import org.apache.ode.bpel.dd.TMexInterceptor;
import org.apache.ode.bpel.dd.TProcessEvents;
import org.apache.ode.bpel.dd.TProvide;
import org.apache.ode.bpel.dd.TScopeEvents;
import org.apache.ode.bpel.dd.TService;
import org.apache.ode.bpel.evt.BpelEvent;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.Endpoint;
import org.apache.ode.bpel.iapi.EndpointReference;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.store.DeploymentUnitDir;
import org.apache.ode.store.ProcessCleanupConfImpl;
import org.apache.ode.utils.CollectionUtils;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.HierarchicalProperties;
import org.apache.ode.utils.WatchDog;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessConfImpl
implements ProcessConf {
    private static final Log __log = LogFactory.getLog(ProcessConfImpl.class);
    private final Date _deployDate;
    private File _configDir;
    private final Map<QName, Node> _props;
    private final HashMap<String, Endpoint> _partnerRoleInitialValues = new HashMap();
    private final HashMap<String, Endpoint> _myRoleEndpoints = new HashMap();
    private final ArrayList<QName> _sharedServices = new ArrayList();
    private final Map<String, Set<BpelEvent.TYPE>> _events = new HashMap<String, Set<BpelEvent.TYPE>>();
    private final ArrayList<String> _mexi = new ArrayList();
    ProcessState _state;
    final TDeployment.Process _pinfo;
    final DeploymentUnitDir _du;
    private long _version = 0L;
    private QName _pid;
    private QName _type;
    private volatile boolean _inMemory = false;
    private WatchDog<Map<File, Long>, PropertiesObserver> propertiesWatchDog;
    private EndpointReferenceContext eprContext;
    private final ProcessCleanupConfImpl processCleanupConfImpl;

    public ProcessConfImpl(QName pid, QName type, long version, DeploymentUnitDir du, TDeployment.Process pinfo, Date deployDate, Map<QName, Node> props, ProcessState pstate, EndpointReferenceContext eprContext, File configDir) {
        this._pid = pid;
        this._version = version;
        this._du = du;
        this._pinfo = pinfo;
        this._deployDate = deployDate;
        this._configDir = configDir;
        this._props = Collections.unmodifiableMap(props);
        this._state = pstate;
        this._type = type;
        this._inMemory = this._pinfo.isSetInMemory() && this._pinfo.getInMemory();
        this.eprContext = eprContext;
        this.propertiesWatchDog = new WatchDog((WatchDog.Mutable)new PropertiesMutable(), (WatchDog.Observer)new PropertiesObserver());
        this.initLinks();
        this.initMexInterceptors();
        this.initEventList();
        this.processCleanupConfImpl = new ProcessCleanupConfImpl(pinfo);
    }

    private List<File> collectEndpointConfigFiles() {
        ArrayList<File> propFiles = new ArrayList<File>();
        propFiles.addAll(this._du.getEndpointConfigFiles());
        if (this._configDir == null) {
            if (__log.isDebugEnabled()) {
                __log.debug((Object)"No config directory set up.");
            }
        } else if (this._configDir.isDirectory()) {
            Object[] files = this._configDir.listFiles(new FileFilter(){

                public boolean accept(File path) {
                    return path.getName().endsWith(".endpoint") && path.isFile();
                }
            });
            if (files != null) {
                Arrays.sort(files);
                propFiles.addAll(Arrays.asList(files));
            } else if (__log.isErrorEnabled()) {
                __log.error((Object)(this._configDir + " does not exist or is not a directory"));
            }
        } else if (__log.isErrorEnabled()) {
            __log.error((Object)(this._configDir + " does not exist or is not a directory"));
        }
        return propFiles;
    }

    private void initMexInterceptors() {
        if (this._pinfo.getMexInterceptors() != null) {
            for (TMexInterceptor mexInterceptor : this._pinfo.getMexInterceptors().getMexInterceptorList()) {
                this._mexi.add(mexInterceptor.getClassName());
            }
        }
    }

    private void initLinks() {
        TService service;
        String plinkName;
        if (this._pinfo.getInvokeList() != null) {
            for (TInvoke invoke : this._pinfo.getInvokeList()) {
                plinkName = invoke.getPartnerLink();
                service = invoke.getService();
                if (service == null) continue;
                __log.debug((Object)("Processing <invoke> element for process " + this._pinfo.getName() + ": partnerlink " + plinkName + " --> " + service));
                this._partnerRoleInitialValues.put(plinkName, new Endpoint(service.getName(), service.getPort()));
            }
        }
        if (this._pinfo.getProvideList() != null) {
            for (TProvide provide : this._pinfo.getProvideList()) {
                plinkName = provide.getPartnerLink();
                service = provide.getService();
                if (service == null) {
                    String errmsg = "Error in <provide> element for process " + this._pinfo.getName() + "; partnerlink " + plinkName + "did not identify an endpoint";
                    __log.error((Object)errmsg);
                    throw new ContextException(errmsg);
                }
                __log.debug((Object)("Processing <provide> element for process " + this._pinfo.getName() + ": partnerlink " + plinkName + " --> " + service.getName() + " : " + service.getPort()));
                this._myRoleEndpoints.put(plinkName, new Endpoint(service.getName(), service.getPort()));
                if (!provide.isSetEnableSharing()) continue;
                this._sharedServices.add(service.getName());
            }
        }
    }

    public Date getDeployDate() {
        return this._deployDate;
    }

    public List<File> getFiles() {
        return this._du.allFiles();
    }

    public QName getProcessId() {
        return this._pid;
    }

    public QName getType() {
        return this._pinfo.getType() == null ? this._type : this._pinfo.getType();
    }

    public String getPackage() {
        return this._du.getName();
    }

    public Map<QName, Node> getProcessProperties() {
        return this._props;
    }

    public long getVersion() {
        return this._version;
    }

    public InputStream getCBPInputStream() {
        DeploymentUnitDir.CBPInfo cbpInfo = this._du.getCBPInfo(this.getType());
        if (cbpInfo == null) {
            throw new ContextException("CBP record not found for type " + this.getType());
        }
        try {
            return new FileInputStream(cbpInfo.cbp);
        }
        catch (FileNotFoundException e) {
            throw new ContextException("File Not Found: " + cbpInfo.cbp, (Throwable)e);
        }
    }

    public String getBpelDocument() {
        DeploymentUnitDir.CBPInfo cbpInfo = this._du.getCBPInfo(this.getType());
        if (cbpInfo == null) {
            throw new ContextException("CBP record not found for type " + this.getType());
        }
        try {
            String relative = this.getRelativePath(this._du.getDeployDir(), cbpInfo.cbp).replaceAll("\\\\", "/");
            if (!relative.endsWith(".cbp")) {
                throw new ContextException("CBP file must end with .cbp suffix: " + cbpInfo.cbp);
            }
            relative = relative.replace(".cbp", ".bpel");
            File bpelFile = new File(this._du.getDeployDir(), relative);
            if (!bpelFile.exists()) {
                __log.warn((Object)("BPEL file does not exist: " + bpelFile));
            }
            return relative;
        }
        catch (IOException e) {
            throw new ContextException("IOException in getBpelRelativePath: " + cbpInfo.cbp, (Throwable)e);
        }
    }

    public URI getBaseURI() {
        return this._du.getDeployDir().toURI();
    }

    public ProcessState getState() {
        return this._state;
    }

    public void setState(ProcessState state) {
        this._state = state;
    }

    public List<String> getMexInterceptors(QName processId) {
        return Collections.unmodifiableList(this._mexi);
    }

    public Definition getDefinitionForService(QName serviceName) {
        return this._du.getDefinitionForService(serviceName);
    }

    public Map<String, Endpoint> getInvokeEndpoints() {
        return Collections.unmodifiableMap(this._partnerRoleInitialValues);
    }

    public Map<String, Endpoint> getProvideEndpoints() {
        return Collections.unmodifiableMap(this._myRoleEndpoints);
    }

    public boolean isSharedService(QName serviceName) {
        return this._sharedServices.contains(serviceName);
    }

    public DeploymentUnitDir getDeploymentUnit() {
        return this._du;
    }

    public boolean isTransient() {
        return this._inMemory;
    }

    public void setTransient(boolean t) {
        this._pinfo.setInMemory(t);
        this._inMemory = t;
    }

    public boolean isEventEnabled(List<String> scopeNames, BpelEvent.TYPE type) {
        Set<BpelEvent.TYPE> evtSet;
        if (scopeNames != null) {
            for (String scopeName : scopeNames) {
                Set<BpelEvent.TYPE> evtSet2 = this._events.get(scopeName);
                if (evtSet2 == null || !evtSet2.contains(type)) continue;
                return true;
            }
        }
        return (evtSet = this._events.get(null)) != null && evtSet.contains(type);
    }

    private void initEventList() {
        TProcessEvents processEvents = this._pinfo.getProcessEvents();
        if (processEvents == null) {
            HashSet<BpelEvent.TYPE> all = new HashSet<BpelEvent.TYPE>();
            for (BpelEvent.TYPE t : BpelEvent.TYPE.values()) {
                if (t.equals((Object)BpelEvent.TYPE.scopeHandling)) continue;
                all.add(t);
            }
            this._events.put(null, all);
            return;
        }
        if (processEvents.getGenerate() != null && processEvents.getGenerate().equals(TProcessEvents.Generate.ALL)) {
            HashSet<BpelEvent.TYPE> all = new HashSet<BpelEvent.TYPE>();
            for (BpelEvent.TYPE t : BpelEvent.TYPE.values()) {
                all.add(t);
            }
            this._events.put(null, all);
            return;
        }
        if (processEvents.getEnableEventList() != null) {
            List enabled = processEvents.getEnableEventList();
            HashSet<BpelEvent.TYPE> evtSet = new HashSet<BpelEvent.TYPE>();
            for (String enEvt : enabled) {
                evtSet.add(BpelEvent.TYPE.valueOf((String)enEvt));
            }
            this._events.put(null, evtSet);
        }
        if (processEvents.getScopeEventsList() != null) {
            for (TScopeEvents tScopeEvents : processEvents.getScopeEventsList()) {
                HashSet<BpelEvent.TYPE> evtSet = new HashSet<BpelEvent.TYPE>();
                for (String enEvt : tScopeEvents.getEnableEventList()) {
                    evtSet.add(BpelEvent.TYPE.valueOf((String)enEvt));
                }
                this._events.put(tScopeEvents.getName(), evtSet);
            }
        }
    }

    private String getRelativePath(File base, File path) throws IOException {
        String basePath = base.getCanonicalPath();
        String cbpPath = path.getCanonicalPath();
        if (!cbpPath.startsWith(basePath)) {
            throw new IOException("Invalid relative path: base=" + base + " path=" + path);
        }
        String relative = cbpPath.substring(basePath.length());
        if (relative.startsWith(File.separator)) {
            relative = relative.substring(1);
        }
        return relative;
    }

    public List<Element> getExtensionElement(QName qname) {
        try {
            return DOMUtils.findChildrenByName((Element)DOMUtils.stringToDOM((String)this._pinfo.toString()), (QName)qname);
        }
        catch (Exception e) {
            return Collections.emptyList();
        }
    }

    public Map<String, String> getEndpointProperties(EndpointReference epr) {
        Map map = this.eprContext.getConfigLookup(epr);
        QName service = (QName)map.get("service");
        String port = (String)map.get("port");
        this.propertiesWatchDog.check();
        Map prop = ((HierarchicalProperties)((PropertiesObserver)this.propertiesWatchDog.getObserver()).get()).getProperties(service, port);
        if (!map.isEmpty() && __log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder("Properties for ");
            if (service != null) {
                msg.append("service ").append(service);
            }
            if (port != null) {
                msg.append(", port ").append(port);
            }
            msg.append(": {");
            Iterator it = prop.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry e = it.next();
                msg.append(e.getKey()).append("=>").append(e.getValue());
                if (!it.hasNext()) continue;
                msg.append(", ");
            }
            msg.append("}");
            __log.debug((Object)msg);
        }
        return prop;
    }

    public boolean isCleanupCategoryEnabled(boolean instanceSucceeded, ProcessConf.CLEANUP_CATEGORY category) {
        return this.processCleanupConfImpl.isCleanupCategoryEnabled(instanceSucceeded, category);
    }

    public Set<ProcessConf.CLEANUP_CATEGORY> getCleanupCategories(boolean instanceSucceeded) {
        return this.processCleanupConfImpl.getCleanupCategories(instanceSucceeded);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertiesObserver
    extends WatchDog.DefaultObserver<HierarchicalProperties> {
        private PropertiesObserver() {
        }

        public void init() {
            try {
                this.object = new HierarchicalProperties(ProcessConfImpl.this.collectEndpointConfigFiles());
            }
            catch (IOException e) {
                throw new ContextException("Integration-Layer Properties cannot be loaded!", (Throwable)e);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class PropertiesMutable
    implements WatchDog.Mutable<Map<File, Long>> {
        private PropertiesMutable() {
        }

        public boolean exists() {
            return true;
        }

        public boolean hasChangedSince(Map<File, Long> since) {
            return !CollectionUtils.equals((Map)this.lastModified(), since);
        }

        public Map<File, Long> lastModified() {
            List files = ProcessConfImpl.this.collectEndpointConfigFiles();
            HashMap<File, Long> m = new HashMap<File, Long>(files.size() * 15 / 10);
            for (File f : files) {
                m.put(f, f.lastModified());
            }
            return m;
        }

        public String toString() {
            return "Endpoint files for " + ProcessConfImpl.this._du.toString();
        }
    }
}

