/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.sql.DataSource;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.compiler.api.CompilationException;
import org.apache.ode.bpel.dd.DeployDocument;
import org.apache.ode.bpel.dd.TDeployment;
import org.apache.ode.bpel.extension.ExtensionValidator;
import org.apache.ode.bpel.iapi.ContextException;
import org.apache.ode.bpel.iapi.EndpointReferenceContext;
import org.apache.ode.bpel.iapi.ProcessConf;
import org.apache.ode.bpel.iapi.ProcessState;
import org.apache.ode.bpel.iapi.ProcessStore;
import org.apache.ode.bpel.iapi.ProcessStoreEvent;
import org.apache.ode.bpel.iapi.ProcessStoreListener;
import org.apache.ode.il.config.OdeConfigProperties;
import org.apache.ode.store.ConfStoreConnection;
import org.apache.ode.store.ConfStoreConnectionFactory;
import org.apache.ode.store.DeploymentUnitDAO;
import org.apache.ode.store.DeploymentUnitDir;
import org.apache.ode.store.Messages;
import org.apache.ode.store.ProcessConfDAO;
import org.apache.ode.store.ProcessConfImpl;
import org.apache.ode.store.hib.DbConfStoreConnectionFactory;
import org.apache.ode.utils.DOMUtils;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.msg.MessageBundle;
import org.hsqldb.jdbc.jdbcDataSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProcessStoreImpl
implements ProcessStore {
    private static final Log __log = LogFactory.getLog(ProcessStoreImpl.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private final CopyOnWriteArrayList<ProcessStoreListener> _listeners = new CopyOnWriteArrayList();
    private Map<QName, ProcessConfImpl> _processes = new HashMap<QName, ProcessConfImpl>();
    private Map<String, DeploymentUnitDir> _deploymentUnits = new HashMap<String, DeploymentUnitDir>();
    private Map<QName, ExtensionValidator> _extensionValidators = new HashMap<QName, ExtensionValidator>();
    private final ReadWriteLock _rw = new ReentrantReadWriteLock();
    private String _guid = new GUID().toString();
    private ConfStoreConnectionFactory _cf;
    private EndpointReferenceContext eprContext;
    protected File _deployDir;
    protected File _configDir;
    private ExecutorService _executor = Executors.newSingleThreadExecutor(new SimpleThreadFactory());
    private DataSource _inMemDs;

    public ProcessStoreImpl() {
        this(null, null, "", new OdeConfigProperties(new Properties(), ""), true);
    }

    public ProcessStoreImpl(EndpointReferenceContext eprContext, DataSource ds, String persistenceType, OdeConfigProperties props, boolean createDatamodel) {
        this.eprContext = eprContext;
        if (ds != null) {
            this._cf = persistenceType.toLowerCase().indexOf("hib") != -1 ? new DbConfStoreConnectionFactory(ds, props.getProperties(), createDatamodel) : new org.apache.ode.store.jpa.DbConfStoreConnectionFactory(ds, createDatamodel);
        } else {
            DataSource hsqlds = ProcessStoreImpl.createInternalDS(this._guid);
            this._cf = "hibernate".equalsIgnoreCase(persistenceType) ? new DbConfStoreConnectionFactory(hsqlds, props.getProperties(), createDatamodel) : new org.apache.ode.store.jpa.DbConfStoreConnectionFactory(hsqlds, createDatamodel);
            this._inMemDs = hsqlds;
        }
    }

    public ProcessStoreImpl(EndpointReferenceContext eprContext, DataSource inMemDs) {
        this.eprContext = eprContext;
        DataSource hsqlds = ProcessStoreImpl.createInternalDS(new GUID().toString());
        this._cf = new org.apache.ode.store.jpa.DbConfStoreConnectionFactory(hsqlds, true);
        this._inMemDs = hsqlds;
    }

    public void shutdown() {
        if (this._inMemDs != null) {
            ProcessStoreImpl.shutdownInternalDB(this._inMemDs);
            this._inMemDs = null;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.finalize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QName> deploy(final File deploymentUnitDirectory) {
        __log.info((Object)__msgs.msgDeployStarting(deploymentUnitDirectory));
        Date deployDate = new Date();
        final DeploymentUnitDir du = new DeploymentUnitDir(deploymentUnitDirectory);
        du.setExtensionValidators(this._extensionValidators);
        try {
            du.compile();
        }
        catch (CompilationException ce) {
            String errmsg = __msgs.msgDeployFailCompileErrors(ce);
            __log.error((Object)errmsg, (Throwable)ce);
            throw new ContextException(errmsg, (Throwable)ce);
        }
        du.scan();
        DeployDocument dd = du.getDeploymentDescriptor();
        final ArrayList<ProcessConfImpl> processes = new ArrayList<ProcessConfImpl>();
        this._rw.writeLock().lock();
        long version = this.exec(new Callable<Long>(){

            @Override
            public Long call(ConfStoreConnection conn) {
                return conn.getNextVersion();
            }
        });
        try {
            if (this._deploymentUnits.containsKey(du.getName())) {
                String errmsg = __msgs.msgDeployFailDuplicateDU(du.getName());
                __log.error((Object)errmsg);
                throw new ContextException(errmsg);
            }
            du.setVersion(version);
            for (TDeployment.Process processDD : dd.getDeploy().getProcessList()) {
                QName pid = this.toPid(processDD.getName(), version);
                DeploymentUnitDir oldDU = this.findOldDU(du.getName());
                if (oldDU != null) {
                    this.setRetiredPackage(oldDU.getName(), true);
                }
                if (this._processes.containsKey(pid)) {
                    String errmsg = __msgs.msgDeployFailDuplicatePID(processDD.getName(), du.getName());
                    __log.error((Object)errmsg);
                    throw new ContextException(errmsg);
                }
                QName type = processDD.getType() != null ? processDD.getType() : processDD.getName();
                DeploymentUnitDir.CBPInfo cbpInfo = du.getCBPInfo(type);
                if (cbpInfo == null) {
                    String errmsg = __msgs.msgDeployFailedProcessNotFound(processDD.getName(), du.getName());
                    __log.error((Object)errmsg);
                    throw new ContextException(errmsg);
                }
                ProcessConfImpl pconf = new ProcessConfImpl(pid, processDD.getName(), version, du, processDD, deployDate, ProcessStoreImpl.calcInitialProperties(processDD), ProcessStoreImpl.calcInitialState(processDD), this.eprContext, this._configDir);
                processes.add(pconf);
            }
            this._deploymentUnits.put(du.getName(), du);
            for (ProcessConfImpl process : processes) {
                __log.info((Object)__msgs.msgProcessDeployed(du.getDeployDir(), process.getProcessId()));
                this._processes.put(process.getProcessId(), process);
            }
        }
        finally {
            this._rw.writeLock().unlock();
        }
        Collection<QName> deployed = this.exec(new Callable<Collection<QName>>(){

            @Override
            public Collection<QName> call(ConfStoreConnection conn) {
                DeploymentUnitDAO dudao = conn.getDeploymentUnit(du.getName());
                if (dudao != null) {
                    String errmsg = "Database out of synch for DU " + du.getName();
                    __log.warn((Object)errmsg);
                    dudao.delete();
                }
                dudao = conn.createDeploymentUnit(du.getName());
                try {
                    dudao.setDeploymentUnitDir(deploymentUnitDirectory.getCanonicalPath());
                }
                catch (IOException e1) {
                    String errmsg = "Error getting canonical path for " + du.getName() + "; deployment unit will not be available after restart!";
                    __log.error((Object)errmsg);
                }
                ArrayList<QName> deployed = new ArrayList<QName>();
                for (ProcessConfImpl pc : processes) {
                    try {
                        ProcessConfDAO newDao = dudao.createProcess(pc.getProcessId(), pc.getType(), pc.getVersion());
                        newDao.setState(pc.getState());
                        for (Map.Entry<QName, Node> prop : pc.getProcessProperties().entrySet()) {
                            newDao.setProperty(prop.getKey(), DOMUtils.domToString((Node)prop.getValue()));
                        }
                        deployed.add(pc.getProcessId());
                        conn.setVersion(pc.getVersion());
                    }
                    catch (Throwable e) {
                        String errmsg = "Error persisting deployment record for " + pc.getProcessId() + "; process will not be available after restart!";
                        __log.error((Object)errmsg, e);
                    }
                }
                return deployed;
            }
        });
        try {
            for (ProcessConfImpl process : processes) {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.DEPLOYED, process.getProcessId(), process.getDeploymentUnit().getName()));
                this.fireStateChange(process.getProcessId(), process.getState(), process.getDeploymentUnit().getName());
            }
        }
        catch (Exception e) {
            __log.warn((Object)"Deployment failed within the engine, store undeploying process.");
            this.undeploy(deploymentUnitDirectory);
            if (e instanceof ContextException) {
                throw (ContextException)e;
            }
            throw new ContextException("Deployment failed within the engine.", (Throwable)e);
        }
        return deployed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<QName> undeploy(final File dir) {
        DeploymentUnitDir du;
        try {
            this.exec(new Callable<Collection<QName>>(){

                @Override
                public Collection<QName> call(ConfStoreConnection conn) {
                    DeploymentUnitDAO dudao = conn.getDeploymentUnit(dir.getName());
                    if (dudao != null) {
                        dudao.delete();
                    }
                    return null;
                }
            });
        }
        catch (Exception ex) {
            __log.error((Object)("Error synchronizing with data store; " + dir.getName() + " may be reappear after restart!"));
        }
        List<QName> undeployed = Collections.emptyList();
        this._rw.writeLock().lock();
        try {
            du = this._deploymentUnits.remove(dir.getName());
            if (du != null) {
                undeployed = this.toPids(du.getProcessNames(), du.getVersion());
                this._processes.keySet().removeAll(undeployed);
            }
        }
        finally {
            this._rw.writeLock().unlock();
        }
        for (QName pn : undeployed) {
            this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.UNDEPLOYED, pn, du.getName()));
            __log.info((Object)__msgs.msgProcessUndeployed(pn));
        }
        return undeployed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getPackages() {
        this._rw.readLock().lock();
        try {
            ArrayList<String> arrayList = new ArrayList<String>(this._deploymentUnits.keySet());
            return arrayList;
        }
        finally {
            this._rw.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QName> listProcesses(String packageName) {
        this._rw.readLock().lock();
        try {
            DeploymentUnitDir du = this._deploymentUnits.get(packageName);
            if (du == null) {
                List<QName> list = null;
                return list;
            }
            List<QName> list = this.toPids(du.getProcessNames(), du.getVersion());
            return list;
        }
        finally {
            this._rw.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setState(final QName pid, final ProcessState state) {
        ProcessConfImpl pconf;
        __log.debug((Object)("Changing process state for " + pid + " to " + state));
        this._rw.readLock().lock();
        try {
            pconf = this._processes.get(pid);
            if (pconf == null) {
                String msg = __msgs.msgProcessNotFound(pid);
                __log.info((Object)msg);
                throw new ContextException(msg);
            }
        }
        finally {
            this._rw.readLock().unlock();
        }
        final DeploymentUnitDir dudir = pconf.getDeploymentUnit();
        ProcessState old = this.exec(new Callable<ProcessState>(){

            @Override
            public ProcessState call(ConfStoreConnection conn) {
                DeploymentUnitDAO dudao = conn.getDeploymentUnit(dudir.getName());
                if (dudao == null) {
                    String errmsg = __msgs.msgProcessNotFound(pid);
                    __log.error((Object)errmsg);
                    throw new ContextException(errmsg);
                }
                ProcessConfDAO dao = dudao.getProcess(pid);
                if (dao == null) {
                    String errmsg = __msgs.msgProcessNotFound(pid);
                    __log.error((Object)errmsg);
                    throw new ContextException(errmsg);
                }
                ProcessState old = dao.getState();
                dao.setState(state);
                pconf.setState(state);
                return old;
            }
        });
        pconf.setState(state);
        if (old != null && old != state) {
            this.fireStateChange(pid, state, pconf.getDeploymentUnit().getName());
        }
    }

    public void setRetiredPackage(String packageName, boolean retired) {
        DeploymentUnitDir duDir = this._deploymentUnits.get(packageName);
        if (duDir == null) {
            throw new ContextException("Could not find package " + packageName);
        }
        for (QName processName : duDir.getProcessNames()) {
            this.setState(this.toPid(processName, duDir.getVersion()), retired ? ProcessState.RETIRED : ProcessState.ACTIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessConf getProcessConfiguration(QName processId) {
        this._rw.readLock().lock();
        try {
            ProcessConf processConf = this._processes.get(processId);
            return processConf;
        }
        finally {
            this._rw.readLock().unlock();
        }
    }

    public void setProperty(QName pid, QName propName, Node value) {
        this.setProperty(pid, propName, DOMUtils.domToStringLevel2((Node)value));
    }

    public void setProperty(final QName pid, final QName propName, final String value) {
        ProcessConfImpl pconf;
        if (__log.isDebugEnabled()) {
            __log.debug((Object)("Setting property " + propName + " on process " + pid));
        }
        if ((pconf = this._processes.get(pid)) == null) {
            String msg = __msgs.msgProcessNotFound(pid);
            __log.info((Object)msg);
            throw new ContextException(msg);
        }
        final DeploymentUnitDir dudir = pconf.getDeploymentUnit();
        this.exec(new Callable<Object>(){

            @Override
            public Object call(ConfStoreConnection conn) {
                DeploymentUnitDAO dudao = conn.getDeploymentUnit(dudir.getName());
                if (dudao == null) {
                    return null;
                }
                ProcessConfDAO proc = dudao.getProcess(pid);
                if (proc == null) {
                    return null;
                }
                proc.setProperty(propName, value);
                return null;
            }
        });
        this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.PROPERTY_CHANGED, pid, dudir.getName()));
    }

    public void loadAll() {
        final ArrayList loaded = new ArrayList();
        this.exec(new Callable<Object>(){

            @Override
            public Object call(ConfStoreConnection conn) {
                Collection<DeploymentUnitDAO> dus = conn.getDeploymentUnits();
                for (DeploymentUnitDAO du : dus) {
                    try {
                        loaded.addAll(ProcessStoreImpl.this.load(du));
                    }
                    catch (Exception ex) {
                        __log.error((Object)("Error loading DU from store: " + du.getName()), (Throwable)ex);
                    }
                }
                return null;
            }
        });
        for (ProcessConfImpl p : loaded) {
            try {
                this.fireStateChange(p.getProcessId(), p.getState(), p.getDeploymentUnit().getName());
            }
            catch (Exception except) {
                __log.error((Object)("Error while activating process: pid=" + p.getProcessId() + " package=" + p.getDeploymentUnit().getName()), (Throwable)except);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<QName> getProcesses() {
        this._rw.readLock().lock();
        try {
            ArrayList<QName> arrayList = new ArrayList<QName>(this._processes.keySet());
            return arrayList;
        }
        finally {
            this._rw.readLock().unlock();
        }
    }

    public long getCurrentVersion() {
        long version = this.exec(new Callable<Long>(){

            @Override
            public Long call(ConfStoreConnection conn) {
                return conn.getNextVersion();
            }
        });
        return version;
    }

    protected void fireEvent(ProcessStoreEvent pse) {
        __log.debug((Object)("firing event: " + pse));
        for (ProcessStoreListener psl : this._listeners) {
            psl.onProcessStoreEvent(pse);
        }
    }

    private void fireStateChange(QName processId, ProcessState state, String duname) {
        switch (state) {
            case ACTIVE: {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.ACTIVATED, processId, duname));
                break;
            }
            case DISABLED: {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.DISABLED, processId, duname));
                break;
            }
            case RETIRED: {
                this.fireEvent(new ProcessStoreEvent(ProcessStoreEvent.Type.RETIRED, processId, duname));
            }
        }
    }

    public void registerListener(ProcessStoreListener psl) {
        __log.debug((Object)("Registering listener " + psl));
        this._listeners.add(psl);
    }

    public void unregisterListener(ProcessStoreListener psl) {
        __log.debug((Object)("Unregistering listener " + psl));
        this._listeners.remove(psl);
    }

    synchronized <T> T exec(Callable<T> callable) {
        Future<T> future = this._executor.submit(callable);
        try {
            return future.get();
        }
        catch (Exception e) {
            throw new ContextException("DbError", (Throwable)e);
        }
    }

    private ConfStoreConnection getConnection() {
        return this._cf.getConnection();
    }

    public static Map<QName, Node> calcInitialProperties(TDeployment.Process dd) {
        HashMap<QName, Node> ret = new HashMap<QName, Node>();
        if (dd.getPropertyList().size() > 0) {
            for (TDeployment.Process.Property property : dd.getPropertyList()) {
                Element elmtContent = DOMUtils.getElementContent((Node)property.getDomNode());
                if (elmtContent != null) {
                    Document doc = DOMUtils.newDocument();
                    doc.appendChild(doc.importNode(elmtContent, true));
                    ret.put(property.getName(), doc.getDocumentElement());
                    continue;
                }
                ret.put(property.getName(), property.getDomNode().getFirstChild());
            }
        }
        return ret;
    }

    private static ProcessState calcInitialState(TDeployment.Process dd) {
        ProcessState state = ProcessState.ACTIVE;
        if (dd.isSetActive() && !dd.getActive()) {
            state = ProcessState.DISABLED;
        }
        if (dd.isSetRetired() && dd.getRetired()) {
            state = ProcessState.RETIRED;
        }
        return state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ProcessConfImpl> load(DeploymentUnitDAO dudao) {
        __log.debug((Object)("Loading deployment unit record from db: " + dudao.getName()));
        File dudir = this.findDeployDir(dudao);
        if (dudir == null || !dudir.exists()) {
            throw new ContextException("Deployed directory " + (dudir == null ? "(unknown)" : dudir) + " no longer there!");
        }
        DeploymentUnitDir dud = new DeploymentUnitDir(dudir);
        dud.scan();
        ArrayList<ProcessConfImpl> loaded = new ArrayList<ProcessConfImpl>();
        this._rw.writeLock().lock();
        try {
            this._deploymentUnits.put(dud.getName(), dud);
            long version = 0L;
            for (ProcessConfDAO processConfDAO : dudao.getProcesses()) {
                TDeployment.Process pinfo = dud.getProcessDeployInfo(processConfDAO.getType());
                if (pinfo == null) {
                    __log.warn((Object)("Cannot load " + processConfDAO.getPID() + "; cannot find descriptor."));
                    continue;
                }
                Map<QName, Node> props = ProcessStoreImpl.calcInitialProperties(pinfo);
                ProcessConfImpl pconf = new ProcessConfImpl(processConfDAO.getPID(), processConfDAO.getType(), processConfDAO.getVersion(), dud, pinfo, dudao.getDeployDate(), props, processConfDAO.getState(), this.eprContext, this._configDir);
                version = processConfDAO.getVersion();
                this._processes.put(pconf.getProcessId(), pconf);
                loaded.add(pconf);
            }
            dud.setVersion(version);
        }
        finally {
            this._rw.writeLock().unlock();
        }
        return loaded;
    }

    protected File findDeployDir(DeploymentUnitDAO dudao) {
        File f = new File(dudao.getDeploymentUnitDir());
        if (f.exists()) {
            return f;
        }
        f = new File(this._deployDir, dudao.getName());
        if (f.exists()) {
            return f;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean load(final String duName) {
        this._rw.writeLock().lock();
        try {
            if (this._deploymentUnits.containsKey(duName)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this._rw.writeLock().unlock();
        }
        try {
            return this.exec(new Callable<Boolean>(){

                @Override
                public Boolean call(ConfStoreConnection conn) {
                    DeploymentUnitDAO dudao = conn.getDeploymentUnit(duName);
                    if (dudao == null) {
                        return false;
                    }
                    ProcessStoreImpl.this.load(dudao);
                    return true;
                }
            });
        }
        catch (Exception ex) {
            __log.error((Object)("Error loading deployment unit: " + duName));
            return false;
        }
    }

    public void setDeployDir(File depDir) {
        if (depDir != null && !depDir.isDirectory()) {
            throw new IllegalArgumentException("Deploy directory is not a directory or does not exist:  " + depDir);
        }
        this._deployDir = depDir;
    }

    public File getDeployDir() {
        return this._deployDir;
    }

    public File getConfigDir() {
        return this._configDir;
    }

    public void setConfigDir(File configDir) {
        if (configDir != null && !configDir.isDirectory()) {
            throw new IllegalArgumentException("Config directory is not a directory or does not exist: " + configDir);
        }
        this._configDir = configDir;
    }

    public static DataSource createInternalDS(String guid) {
        jdbcDataSource hsqlds = new jdbcDataSource();
        hsqlds.setDatabase("jdbc:hsqldb:mem:" + guid);
        hsqlds.setUser("sa");
        hsqlds.setPassword("");
        return hsqlds;
    }

    public static void shutdownInternalDB(DataSource ds) {
        try {
            ds.getConnection().createStatement().execute("SHUTDOWN;");
        }
        catch (SQLException e) {
            __log.error((Object)"Error shutting down.", (Throwable)e);
        }
    }

    private List<QName> toPids(Collection<QName> processTypes, long version) {
        ArrayList<QName> result = new ArrayList<QName>();
        for (QName pqName : processTypes) {
            result.add(this.toPid(pqName, version));
        }
        return result;
    }

    private QName toPid(QName processType, long version) {
        return new QName(processType.getNamespaceURI(), processType.getLocalPart() + "-" + version);
    }

    private DeploymentUnitDir findOldDU(String newName) {
        DeploymentUnitDir old = null;
        int dashIdx = newName.lastIndexOf("-");
        if (dashIdx > 0 && dashIdx + 1 < newName.length()) {
            String radical = newName.substring(0, dashIdx);
            int newVersion = -1;
            try {
                newVersion = Integer.parseInt(newName.substring(newName.lastIndexOf("-") + 1));
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            while (old == null && newVersion >= 0) {
                old = this._deploymentUnits.get(radical + "-" + newVersion--);
            }
        }
        return old;
    }

    public void setExtensionValidators(Map<QName, ExtensionValidator> extensionValidators) {
        this._extensionValidators = extensionValidators;
    }

    private class SimpleThreadFactory
    implements ThreadFactory {
        int threadNumber = 0;

        private SimpleThreadFactory() {
        }

        public Thread newThread(Runnable r) {
            ++this.threadNumber;
            Thread t = new Thread(r, "ProcessStoreImpl-" + this.threadNumber);
            t.setDaemon(true);
            return t;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    abstract class Callable<V>
    implements java.util.concurrent.Callable<V> {
        Callable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V call() {
            boolean success = false;
            ConfStoreConnection conn = ProcessStoreImpl.this.getConnection();
            try {
                conn.begin();
                V r = this.call(conn);
                conn.commit();
                success = true;
                V v = r;
                return v;
            }
            finally {
                if (!success) {
                    try {
                        conn.rollback();
                    }
                    catch (Exception ex) {
                        __log.error((Object)"DbError", (Throwable)ex);
                    }
                }
                try {
                    conn.close();
                }
                catch (Exception ex) {
                    __log.error((Object)"DbError", (Throwable)ex);
                }
            }
        }

        abstract V call(ConfStoreConnection var1);
    }
}

