/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store.hib;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.store.ConfStoreConnection;
import org.apache.ode.store.DeploymentUnitDAO;
import org.apache.ode.store.ProcessConfDAO;
import org.apache.ode.store.hib.DeploymentUnitDaoImpl;
import org.apache.ode.store.hib.ProcessConfDaoImpl;
import org.apache.ode.store.hib.VersionTrackerDAOImpl;
import org.hibernate.Criteria;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfStoreConnectionHib
implements ConfStoreConnection {
    private static final Log __log = LogFactory.getLog(ConfStoreConnectionHib.class);
    private Session _session;
    private Transaction _tx;
    static final ThreadLocal<Session> _current = new ThreadLocal();

    public ConfStoreConnectionHib(Session session) {
        this._session = session;
        _current.set(session);
    }

    public ProcessConfDAO getProcess(QName pid) {
        try {
            return (ProcessConfDaoImpl)this._session.get(ProcessConfDaoImpl.class, (Serializable)((Object)pid.toString()));
        }
        catch (HibernateException e) {
            __log.error((Object)"DbError", (Throwable)e);
            throw e;
        }
    }

    @Override
    public DeploymentUnitDAO createDeploymentUnit(String name) {
        DeploymentUnitDaoImpl du = new DeploymentUnitDaoImpl();
        du.setName(name);
        du.setDeployDate(new Date());
        this._session.save((Object)du);
        return du;
    }

    @Override
    public DeploymentUnitDAO getDeploymentUnit(String name) {
        try {
            DeploymentUnitDaoImpl du = (DeploymentUnitDaoImpl)this._session.get(DeploymentUnitDaoImpl.class, (Serializable)((Object)name));
            return du;
        }
        catch (HibernateException e) {
            __log.error((Object)"DbError", (Throwable)e);
            throw e;
        }
    }

    @Override
    public long getNextVersion() {
        VersionTrackerDAOImpl vt = (VersionTrackerDAOImpl)this._session.createQuery("from VersionTrackerDAOImpl v ").uniqueResult();
        if (vt == null) {
            return 1L;
        }
        return vt.getVersion() + 1L;
    }

    @Override
    public void setVersion(long version) {
        VersionTrackerDAOImpl vt = (VersionTrackerDAOImpl)this._session.createQuery("from VersionTrackerDAOImpl v ").uniqueResult();
        if (vt == null) {
            vt = new VersionTrackerDAOImpl();
            vt.setId(1);
        }
        vt.setVersion(version);
        this._session.save((Object)vt);
    }

    @Override
    public Collection<DeploymentUnitDAO> getDeploymentUnits() {
        Criteria c = this._session.createCriteria(DeploymentUnitDaoImpl.class);
        return c.list();
    }

    @Override
    public void close() {
        this._session.close();
    }

    @Override
    public void begin() {
        this._tx = this._session.beginTransaction();
    }

    @Override
    public void commit() {
        this._tx.commit();
    }

    @Override
    public void rollback() {
        this._tx.rollback();
    }
}

