/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store.hib;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.bpel.iapi.BpelEngineException;
import org.apache.ode.store.ConfStoreConnectionFactory;
import org.apache.ode.store.Messages;
import org.apache.ode.store.hib.ConfStoreConnectionHib;
import org.apache.ode.store.hib.DeploymentUnitDaoImpl;
import org.apache.ode.store.hib.ProcessConfDaoImpl;
import org.apache.ode.store.hib.VersionTrackerDAOImpl;
import org.apache.ode.utils.GUID;
import org.apache.ode.utils.msg.MessageBundle;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;
import org.hibernate.connection.ConnectionProvider;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.DialectFactory;

public class DbConfStoreConnectionFactory
implements ConfStoreConnectionFactory {
    private static final Log __log = LogFactory.getLog(DbConfStoreConnectionFactory.class);
    private static final Messages __msgs = (Messages)MessageBundle.getMessages(Messages.class);
    private static final String DEFAULT_HIBERNATE_DIALECT = "org.hibernate.dialect.DerbyDialect";
    private static final HashMap<String, DialectFactory.VersionInsensitiveMapper> HIBERNATE_DIALECTS = new HashMap();
    private static final String _guid = new GUID().toString();
    private static final Map<String, DataSource> _dataSources = new ConcurrentHashMap<String, DataSource>();
    private final DataSource _ds;
    final SessionFactory _sessionFactory;

    public DbConfStoreConnectionFactory(DataSource ds, Properties initialProps, boolean createDatamodel) {
        this._ds = ds;
        Properties properties = new Properties();
        for (Object prop : initialProps.keySet()) {
            properties.put(prop, initialProps.get(prop));
        }
        __log.debug((Object)("using data source: " + ds));
        _dataSources.put(_guid, ds);
        properties.put("guid", _guid);
        properties.put("hibernate.connection.provider_class", DataSourceConnectionProvider.class.getName());
        if (properties.get("hibernate.dialect") == null) {
            try {
                properties.put("hibernate.dialect", this.guessDialect(this._ds));
            }
            catch (Exception ex) {
                String errmsg = __msgs.msgOdeInitHibernateDialectDetectFailed();
                __log.error((Object)errmsg, (Throwable)ex);
                throw new BpelEngineException(errmsg, (Throwable)ex);
            }
        }
        if (createDatamodel) {
            properties.put("hibernate.hbm2ddl.auto", "create-drop");
        }
        this._sessionFactory = DbConfStoreConnectionFactory.getDefaultConfiguration().setProperties(properties).buildSessionFactory();
    }

    public ConfStoreConnectionHib getConnection() {
        return new ConfStoreConnectionHib((Session)this._sessionFactory.openSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String guessDialect(DataSource dataSource) throws Exception {
        String dialect = null;
        Connection conn = dataSource.getConnection();
        try {
            DatabaseMetaData metaData = conn.getMetaData();
            if (metaData != null) {
                String dbProductName = metaData.getDatabaseProductName();
                int dbMajorVer = metaData.getDatabaseMajorVersion();
                __log.info((Object)("Using database " + dbProductName + " major version " + dbMajorVer));
                DialectFactory.DatabaseDialectMapper mapper = (DialectFactory.DatabaseDialectMapper)HIBERNATE_DIALECTS.get(dbProductName);
                if (mapper != null) {
                    dialect = mapper.getDialectClass(dbMajorVer);
                } else {
                    Dialect hbDialect = DialectFactory.determineDialect((String)dbProductName, (int)dbMajorVer);
                    if (hbDialect != null) {
                        dialect = hbDialect.getClass().getName();
                    }
                }
            }
        }
        finally {
            conn.close();
        }
        if (dialect == null) {
            __log.info((Object)"Cannot determine hibernate dialect for this database: using the default one.");
            dialect = DEFAULT_HIBERNATE_DIALECT;
        }
        return dialect;
    }

    static Configuration getDefaultConfiguration() throws MappingException {
        return new Configuration().addClass(ProcessConfDaoImpl.class).addClass(DeploymentUnitDaoImpl.class).addClass(VersionTrackerDAOImpl.class);
    }

    static {
        HIBERNATE_DIALECTS.put("Apache Derby", new DialectFactory.VersionInsensitiveMapper(DEFAULT_HIBERNATE_DIALECT));
    }

    public static class DataSourceConnectionProvider
    implements ConnectionProvider {
        private String _guid;

        public void configure(Properties props) throws HibernateException {
            this._guid = props.getProperty("guid");
        }

        public Connection getConnection() throws SQLException {
            return ((DataSource)_dataSources.get(this._guid)).getConnection();
        }

        public void closeConnection(Connection arg0) throws SQLException {
            arg0.close();
        }

        public void close() throws HibernateException {
        }

        public boolean supportsAggressiveRelease() {
            return true;
        }
    }
}

