/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store.jpa;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import org.apache.ode.store.ConfStoreConnection;
import org.apache.ode.store.DeploymentUnitDAO;
import org.apache.ode.store.jpa.DeploymentUnitDaoImpl;
import org.apache.ode.store.jpa.VersionTrackerDAOImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfStoreConnectionJpa
implements ConfStoreConnection {
    private EntityManager _em;
    static final ThreadLocal<EntityManager> _current = new ThreadLocal();

    public ConfStoreConnectionJpa(EntityManager em) {
        this._em = em;
        _current.set(em);
    }

    @Override
    public void begin() {
        this._em.getTransaction().begin();
    }

    @Override
    public void close() {
    }

    @Override
    public void commit() {
        this._em.getTransaction().commit();
    }

    @Override
    public DeploymentUnitDAO createDeploymentUnit(String name) {
        DeploymentUnitDaoImpl du = new DeploymentUnitDaoImpl();
        du.setName(name);
        du.setDeployDate(new Date());
        this._em.persist((Object)du);
        return du;
    }

    @Override
    public DeploymentUnitDAO getDeploymentUnit(String name) {
        return (DeploymentUnitDAO)this._em.find(DeploymentUnitDaoImpl.class, (Object)name);
    }

    @Override
    public Collection<DeploymentUnitDAO> getDeploymentUnits() {
        return this._em.createQuery("SELECT du from DeploymentUnitDaoImpl du").getResultList();
    }

    @Override
    public void rollback() {
        this._em.getTransaction().rollback();
    }

    @Override
    public long getNextVersion() {
        List res = this._em.createQuery("select v from VersionTrackerDAOImpl v").getResultList();
        if (res.size() == 0) {
            return 1L;
        }
        VersionTrackerDAOImpl vt = (VersionTrackerDAOImpl)res.get(0);
        return vt.getVersion() + 1L;
    }

    @Override
    public void setVersion(long version) {
        List res = this._em.createQuery("select v from VersionTrackerDAOImpl v").getResultList();
        VersionTrackerDAOImpl vt = res.size() == 0 ? new VersionTrackerDAOImpl() : (VersionTrackerDAOImpl)res.get(0);
        vt.setVersion(version);
        this._em.persist((Object)vt);
    }
}

