/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.store.jpa;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ode.store.ConfStoreConnection;
import org.apache.ode.store.ConfStoreConnectionFactory;
import org.apache.ode.store.jpa.ConfStoreConnectionJpa;
import org.apache.ode.utils.DbIsolation;

public class DbConfStoreConnectionFactory
implements ConfStoreConnectionFactory {
    private static Log log = LogFactory.getLog(DbConfStoreConnectionFactory.class);
    private DataSource _ds;
    private EntityManagerFactory _emf;

    public DbConfStoreConnectionFactory(DataSource ds, boolean createDatamodel) {
        this._ds = ds;
        HashMap<String, Object> propMap = new HashMap<String, Object>();
        propMap.put("javax.persistence.nonJtaDataSource", ds);
        propMap.put("openjpa.Log", "log4j");
        if (this.determineDatabaseDictionary() != null) {
            propMap.put("openjpa.jdbc.DBDictionary", this.determineDatabaseDictionary());
        }
        if (createDatamodel) {
            propMap.put("openjpa.jdbc.SynchronizeMappings", "buildSchema(ForeignKeys=false)");
        }
        this._emf = Persistence.createEntityManagerFactory((String)"ode-store", propMap);
    }

    public ConfStoreConnection getConnection() {
        return new ConfStoreConnectionJpa(this._emf.createEntityManager());
    }

    private Connection getDBConnection() throws SQLException {
        Connection c = this._ds.getConnection();
        DbIsolation.setIsolationLevel((Connection)c);
        return c;
    }

    private void close(Connection con) {
        if (con != null) {
            try {
                con.close();
            }
            catch (Exception e) {
                log.warn((Object)"Exception while closing connection", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String determineDatabaseDictionary() {
        String dbDictionary = null;
        Connection con = null;
        try {
            con = this.getDBConnection();
            DatabaseMetaData metaData = con.getMetaData();
            if (metaData != null) {
                String dbProductName = metaData.getDatabaseProductName().toLowerCase();
                int dbMajorVer = metaData.getDatabaseMajorVersion();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Using database " + dbProductName + " major version " + dbMajorVer));
                }
                if (dbProductName.indexOf("db2") >= 0) {
                    dbDictionary = "db2";
                } else if (dbProductName.indexOf("oracle") >= 0) {
                    dbDictionary = "oracle";
                } else if (dbProductName.indexOf("derby") >= 0) {
                    dbDictionary = "derby";
                } else if (dbProductName.indexOf("hsql") >= 0) {
                    dbDictionary = "hsql(SimulateLocking=true)";
                } else if (dbProductName.indexOf("microsoft sql") >= 0) {
                    dbDictionary = "sqlserver";
                } else if (dbProductName.indexOf("mysql") >= 0) {
                    dbDictionary = "mysql";
                } else if (dbProductName.indexOf("sybase") >= 0) {
                    dbDictionary = "sybase";
                } else if (dbProductName.indexOf("h2") >= 0) {
                    dbDictionary = "h2";
                }
            }
        }
        catch (SQLException e) {
            log.warn((Object)"Unable to determine database dialect", (Throwable)e);
        }
        finally {
            this.close(con);
        }
        if (log.isDebugEnabled()) {
            log.info((Object)("Using database dialect: " + dbDictionary));
        }
        return dbDictionary;
    }
}

