/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ode.jacob.ap;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.InterfaceDeclaration;
import com.sun.mirror.type.InterfaceType;
import com.sun.mirror.util.DeclarationFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.Date;

class ChannelTypeAnnotationProcessor
implements AnnotationProcessor {
    AnnotationProcessorEnvironment _env;
    AnnotationTypeDeclaration _atd;

    ChannelTypeAnnotationProcessor(AnnotationTypeDeclaration atd, AnnotationProcessorEnvironment env) {
        this._atd = atd;
        this._env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        Collection channels = DeclarationFilter.getFilter(InterfaceDeclaration.class).filter(this._env.getDeclarationsAnnotatedWith(this._atd), InterfaceDeclaration.class);
        for (InterfaceDeclaration c : channels) {
            PrintWriter pw = null;
            try {
                pw = this._env.getFiler().createSourceFile(c.getQualifiedName() + "Channel");
                this.writeChannelClass(pw, c);
            }
            catch (IOException e) {
                this._env.getMessager().printError(c.getPosition(), "IO Error: " + e.getMessage());
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                pw = null;
            }
            try {
                pw = this._env.getFiler().createSourceFile(c.getQualifiedName() + "ChannelListener");
                this.writeChannelListenerClass(pw, c);
            }
            catch (IOException e) {
                this._env.getMessager().printError(c.getPosition(), "IO Error: " + e.getMessage());
            }
            finally {
                if (pw != null) {
                    pw.close();
                }
                pw = null;
            }
        }
    }

    private void writeChannelClass(PrintWriter pw, InterfaceDeclaration c) {
        pw.println("/*");
        pw.println(" * SOURCE FILE GENERATATED BY JACOB CHANNEL CLASS GENERATOR");
        pw.println(" * ");
        pw.println(" *               !!! DO NOT EDIT !!!! ");
        pw.println(" * ");
        pw.println(" * Generated On  : " + new Date());
        pw.println(" * For Interface : " + c.getQualifiedName());
        pw.println(" */");
        pw.println();
        pw.println("package " + c.getPackage().getQualifiedName() + ";");
        pw.println();
        pw.println("/**");
        pw.println(" * An auto-generated channel interface for the channel type");
        pw.println(" * {@link " + c.getQualifiedName() + "}.");
        pw.println(" * @see " + c.getQualifiedName());
        pw.println(" * @see " + c.getQualifiedName() + "ChannelListener");
        pw.println(" */");
        pw.println("public interface " + c.getSimpleName() + "Channel");
        Collection supers = c.getSuperinterfaces();
        if (supers.isEmpty()) {
            pw.println("    extends org.apache.ode.jacob.Channel, ");
        } else {
            pw.print("    extends ");
            for (InterfaceType s : supers) {
                pw.println("            " + s.getDeclaration().getQualifiedName() + "Channel, ");
            }
            pw.println("            org.apache.ode.jacob.Channel, ");
        }
        pw.println("            " + c.getQualifiedName());
        pw.println("{}");
        pw.flush();
    }

    private void writeChannelListenerClass(PrintWriter pw, InterfaceDeclaration c) {
        pw.println("/*");
        pw.println(" * SOURCE FILE GENERATATED BY JACOB CHANNEL CLASS GENERATOR");
        pw.println(" * ");
        pw.println(" *               !!! DO NOT EDIT !!!! ");
        pw.println(" * ");
        pw.println(" * Generated On  : " + new Date());
        pw.println(" * For Interface : " + c.getQualifiedName());
        pw.println(" */");
        pw.println();
        pw.println("package " + c.getPackage().getQualifiedName() + ";");
        pw.println();
        pw.println("import org.apache.commons.logging.LogFactory;");
        pw.println("import org.apache.commons.logging.Log;");
        pw.println();
        pw.println("/**");
        pw.println(" * An auto-generated channel listener abstract class for the ");
        pw.println(" * {@link " + c.getQualifiedName() + "} channel type. ");
        pw.println(" * @see " + c.getQualifiedName());
        pw.println(" * @see " + c.getQualifiedName() + "Channel");
        pw.println(" */");
        pw.println("public abstract class " + c.getSimpleName() + "ChannelListener");
        pw.println("    extends org.apache.ode.jacob.ChannelListener<" + c.getQualifiedName() + "Channel>");
        pw.println("    implements " + c.getQualifiedName());
        pw.println("{");
        pw.println();
        pw.println("    private static final Log __log = LogFactory.getLog(" + c.getQualifiedName() + ".class);");
        pw.println();
        pw.println("    protected Log log() { return __log; } ");
        pw.println();
        pw.println("    protected " + c.getSimpleName() + "ChannelListener(" + c.getQualifiedName() + "Channel channel) {");
        pw.println("       super(channel);");
        pw.println("    }");
        pw.println("}");
        pw.flush();
    }
}

