/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.ejb.EJBException;
import org.apache.cxf.jaxrs.JAXRSInvoker;
import org.apache.cxf.message.Exchange;
import org.apache.openejb.ApplicationException;
import org.apache.openejb.BeanContext;
import org.apache.openejb.InvalidateReferenceException;
import org.apache.openejb.core.interceptor.InterceptorData;
import org.apache.openejb.monitoring.StatsInterceptor;
import org.apache.openejb.server.cxf.rs.Contexts;
import org.apache.openejb.util.proxy.BeanContextInvocationHandler;
import org.apache.openejb.util.proxy.LocalBeanProxyFactory;
import org.apache.openejb.util.proxy.ProxyManager;

public class OpenEJBEJBInvoker
extends JAXRSInvoker {
    private final Map<Class<?>, Collection<Class<?>>> contextTypes = new HashMap();

    public OpenEJBEJBInvoker(Collection<BeanContext> restEjbs) {
        for (BeanContext context : restEjbs) {
            HashSet classes = new HashSet();
            Contexts.findContextFields(context.getBeanClass(), classes);
            for (Collection list : Arrays.asList(context.getInterceptorData(), context.getInstanceScopedInterceptors(), context.getCallbackInterceptors())) {
                for (InterceptorData id : list) {
                    Class interceptorClass = id.getInterceptorClass();
                    if (StatsInterceptor.class.equals((Object)interceptorClass)) continue;
                    Contexts.findContextFields(interceptorClass, classes);
                }
            }
            this.contextTypes.put(context.getBeanClass(), classes);
        }
    }

    public Object invoke(Exchange exchange, Object request, Object resourceObject) {
        Contexts.bind(exchange, this.getContextTypes(resourceObject));
        return super.invoke(exchange, request, resourceObject);
    }

    private Collection<Class<?>> getContextTypes(Object resourceObject) {
        if (!ProxyManager.isProxyClass(resourceObject.getClass()) && !LocalBeanProxyFactory.isProxy(resourceObject.getClass())) {
            return Collections.emptySet();
        }
        InvocationHandler handler = ProxyManager.getInvocationHandler((Object)resourceObject);
        if (!(handler instanceof BeanContextInvocationHandler)) {
            return Collections.emptySet();
        }
        BeanContext beanContext = ((BeanContextInvocationHandler)handler).getBeanContext();
        if (beanContext == null) {
            return Collections.emptySet();
        }
        return this.contextTypes.get(beanContext.getBeanClass());
    }

    protected Object performInvocation(Exchange exchange, Object serviceObject, Method m, Object[] paramArray) throws Exception {
        try {
            Object[] args = super.insertExchange(m, paramArray, exchange);
            return m.invoke(serviceObject, args);
        }
        catch (InvocationTargetException ite) {
            Throwable cause = ite.getTargetException();
            if (cause instanceof InvalidateReferenceException && (cause = cause.getCause()) instanceof RemoteException) {
                cause = cause.getCause();
            }
            if (EJBException.class.isInstance(cause)) {
                cause = ((EJBException)EJBException.class.cast(cause)).getCause();
            }
            if (ApplicationException.class.isInstance(cause) && Exception.class.isInstance(cause.getCause())) {
                throw (Exception)Exception.class.cast(((ApplicationException)ApplicationException.class.cast(cause)).getCause());
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw ite;
        }
    }
}

