/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.webservices;

import java.util.List;
import org.apache.openejb.server.httpd.BasicAuthHttpListenerWrapper;
import org.apache.openejb.server.httpd.HttpListener;
import org.apache.openejb.server.httpd.OpenEJBHttpRegistry;
import org.apache.openejb.server.webservices.WsRegistry;

public class OpenEJBHttpWsRegistry
extends OpenEJBHttpRegistry
implements WsRegistry {
    @Override
    public List<String> setWsContainer(String virtualHost, String contextRoot, String servletName, HttpListener wsContainer) throws Exception {
        throw new UnsupportedOperationException("OpenEJB http server does not support POJO webservices");
    }

    @Override
    public void clearWsContainer(String virtualHost, String contextRoot, String servletName) {
    }

    @Override
    public List<String> addWsContainer(String context, String path, HttpListener httpListener, String virtualHost, String realmName, String transportGuarantee, String authMethod, ClassLoader classLoader) throws Exception {
        if (path == null) {
            throw new NullPointerException("contextRoot is null");
        }
        if (httpListener == null) {
            throw new NullPointerException("httpListener is null");
        }
        if ("BASIC".equals(authMethod)) {
            httpListener = new BasicAuthHttpListenerWrapper(httpListener, realmName);
        }
        StringBuilder deployedPath = new StringBuilder("");
        if (context != null) {
            if (!context.startsWith("/")) {
                deployedPath.append("/");
            }
            deployedPath.append(context);
            if (!context.endsWith("/")) {
                deployedPath.append("/");
            }
        } else {
            deployedPath.append("/");
        }
        if (path.startsWith("/") && path.length() > 1) {
            deployedPath.append(path.substring(1));
        } else if (path.length() > 1) {
            deployedPath.append(path);
        }
        this.addWrappedHttpListener(httpListener, classLoader, deployedPath.toString());
        return this.getResolvedAddresses(deployedPath.toString());
    }

    @Override
    public void removeWsContainer(String path) {
        this.registry.removeHttpListener(path);
    }
}

