/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import javax.servlet.ServletContext;
import org.apache.catalina.Context;
import org.apache.catalina.Globals;
import org.apache.catalina.Lifecycle;
import org.apache.catalina.LifecycleEvent;
import org.apache.catalina.startup.TldConfig;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.config.TldScanner;
import org.apache.openejb.loader.IO;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.descriptor.XmlErrorHandler;
import org.apache.tomcat.util.file.Matcher;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomcat.util.scan.StandardJarScanner;
import org.apache.tomee.loader.EmbeddedJarScanner;

public class TomEEJarScanner
extends StandardJarScanner {
    private static final Log log = LogFactory.getLog(StandardJarScanner.class);
    protected static final Set<String[]> DEFAULT_JARS_TO_SKIP;
    private static final StringManager sm;
    private static final Method tldConfigScanStream;
    private static final Field tldConfig;
    private static final Method tldLocationScanStream;
    private static final Field tldLocationCache;
    private static final Set<URL> SERVER_URLS;
    private static final Set<String> TAG_LIB_URIS;
    private static final ArrayList<String> LISTENERS;
    private static final Hashtable<String, Object> MAPPINGS;
    private static final Thread SERVER_SCANNING_THREAD;

    public void scan(ServletContext context, ClassLoader classLoader, JarScannerCallback callback, Set<String> jarsToIgnore) {
        if ("FragmentJarScannerCallback".equals(callback.getClass().getSimpleName())) {
            EmbeddedJarScanner embeddedJarScanner = new EmbeddedJarScanner();
            embeddedJarScanner.scan(context, classLoader, callback, jarsToIgnore);
        } else if ("TldJarScannerCallback".equals(callback.getClass().getSimpleName())) {
            String cbName = callback.getClass().getName();
            if (cbName.equals(tldConfig.getDeclaringClass().getName())) {
                this.ensureServerTldsScanned();
                try {
                    TldConfig config;
                    try {
                        config = (TldConfig)tldConfig.get(callback);
                    }
                    catch (IllegalAccessException e) {
                        throw new OpenEJBException("scan with default algo");
                    }
                    Set urls = TldScanner.scan((ClassLoader)context.getClassLoader());
                    for (URL url : urls) {
                        if (SERVER_URLS.contains(url)) continue;
                        TomEEJarScanner.tldConfig(config, url);
                    }
                    for (String uri : TAG_LIB_URIS) {
                        config.addTaglibUri(uri);
                    }
                    for (String listener : LISTENERS) {
                        if ("org.apache.myfaces.webapp.StartupServletContextListener".equals(listener)) continue;
                        config.addApplicationListener(listener);
                    }
                    return;
                }
                catch (OpenEJBException oe) {}
            } else if (cbName.equals(tldLocationCache.getDeclaringClass().getName())) {
                this.ensureServerTldsScanned();
                try {
                    Object tldLocationsCache;
                    try {
                        tldLocationsCache = tldLocationCache.get(callback);
                    }
                    catch (IllegalAccessException e) {
                        throw new OpenEJBException("scan with default algo");
                    }
                    Set urls = TldScanner.scan((ClassLoader)context.getClassLoader());
                    for (URL url : urls) {
                        if (SERVER_URLS.contains(url)) continue;
                        TomEEJarScanner.tldLocationCache(tldLocationsCache, url);
                    }
                    Hashtable mappings = (Hashtable)Reflections.get((Object)tldLocationsCache, (String)"mappings");
                    mappings.putAll((Map)MAPPINGS.clone());
                    return;
                }
                catch (OpenEJBException oe) {}
            } else {
                log.debug((Object)("This callback " + callback + " is not known and perf optim will not be available"));
            }
            Set dirList = context.getResourcePaths("/WEB-INF/lib/");
            if (dirList != null) {
                for (String path : dirList) {
                    if (path.endsWith(".jar") && !Matcher.matchPath(DEFAULT_JARS_TO_SKIP, (String)path.substring(path.lastIndexOf(47) + 1))) {
                        URL url = null;
                        try {
                            String realPath = context.getRealPath(path);
                            url = realPath == null ? context.getResource(path) : new File(realPath).toURI().toURL();
                            this.process(callback, url);
                        }
                        catch (IOException e) {
                            log.warn((Object)sm.getString("jarScan.webinflibFail", new Object[]{url}), (Throwable)e);
                        }
                        continue;
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace((Object)sm.getString("jarScan.webinflibJarNoScan", new Object[]{path}));
                }
            }
            if (this.isScanClassPath()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)sm.getString("jarScan.classloaderStart"));
                }
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Set tldFileUrls = TldScanner.scan((ClassLoader)loader);
                    Set<URL> jarUlrs = this.discardFilePaths(tldFileUrls);
                    for (URL url : jarUlrs) {
                        String jarName = this.getJarName(url);
                        if (jarName != null && !Matcher.matchPath(DEFAULT_JARS_TO_SKIP, (String)jarName) && !url.toString().contains("/WEB-INF/lib/" + jarName)) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)sm.getString("jarScan.classloaderJarScan", new Object[]{url}));
                            }
                            try {
                                this.process(callback, url);
                            }
                            catch (IOException ioe) {
                                log.warn((Object)sm.getString("jarScan.classloaderFail", new Object[]{url}), (Throwable)ioe);
                            }
                            continue;
                        }
                        if (!log.isTraceEnabled()) continue;
                        log.trace((Object)sm.getString("jarScan.classloaderJarNoScan", new Object[]{url}));
                    }
                }
                catch (OpenEJBException e) {
                    log.warn((Object)"JarScan.TldScan Failed ", (Throwable)e);
                }
            }
        } else {
            super.scan(context, classLoader, callback, jarsToIgnore);
        }
    }

    private void ensureServerTldsScanned() {
        if (SERVER_SCANNING_THREAD == null) {
            return;
        }
        try {
            SERVER_SCANNING_THREAD.join();
        }
        catch (InterruptedException e) {
            throw new OpenEJBRuntimeException((Exception)e);
        }
    }

    private Set<URL> discardFilePaths(Set<URL> tldFileUrls) {
        HashSet<String> jarPaths = new HashSet<String>();
        for (URL tldFileUrl : tldFileUrls) {
            jarPaths.add(URLs.toFilePath((URL)tldFileUrl));
        }
        HashSet<URL> jars = new HashSet<URL>();
        for (String jarPath : jarPaths) {
            try {
                URL url = new File(jarPath).toURI().toURL();
                jars.add(url);
            }
            catch (MalformedURLException e) {
                log.warn((Object)("Skipping JAR file " + jarPath), (Throwable)e);
            }
        }
        return jars;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tldLocationCache(Object tldLocationsCache, URL url) {
        String resource = url.toString();
        String entry = null;
        if (resource.contains("!/")) {
            String path = url.getPath();
            int endIndex = path.indexOf("!/");
            resource = path.substring(0, endIndex);
            entry = path.substring(endIndex + 2, path.length());
        }
        InputStream is = null;
        try {
            is = url.openStream();
            tldLocationScanStream.invoke(tldLocationsCache, resource, entry, is);
        }
        catch (Exception e) {
            log.warn((Object)sm.getString("jarScan.webinflibFail", new Object[]{url.toExternalForm()}), (Throwable)e);
        }
        finally {
            IO.close((Closeable)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void tldConfig(TldConfig config, URL current) {
        InputStream is = null;
        try {
            is = current.openStream();
            XmlErrorHandler handler = (XmlErrorHandler)tldConfigScanStream.invoke((Object)config, is);
            handler.logFindings(log, current.toExternalForm());
        }
        catch (Exception e) {
            log.warn((Object)sm.getString("jarScan.webinflibFail", new Object[]{current}), (Throwable)e);
        }
        finally {
            IO.close((Closeable)is);
        }
    }

    private void process(JarScannerCallback callback, URL url) throws IOException {
        URLConnection conn = url.openConnection();
        if (conn instanceof JarURLConnection) {
            callback.scan((JarURLConnection)conn);
        } else {
            String urlStr = url.toString();
            if (urlStr.startsWith("file:") || urlStr.startsWith("jndi:")) {
                if (urlStr.endsWith(".jar")) {
                    URL jarURL = new URL("jar:" + urlStr + "!/");
                    callback.scan((JarURLConnection)jarURL.openConnection());
                } else {
                    try {
                        File metainf;
                        File f = new File(url.toURI());
                        if (f.isFile() && this.isScanAllFiles()) {
                            URL jarURL = new URL("jar:" + urlStr + "!/");
                            callback.scan((JarURLConnection)jarURL.openConnection());
                        } else if (f.isDirectory() && this.isScanAllDirectories() && (metainf = new File(f.getAbsoluteFile() + File.separator + "META-INF")).isDirectory()) {
                            callback.scan(f);
                        }
                    }
                    catch (URISyntaxException e) {
                        IOException ioe = new IOException();
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
            }
        }
    }

    private String getJarName(URL url) {
        String name = null;
        String path = url.getPath();
        int end = path.indexOf(".jar");
        if (end != -1) {
            int start = path.lastIndexOf(47, end);
            name = path.substring(start + 1, end + 4);
        } else if (this.isScanAllDirectories()) {
            int start = path.lastIndexOf(47);
            name = path.substring(start + 1);
        }
        return name;
    }

    static {
        sm = StringManager.getManager((String)"org.apache.tomcat.util.scan");
        HashSet<String> defaultJarsToSkip = new HashSet<String>();
        String jarList = System.getProperty("tomcat.util.scan.DefaultJarScanner.jarsToSkip");
        if (jarList != null) {
            StringTokenizer tokenizer = new StringTokenizer(jarList, ",");
            while (tokenizer.hasMoreElements()) {
                defaultJarsToSkip.add(tokenizer.nextToken());
            }
        }
        HashSet<String[]> ignoredJarsTokens = new HashSet<String[]>();
        for (String pattern : defaultJarsToSkip) {
            ignoredJarsTokens.add(Matcher.tokenizePathAsArray((String)pattern));
        }
        DEFAULT_JARS_TO_SKIP = ignoredJarsTokens;
        try {
            ClassLoader loader = TomEEJarScanner.class.getClassLoader();
            tldConfigScanStream = TldConfig.class.getDeclaredMethod("tldScanStream", InputStream.class);
            tldConfigScanStream.setAccessible(true);
            tldConfig = loader.loadClass("org.apache.catalina.startup.TldConfig$TldJarScannerCallback").getDeclaredFields()[0];
            tldConfig.setAccessible(true);
            final Class<?> tldLocationsCache = loader.loadClass("org.apache.jasper.compiler.TldLocationsCache");
            tldLocationScanStream = tldLocationsCache.getDeclaredMethod("tldScanStream", String.class, String.class, InputStream.class);
            tldLocationScanStream.setAccessible(true);
            tldLocationCache = loader.loadClass("org.apache.jasper.compiler.TldLocationsCache$TldJarScannerCallback").getDeclaredFields()[0];
            tldLocationCache.setAccessible(true);
            SERVER_URLS = TldScanner.scan((ClassLoader)TomEEJarScanner.class.getClassLoader());
            Context fakeWebApp = (Context)Proxy.newProxyInstance(loader, new Class[]{Context.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    if ("getTldNamespaceAware".equals(method.getName())) {
                        return Globals.STRICT_SERVLET_COMPLIANCE;
                    }
                    if ("getTldValidation".equals(method.getName())) {
                        return Globals.STRICT_SERVLET_COMPLIANCE;
                    }
                    if ("getXmlValidation".equals(method.getName())) {
                        return Globals.STRICT_SERVLET_COMPLIANCE;
                    }
                    if ("getXmlBlockExternal".equals(method.getName())) {
                        return Globals.IS_SECURITY_ENABLED;
                    }
                    return null;
                }
            });
            final TldConfig config = new TldConfig();
            config.lifecycleEvent(new LifecycleEvent((Lifecycle)fakeWebApp, "after_init", null));
            Object fakeSc = Proxy.newProxyInstance(loader, new Class[]{ServletContext.class}, new InvocationHandler(){

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    return null;
                }
            });
            final Object locationsCacheInstance = tldLocationsCache.getConstructor(ServletContext.class).newInstance(fakeSc);
            if (!SERVER_URLS.isEmpty()) {
                SERVER_SCANNING_THREAD = new Thread(){

                    @Override
                    public void run() {
                        for (URL current : SERVER_URLS) {
                            TomEEJarScanner.tldConfig(config, current);
                            if (tldLocationsCache == null) continue;
                            TomEEJarScanner.tldLocationCache(locationsCacheInstance, current);
                        }
                    }
                };
                SERVER_SCANNING_THREAD.setName("TomEE-server-tld-reading");
                SERVER_SCANNING_THREAD.setDaemon(true);
                SERVER_SCANNING_THREAD.start();
            } else {
                SERVER_SCANNING_THREAD = null;
            }
            TAG_LIB_URIS = (Set)Reflections.get((Object)config, (String)"taglibUris");
            LISTENERS = (ArrayList)Reflections.get((Object)config, (String)"listeners");
            MAPPINGS = (Hashtable)Reflections.get(locationsCacheInstance, (String)"mappings");
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
    }
}

