/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader;

import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Set;
import javax.servlet.ServletContext;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.JarScanner;
import org.apache.tomcat.JarScannerCallback;
import org.apache.tomcat.util.res.StringManager;
import org.apache.tomee.loader.UrlSet;

public class EmbeddedJarScanner
implements JarScanner {
    private static final Log log = LogFactory.getLog(EmbeddedJarScanner.class);
    private static final StringManager sm = StringManager.getManager((String)"org.apache.tomcat.util.scan");

    public void scan(ServletContext context, ClassLoader classloader, JarScannerCallback callback, Set<String> jarsToSkip) {
        try {
            UrlSet classpath = new UrlSet(classloader);
            UrlSet excluded = classpath.exclude(".*/WEB-INF/lib/.*");
            UrlSet scan = classpath.exclude(excluded);
            for (URL url : scan) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)sm.getString("jarScan.webinflibJarScan", new Object[]{url.toExternalForm()}));
                }
                try {
                    this.process(callback, url);
                }
                catch (IOException e) {
                    log.warn((Object)sm.getString("jarScan.webinflibFail", new Object[]{url}), (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            log.warn((Object)sm.getString("jarScan.classloaderFail", (Object[])new URL[0]), (Throwable)e);
        }
    }

    private void process(JarScannerCallback callback, URL url) throws IOException {
        URLConnection conn;
        if (log.isTraceEnabled()) {
            log.trace((Object)sm.getString("jarScan.jarUrlStart", new Object[]{url}));
        }
        if ((conn = url.openConnection()) instanceof JarURLConnection) {
            callback.scan((JarURLConnection)conn);
        } else {
            String urlStr = url.toString();
            if (urlStr.startsWith("file:") || urlStr.startsWith("jndi:")) {
                if (urlStr.endsWith(".jar")) {
                    URL jarURL = new URL("jar:" + urlStr + "!/");
                    callback.scan((JarURLConnection)jarURL.openConnection());
                } else {
                    try {
                        File metainf;
                        File f = new File(url.toURI());
                        if (f.isFile()) {
                            URL jarURL = new URL("jar:" + urlStr + "!/");
                            callback.scan((JarURLConnection)jarURL.openConnection());
                        } else if (f.isDirectory() && (metainf = new File(f.getAbsoluteFile() + File.separator + "META-INF")).isDirectory()) {
                            callback.scan(f);
                        }
                    }
                    catch (URISyntaxException e) {
                        IOException ioe = new IOException();
                        ioe.initCause(e);
                        throw ioe;
                    }
                }
            }
        }
    }
}

