/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.loader.service.helper;

import java.util.Map;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import org.apache.tomee.loader.service.helper.JndiHelperImpl;

public class JndiTreeHelperImpl {
    private final Context context;
    private final String path;

    private JndiTreeHelperImpl(Context ctx, String name) {
        this.path = name;
        this.context = ctx;
    }

    private Map<String, Object> runOnTree(Map<String, Object> root) {
        NamingEnumeration<Binding> ne;
        try {
            ne = this.context.listBindings(this.path);
        }
        catch (NamingException e) {
            return root;
        }
        while (ne.hasMoreElements()) {
            Binding current;
            try {
                current = ne.next();
            }
            catch (NamingException nnfe) {
                continue;
            }
            String name = current.getName();
            String fullName = this.path.concat("/").concat(name);
            Object obj = current.getObject();
            if (obj != null && obj instanceof Context) {
                JndiTreeHelperImpl.runOnJndiTree(this.context, JndiHelperImpl.createTreeNode("context", name, root), fullName);
                continue;
            }
            JndiHelperImpl.createTreeNode("leaf", fullName, root);
        }
        return root;
    }

    private static Map<String, Object> runOnJndiTree(Context ctx, Map<String, Object> root, String prefix) {
        return new JndiTreeHelperImpl(ctx, prefix).runOnTree(root);
    }

    public static Map<String, Object> runOnJndiTree(Context ctx, Map<String, Object> root) {
        return new JndiTreeHelperImpl(ctx, "").runOnTree(root);
    }
}

