/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.util;

import java.security.AccessController;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.util.GeneralException;
import serp.bytecode.BCClass;
import serp.bytecode.BCClassLoader;
import serp.bytecode.Project;

public class GeneratedClasses {
    public static ClassLoader getMostDerivedLoader(Class c1, Class c2) {
        ClassLoader l2;
        ClassLoader l1 = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction((Class)c1));
        if (l1 == (l2 = (ClassLoader)AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction((Class)c2)))) {
            return l1;
        }
        if (l1 == null) {
            return l2;
        }
        if (l2 == null) {
            return l1;
        }
        if (GeneratedClasses.canLoad(l1, c2)) {
            return l1;
        }
        return l2;
    }

    public static Class loadBCClass(BCClass bc, ClassLoader loader) {
        BCClassLoader bcloader = (BCClassLoader)AccessController.doPrivileged(J2DoPrivHelper.newBCClassLoaderAction((Project)bc.getProject(), (ClassLoader)loader));
        try {
            Class<?> c = Class.forName(bc.getName(), true, (ClassLoader)bcloader);
            bc.getProject().clear();
            return c;
        }
        catch (Throwable t) {
            throw new GeneralException(bc.getName()).setCause(t);
        }
    }

    private static boolean canLoad(ClassLoader loader, Class clazz) {
        Class<?> loaded = null;
        try {
            loaded = loader.loadClass(clazz.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return clazz == loaded;
    }
}

