/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller;

import java.io.File;
import java.util.ArrayList;
import java.util.Random;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.helix.controller.rebalancer.strategy.AutoRebalanceStrategy;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.spi.filesystem.LocalPinotFS;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerConf
extends PropertiesConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerConf.class);
    private static final String CONTROLLER_VIP_HOST = "controller.vip.host";
    private static final String CONTROLLER_VIP_PORT = "controller.vip.port";
    private static final String CONTROLLER_VIP_PROTOCOL = "controller.vip.protocol";
    private static final String CONTROLLER_HOST = "controller.host";
    private static final String CONTROLLER_PORT = "controller.port";
    private static final String DATA_DIR = "controller.data.dir";
    private static final String LOCAL_TEMP_DIR = "controller.local.temp.dir";
    private static final String ZK_STR = "controller.zk.str";
    private static final String UPDATE_SEGMENT_STATE_MODEL = "controller.update_segment_state_model";
    private static final String HELIX_CLUSTER_NAME = "controller.helix.cluster.name";
    private static final String CLUSTER_TENANT_ISOLATION_ENABLE = "cluster.tenant.isolation.enable";
    private static final String CONSOLE_WEBAPP_ROOT_PATH = "controller.query.console";
    private static final String CONSOLE_WEBAPP_USE_HTTPS = "controller.query.console.useHttps";
    private static final String EXTERNAL_VIEW_ONLINE_TO_OFFLINE_TIMEOUT = "controller.upload.onlineToOfflineTimeout";
    private static final String CONTROLLER_MODE = "controller.mode";
    private static final String LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY = "controller.resource.rebalance.strategy";
    private static final String SERVER_ADMIN_REQUEST_TIMEOUT_SECONDS = "server.request.timeoutSeconds";
    private static final String SEGMENT_COMMIT_TIMEOUT_SECONDS = "controller.realtime.segment.commit.timeoutSeconds";
    private static final String DELETED_SEGMENTS_RETENTION_IN_DAYS = "controller.deleted.segments.retentionInDays";
    private static final String TABLE_MIN_REPLICAS = "table.minReplicas";
    private static final String ENABLE_SPLIT_COMMIT = "controller.enable.split.commit";
    private static final String JERSEY_ADMIN_API_PORT = "jersey.admin.api.port";
    private static final String JERSEY_ADMIN_IS_PRIMARY = "jersey.admin.isprimary";
    private static final String ACCESS_CONTROL_FACTORY_CLASS = "controller.admin.access.control.factory.class";
    private static final String SEGMENT_UPLOAD_TIMEOUT_IN_MILLIS = "controller.segment.upload.timeoutInMillis";
    private static final String REALTIME_SEGMENT_METADATA_COMMIT_NUMLOCKS = "controller.realtime.segment.metadata.commit.numLocks";
    private static final String ENABLE_STORAGE_QUOTA_CHECK = "controller.enable.storage.quota.check";
    private static final String ENABLE_BATCH_MESSAGE_MODE = "controller.enable.batch.message.mode";
    private static final String ALLOW_HLC_TABLES = "controller.allow.hlc.tables";
    private static final String PINOT_FS_FACTORY_CLASS_PREFIX = "controller.storage.factory.class";
    private static final String PINOT_FS_FACTORY_CLASS_LOCAL = "controller.storage.factory.class.file";
    private static final long DEFAULT_EXTERNAL_VIEW_ONLINE_TO_OFFLINE_TIMEOUT_MILLIS = 120000L;
    private static final int DEFAULT_SERVER_ADMIN_REQUEST_TIMEOUT_SECONDS = 30;
    private static final int DEFAULT_DELETED_SEGMENTS_RETENTION_IN_DAYS = 7;
    private static final int DEFAULT_TABLE_MIN_REPLICAS = 1;
    private static final boolean DEFAULT_ENABLE_SPLIT_COMMIT = false;
    private static final int DEFAULT_JERSEY_ADMIN_PORT = 21000;
    private static final String DEFAULT_ACCESS_CONTROL_FACTORY_CLASS = "org.apache.pinot.controller.api.access.AllowAllAccessFactory";
    private static final long DEFAULT_SEGMENT_UPLOAD_TIMEOUT_IN_MILLIS = 600000L;
    private static final int DEFAULT_REALTIME_SEGMENT_METADATA_COMMIT_NUMLOCKS = 64;
    private static final boolean DEFAULT_ENABLE_STORAGE_QUOTA_CHECK = true;
    private static final boolean DEFAULT_ENABLE_BATCH_MESSAGE_MODE = false;
    private static final boolean DEFAULT_ALLOW_HLC_TABLES = true;
    private static final String DEFAULT_CONTROLLER_MODE = ControllerMode.DUAL.name();
    private static final String DEFAULT_LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY = AutoRebalanceStrategy.class.getName();
    private static final String DEFAULT_PINOT_FS_FACTORY_CLASS_LOCAL = LocalPinotFS.class.getName();

    public ControllerConf(File file) throws ConfigurationException {
        super(file);
    }

    public ControllerConf() {
    }

    public void setLocalTempDir(String localTempDir) {
        this.setProperty(LOCAL_TEMP_DIR, localTempDir);
    }

    public String getLocalTempDir() {
        return this.getString(LOCAL_TEMP_DIR);
    }

    public void setPinotFSFactoryClasses(Configuration pinotFSFactoryClasses) {
        this.setProperty(PINOT_FS_FACTORY_CLASS_LOCAL, DEFAULT_PINOT_FS_FACTORY_CLASS_LOCAL);
        if (pinotFSFactoryClasses != null) {
            pinotFSFactoryClasses.getKeys().forEachRemaining(key -> this.setProperty((String)key, pinotFSFactoryClasses.getProperty((String)key)));
        }
    }

    public void setSplitCommit(boolean isSplitCommit) {
        this.setProperty(ENABLE_SPLIT_COMMIT, isSplitCommit);
    }

    public void setQueryConsolePath(String path) {
        this.setProperty(CONSOLE_WEBAPP_ROOT_PATH, path);
    }

    public String getQueryConsoleWebappPath() {
        if (this.containsKey(CONSOLE_WEBAPP_ROOT_PATH)) {
            return (String)this.getProperty(CONSOLE_WEBAPP_ROOT_PATH);
        }
        return ControllerConf.class.getClassLoader().getResource("webapp").toExternalForm();
    }

    public void setQueryConsoleUseHttps(boolean useHttps) {
        this.setProperty(CONSOLE_WEBAPP_USE_HTTPS, useHttps);
    }

    public boolean getQueryConsoleUseHttps() {
        return this.containsKey(CONSOLE_WEBAPP_USE_HTTPS) && this.getBoolean(CONSOLE_WEBAPP_USE_HTTPS);
    }

    public void setJerseyAdminPrimary(String jerseyAdminPrimary) {
        this.setProperty(JERSEY_ADMIN_IS_PRIMARY, jerseyAdminPrimary);
    }

    public void setHelixClusterName(String clusterName) {
        this.setProperty(HELIX_CLUSTER_NAME, clusterName);
    }

    public void setControllerHost(String host) {
        this.setProperty(CONTROLLER_HOST, host);
    }

    public void setControllerVipHost(String vipHost) {
        this.setProperty(CONTROLLER_VIP_HOST, vipHost);
    }

    public void setControllerVipPort(String vipPort) {
        this.setProperty(CONTROLLER_VIP_PORT, vipPort);
    }

    public void setControllerVipProtocol(String vipProtocol) {
        this.setProperty(CONTROLLER_VIP_PROTOCOL, vipProtocol);
    }

    public void setControllerPort(String port) {
        this.setProperty(CONTROLLER_PORT, port);
    }

    public void setDataDir(String dataDir) {
        this.setProperty(DATA_DIR, dataDir);
    }

    public void setRealtimeSegmentCommitTimeoutSeconds(int timeoutSec) {
        this.setProperty(SEGMENT_COMMIT_TIMEOUT_SECONDS, Integer.toString(timeoutSec));
    }

    public void setUpdateSegmentStateModel(String updateStateModel) {
        this.setProperty(UPDATE_SEGMENT_STATE_MODEL, updateStateModel);
    }

    public void setZkStr(String zkStr) {
        this.setProperty(ZK_STR, zkStr);
    }

    public boolean isJerseyAdminPrimary() {
        return this.getBoolean(JERSEY_ADMIN_IS_PRIMARY, true);
    }

    public String getHelixClusterName() {
        return (String)this.getProperty(HELIX_CLUSTER_NAME);
    }

    public String getControllerHost() {
        return (String)this.getProperty(CONTROLLER_HOST);
    }

    public String getControllerPort() {
        return (String)this.getProperty(CONTROLLER_PORT);
    }

    public String getDataDir() {
        return (String)this.getProperty(DATA_DIR);
    }

    public int getSegmentCommitTimeoutSeconds() {
        if (this.containsKey(SEGMENT_COMMIT_TIMEOUT_SECONDS)) {
            return Integer.parseInt((String)this.getProperty(SEGMENT_COMMIT_TIMEOUT_SECONDS));
        }
        return SegmentCompletionProtocol.getDefaultMaxSegmentCommitTimeSeconds();
    }

    public boolean isUpdateSegmentStateModel() {
        if (this.containsKey(UPDATE_SEGMENT_STATE_MODEL)) {
            return Boolean.parseBoolean(this.getProperty(UPDATE_SEGMENT_STATE_MODEL).toString());
        }
        return false;
    }

    public String generateVipUrl() {
        return this.getControllerVipProtocol() + "://" + this.getControllerVipHost() + ":" + this.getControllerVipPort();
    }

    public String getZkStr() {
        Object zkAddressObj = this.getProperty(ZK_STR);
        if (zkAddressObj instanceof ArrayList) {
            ArrayList zkAddressList = (ArrayList)zkAddressObj;
            String[] zkAddress = zkAddressList.toArray(new String[0]);
            return StringUtil.join((String)",", (String[])zkAddress);
        }
        if (zkAddressObj instanceof String) {
            return (String)zkAddressObj;
        }
        throw new RuntimeException("Unexpected data type for zkAddress PropertiesConfiguration, expecting String but got " + zkAddressObj.getClass().getName());
    }

    public String toString() {
        return super.toString();
    }

    public Configuration getPinotFSFactoryClasses() {
        return this.subset(PINOT_FS_FACTORY_CLASS_PREFIX);
    }

    public boolean getAcceptSplitCommit() {
        return this.getBoolean(ENABLE_SPLIT_COMMIT, false);
    }

    public String getControllerVipHost() {
        if (this.containsKey(CONTROLLER_VIP_HOST) && ((String)this.getProperty(CONTROLLER_VIP_HOST)).length() > 0) {
            return (String)this.getProperty(CONTROLLER_VIP_HOST);
        }
        return (String)this.getProperty(CONTROLLER_HOST);
    }

    public String getControllerVipPort() {
        if (this.containsKey(CONTROLLER_VIP_PORT) && ((String)this.getProperty(CONTROLLER_VIP_PORT)).length() > 0) {
            return (String)this.getProperty(CONTROLLER_VIP_PORT);
        }
        return this.getControllerPort();
    }

    public String getControllerVipProtocol() {
        if (this.containsKey(CONTROLLER_VIP_PROTOCOL) && this.getProperty(CONTROLLER_VIP_PROTOCOL).equals("https")) {
            return "https";
        }
        return "http";
    }

    public int getRetentionControllerFrequencyInSeconds() {
        if (this.containsKey("controller.retention.frequencyInSeconds")) {
            return Integer.parseInt((String)this.getProperty("controller.retention.frequencyInSeconds"));
        }
        return 21600;
    }

    public void setRetentionControllerFrequencyInSeconds(int retentionFrequencyInSeconds) {
        this.setProperty("controller.retention.frequencyInSeconds", Integer.toString(retentionFrequencyInSeconds));
    }

    public int getOfflineSegmentIntervalCheckerFrequencyInSeconds() {
        if (this.containsKey("controller.offline.segment.interval.checker.frequencyInSeconds")) {
            return Integer.parseInt((String)this.getProperty("controller.offline.segment.interval.checker.frequencyInSeconds"));
        }
        return this.getInt("controller.segment.level.validation.intervalInSeconds", 86400);
    }

    public void setOfflineSegmentIntervalCheckerFrequencyInSeconds(int validationFrequencyInSeconds) {
        this.setProperty("controller.offline.segment.interval.checker.frequencyInSeconds", Integer.toString(validationFrequencyInSeconds));
    }

    public int getRealtimeSegmentValidationFrequencyInSeconds() {
        if (this.containsKey("controller.realtime.segment.validation.frequencyInSeconds")) {
            return Integer.parseInt((String)this.getProperty("controller.realtime.segment.validation.frequencyInSeconds"));
        }
        return this.getInt("controller.validation.frequencyInSeconds", 3600);
    }

    public void setRealtimeSegmentValidationFrequencyInSeconds(int validationFrequencyInSeconds) {
        this.setProperty("controller.realtime.segment.validation.frequencyInSeconds", Integer.toString(validationFrequencyInSeconds));
    }

    public int getBrokerResourceValidationFrequencyInSeconds() {
        if (this.containsKey("controller.broker.resource.validation.frequencyInSeconds")) {
            return Integer.parseInt((String)this.getProperty("controller.broker.resource.validation.frequencyInSeconds"));
        }
        return this.getInt("controller.validation.frequencyInSeconds", 3600);
    }

    public void setBrokerResourceValidationFrequencyInSeconds(int validationFrequencyInSeconds) {
        this.setProperty("controller.broker.resource.validation.frequencyInSeconds", Integer.toString(validationFrequencyInSeconds));
    }

    public long getBrokerResourceValidationInitialDelayInSeconds() {
        return this.getLong("controller.broker.resource.validation.initialDelayInSeconds", this.getPeriodicTaskInitialDelayInSeconds());
    }

    public int getStatusCheckerFrequencyInSeconds() {
        if (this.containsKey("controller.statuschecker.frequencyInSeconds")) {
            return Integer.parseInt((String)this.getProperty("controller.statuschecker.frequencyInSeconds"));
        }
        return 300;
    }

    public void setStatusCheckerFrequencyInSeconds(int statusCheckerFrequencyInSeconds) {
        this.setProperty("controller.statuschecker.frequencyInSeconds", Integer.toString(statusCheckerFrequencyInSeconds));
    }

    public String getRealtimeSegmentRelocatorFrequency() {
        if (this.containsKey("controller.realtime.segment.relocator.frequency")) {
            return (String)this.getProperty("controller.realtime.segment.relocator.frequency");
        }
        return "1h";
    }

    public void setRealtimeSegmentRelocatorFrequency(String relocatorFrequency) {
        this.setProperty("controller.realtime.segment.relocator.frequency", relocatorFrequency);
    }

    public int getStatusCheckerWaitForPushTimeInSeconds() {
        if (this.containsKey("controller.statuschecker.waitForPushTimeInSeconds")) {
            return Integer.parseInt((String)this.getProperty("controller.statuschecker.waitForPushTimeInSeconds"));
        }
        return 600;
    }

    public void setStatusCheckerWaitForPushTimeInSeconds(int statusCheckerWaitForPushTimeInSeconds) {
        this.setProperty("controller.statuschecker.waitForPushTimeInSeconds", Integer.toString(statusCheckerWaitForPushTimeInSeconds));
    }

    public long getExternalViewOnlineToOfflineTimeout() {
        if (this.containsKey(EXTERNAL_VIEW_ONLINE_TO_OFFLINE_TIMEOUT)) {
            return Integer.parseInt((String)this.getProperty(EXTERNAL_VIEW_ONLINE_TO_OFFLINE_TIMEOUT));
        }
        return 120000L;
    }

    public void setExternalViewOnlineToOfflineTimeout(long timeout) {
        this.setProperty(EXTERNAL_VIEW_ONLINE_TO_OFFLINE_TIMEOUT, timeout);
    }

    public boolean tenantIsolationEnabled() {
        if (this.containsKey(CLUSTER_TENANT_ISOLATION_ENABLE)) {
            return Boolean.parseBoolean(this.getProperty(CLUSTER_TENANT_ISOLATION_ENABLE).toString());
        }
        return true;
    }

    public void setTenantIsolationEnabled(boolean isSingleTenant) {
        this.setProperty(CLUSTER_TENANT_ISOLATION_ENABLE, isSingleTenant);
    }

    public void setServerAdminRequestTimeoutSeconds(int timeoutSeconds) {
        this.setProperty(SERVER_ADMIN_REQUEST_TIMEOUT_SECONDS, timeoutSeconds);
    }

    public int getServerAdminRequestTimeoutSeconds() {
        return this.getInt(SERVER_ADMIN_REQUEST_TIMEOUT_SECONDS, 30);
    }

    public int getDeletedSegmentsRetentionInDays() {
        return this.getInt(DELETED_SEGMENTS_RETENTION_IN_DAYS, 7);
    }

    public void setDeletedSegmentsRetentionInDays(int retentionInDays) {
        this.setProperty(DELETED_SEGMENTS_RETENTION_IN_DAYS, retentionInDays);
    }

    public int getTaskManagerFrequencyInSeconds() {
        return this.getInt("controller.task.frequencyInSeconds", -1);
    }

    public void setTaskManagerFrequencyInSeconds(int frequencyInSeconds) {
        this.setProperty("controller.task.frequencyInSeconds", Integer.toString(frequencyInSeconds));
    }

    public int getDefaultTableMinReplicas() {
        return this.getInt(TABLE_MIN_REPLICAS, 1);
    }

    public void setTableMinReplicas(int minReplicas) {
        this.setProperty(TABLE_MIN_REPLICAS, minReplicas);
    }

    public String getJerseyAdminApiPort() {
        return this.getString(JERSEY_ADMIN_API_PORT, String.valueOf(21000));
    }

    public String getAccessControlFactoryClass() {
        return this.getString(ACCESS_CONTROL_FACTORY_CLASS, DEFAULT_ACCESS_CONTROL_FACTORY_CLASS);
    }

    public void setAccessControlFactoryClass(String accessControlFactoryClass) {
        this.setProperty(ACCESS_CONTROL_FACTORY_CLASS, accessControlFactoryClass);
    }

    public long getSegmentUploadTimeoutInMillis() {
        return this.getLong(SEGMENT_UPLOAD_TIMEOUT_IN_MILLIS, 600000L);
    }

    public void setSegmentUploadTimeoutInMillis(long segmentUploadTimeoutInMillis) {
        this.setProperty(SEGMENT_UPLOAD_TIMEOUT_IN_MILLIS, segmentUploadTimeoutInMillis);
    }

    public int getRealtimeSegmentMetadataCommitNumLocks() {
        return this.getInt(REALTIME_SEGMENT_METADATA_COMMIT_NUMLOCKS, 64);
    }

    public void setRealtimeSegmentMetadataCommitNumLocks(int realtimeSegmentMetadataCommitNumLocks) {
        this.setProperty(REALTIME_SEGMENT_METADATA_COMMIT_NUMLOCKS, realtimeSegmentMetadataCommitNumLocks);
    }

    public boolean getEnableStorageQuotaCheck() {
        return this.getBoolean(ENABLE_STORAGE_QUOTA_CHECK, true);
    }

    public boolean getEnableBatchMessageMode() {
        return this.getBoolean(ENABLE_BATCH_MESSAGE_MODE, false);
    }

    public int getSegmentLevelValidationIntervalInSeconds() {
        return this.getInt("controller.segment.level.validation.intervalInSeconds", 86400);
    }

    public long getStatusCheckerInitialDelayInSeconds() {
        return this.getLong("controller.statusChecker.initialDelayInSeconds", ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds());
    }

    public long getRetentionManagerInitialDelayInSeconds() {
        return this.getLong("controller.retentionManager.initialDelayInSeconds", ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds());
    }

    public long getRealtimeSegmentRelocationInitialDelayInSeconds() {
        return this.getLong("controller.realtimeSegmentRelocation.initialDelayInSeconds", ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds());
    }

    public long getOfflineSegmentIntervalCheckerInitialDelayInSeconds() {
        return this.getLong("controller.offlineSegmentIntervalChecker.initialDelayInSeconds", ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds());
    }

    public long getRealtimeSegmentValidationManagerInitialDelaySeconds() {
        return this.getPeriodicTaskInitialDelayInSeconds();
    }

    public long getPinotTaskManagerInitialDelaySeconds() {
        return this.getPeriodicTaskInitialDelayInSeconds();
    }

    public long getPeriodicTaskInitialDelayInSeconds() {
        return ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds();
    }

    public void setControllerMode(ControllerMode controllerMode) {
        this.setProperty(CONTROLLER_MODE, controllerMode.name());
    }

    public ControllerMode getControllerMode() {
        return ControllerMode.valueOf(this.getString(CONTROLLER_MODE, DEFAULT_CONTROLLER_MODE).toUpperCase());
    }

    public void setLeadControllerResourceRebalanceStrategy(String rebalanceStrategy) {
        this.setProperty(LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY, rebalanceStrategy);
    }

    public String getLeadControllerResourceRebalanceStrategy() {
        return this.getString(LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY, DEFAULT_LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY);
    }

    public boolean getHLCTablesAllowed() {
        return this.getBoolean(ALLOW_HLC_TABLES, true);
    }

    public void setHLCTablesAllowed(boolean allowHLCTables) {
        this.setProperty(ALLOW_HLC_TABLES, allowHLCTables);
    }

    public String getMetricsPrefix() {
        return this.getString("controller.metrics.prefix", "pinot.controller");
    }

    public static class ControllerPeriodicTasksConf {
        private static final String RETENTION_MANAGER_FREQUENCY_IN_SECONDS = "controller.retention.frequencyInSeconds";
        @Deprecated
        private static final String DEPRECATED_VALIDATION_MANAGER_FREQUENCY_IN_SECONDS = "controller.validation.frequencyInSeconds";
        private static final String OFFLINE_SEGMENT_INTERVAL_CHECKER_FREQUENCY_IN_SECONDS = "controller.offline.segment.interval.checker.frequencyInSeconds";
        private static final String REALTIME_SEGMENT_VALIDATION_FREQUENCY_IN_SECONDS = "controller.realtime.segment.validation.frequencyInSeconds";
        private static final String BROKER_RESOURCE_VALIDATION_FREQUENCY_IN_SECONDS = "controller.broker.resource.validation.frequencyInSeconds";
        private static final String BROKER_RESOURCE_VALIDATION_INITIAL_DELAY_IN_SECONDS = "controller.broker.resource.validation.initialDelayInSeconds";
        private static final String STATUS_CHECKER_FREQUENCY_IN_SECONDS = "controller.statuschecker.frequencyInSeconds";
        private static final String STATUS_CHECKER_WAIT_FOR_PUSH_TIME_IN_SECONDS = "controller.statuschecker.waitForPushTimeInSeconds";
        private static final String TASK_MANAGER_FREQUENCY_IN_SECONDS = "controller.task.frequencyInSeconds";
        private static final String REALTIME_SEGMENT_RELOCATOR_FREQUENCY = "controller.realtime.segment.relocator.frequency";
        private static final String SEGMENT_LEVEL_VALIDATION_INTERVAL_IN_SECONDS = "controller.segment.level.validation.intervalInSeconds";
        private static final String STATUS_CHECKER_INITIAL_DELAY_IN_SECONDS = "controller.statusChecker.initialDelayInSeconds";
        private static final String RETENTION_MANAGER_INITIAL_DELAY_IN_SECONDS = "controller.retentionManager.initialDelayInSeconds";
        private static final String OFFLINE_SEGMENT_INTERVAL_CHECKER_INITIAL_DELAY_IN_SECONDS = "controller.offlineSegmentIntervalChecker.initialDelayInSeconds";
        private static final String REALTIME_SEGMENT_RELOCATION_INITIAL_DELAY_IN_SECONDS = "controller.realtimeSegmentRelocation.initialDelayInSeconds";
        public static final int MIN_INITIAL_DELAY_IN_SECONDS = 120;
        public static final int MAX_INITIAL_DELAY_IN_SECONDS = 300;
        private static final Random RANDOM = new Random();
        private static final int DEFAULT_RETENTION_CONTROLLER_FREQUENCY_IN_SECONDS = 21600;
        private static final int DEFAULT_OFFLINE_SEGMENT_INTERVAL_CHECKER_FREQUENCY_IN_SECONDS = 86400;
        private static final int DEFAULT_REALTIME_SEGMENT_VALIDATION_FREQUENCY_IN_SECONDS = 3600;
        private static final int DEFAULT_BROKER_RESOURCE_VALIDATION_FREQUENCY_IN_SECONDS = 3600;
        private static final int DEFAULT_STATUS_CONTROLLER_FREQUENCY_IN_SECONDS = 300;
        private static final int DEFAULT_STATUS_CONTROLLER_WAIT_FOR_PUSH_TIME_IN_SECONDS = 600;
        private static final int DEFAULT_TASK_MANAGER_FREQUENCY_IN_SECONDS = -1;
        private static final String DEFAULT_REALTIME_SEGMENT_RELOCATOR_FREQUENCY = "1h";
        private static final int DEFAULT_SEGMENT_LEVEL_VALIDATION_INTERVAL_IN_SECONDS = 86400;

        private static long getRandomInitialDelayInSeconds() {
            return 120 + RANDOM.nextInt(180);
        }
    }

    public static enum ControllerMode {
        DUAL,
        PINOT_ONLY,
        HELIX_ONLY;

    }
}

