/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api;

import com.google.common.base.Preconditions;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerAdminApiApplication
extends ResourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerAdminApiApplication.class);
    private HttpServer httpServer;
    private URI baseUri;
    private boolean started = false;
    private static final String RESOURCE_PACKAGE = "org.apache.pinot.controller.api.resources";
    private static String CONSOLE_WEB_PATH;
    private final boolean _useHttps;

    public ControllerAdminApiApplication(String consoleWebPath, boolean useHttps) {
        CONSOLE_WEB_PATH = consoleWebPath;
        this._useHttps = useHttps;
        if (!CONSOLE_WEB_PATH.endsWith("/")) {
            CONSOLE_WEB_PATH = CONSOLE_WEB_PATH + "/";
        }
        this.packages(new String[]{RESOURCE_PACKAGE});
        this.register(JacksonFeature.class);
        this.register(MultiPartFeature.class);
        this.registerClasses(new Class[]{ApiListingResource.class});
        this.registerClasses(new Class[]{SwaggerSerializers.class});
        this.register(new ContainerResponseFilter(){

            public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
                containerResponseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)"*");
            }
        });
    }

    public void registerBinder(AbstractBinder binder) {
        this.register(binder);
    }

    public boolean start(int httpPort) {
        Preconditions.checkArgument((httpPort > 0 ? 1 : 0) != 0);
        this.baseUri = URI.create("http://0.0.0.0:" + Integer.toString(httpPort) + "/");
        this.httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)this.baseUri, (ResourceConfig)this);
        this.setupSwagger(this.httpServer);
        ClassLoader classLoader = ControllerAdminApiApplication.class.getClassLoader();
        this.httpServer.getServerConfiguration().addHttpHandler((HttpHandler)new CLStaticHttpHandler(classLoader, new String[]{"/static/query/"}), new String[]{"/query/"});
        this.httpServer.getServerConfiguration().addHttpHandler((HttpHandler)new CLStaticHttpHandler(classLoader, new String[]{"/static/css/"}), new String[]{"/css/"});
        this.httpServer.getServerConfiguration().addHttpHandler((HttpHandler)new CLStaticHttpHandler(classLoader, new String[]{"/static/js/"}), new String[]{"/js/"});
        this.httpServer.getServerConfiguration().addHttpHandler((HttpHandler)new CLStaticHttpHandler(classLoader, new String[]{"/static/"}), new String[]{"/index.html"});
        this.started = true;
        LOGGER.info("Start jersey admin API on port: {}", (Object)httpPort);
        return true;
    }

    public URI getBaseUri() {
        return this.baseUri;
    }

    private void setupSwagger(HttpServer httpServer) {
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setTitle("Pinot Controller API");
        beanConfig.setDescription("APIs for accessing Pinot Controller information");
        beanConfig.setContact("https://github.com/apache/incubator-pinot");
        beanConfig.setVersion("1.0");
        if (this._useHttps) {
            beanConfig.setSchemes(new String[]{"https"});
        } else {
            beanConfig.setSchemes(new String[]{"http"});
        }
        beanConfig.setBasePath(this.baseUri.getPath());
        beanConfig.setResourcePackage(RESOURCE_PACKAGE);
        beanConfig.setScan(true);
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        CLStaticHttpHandler apiStaticHttpHandler = new CLStaticHttpHandler(loader, new String[]{"/api/"});
        httpServer.getServerConfiguration().addHttpHandler((HttpHandler)apiStaticHttpHandler, new String[]{"/api/"});
        httpServer.getServerConfiguration().addHttpHandler((HttpHandler)apiStaticHttpHandler, new String[]{"/help/"});
        URL swaggerDistLocation = loader.getResource("META-INF/resources/webjars/swagger-ui/2.2.2/");
        CLStaticHttpHandler swaggerDist = new CLStaticHttpHandler((ClassLoader)new URLClassLoader(new URL[]{swaggerDistLocation}), new String[0]);
        httpServer.getServerConfiguration().addHttpHandler((HttpHandler)swaggerDist, new String[]{"/swaggerui-dist/"});
    }

    public void stop() {
        if (!this.started) {
            return;
        }
        this.httpServer.shutdownNow();
    }
}

