/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.events;

import org.apache.commons.configuration.Configuration;
import org.apache.pinot.controller.api.events.DefaultMetadataEventNotifierFactory;
import org.apache.pinot.controller.api.events.MetadataEventNotifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MetadataEventNotifierFactory {
    public static final Logger LOGGER = LoggerFactory.getLogger(MetadataEventNotifierFactory.class);
    public static final String METADATA_EVENT_CLASS_CONFIG = "factory.class";

    public abstract void init(Configuration var1);

    public abstract MetadataEventNotifier create();

    public static MetadataEventNotifierFactory loadFactory(Configuration configuration) {
        String metadataEventNotifierClassName = configuration.getString(METADATA_EVENT_CLASS_CONFIG);
        if (metadataEventNotifierClassName == null) {
            metadataEventNotifierClassName = DefaultMetadataEventNotifierFactory.class.getName();
        }
        try {
            LOGGER.info("Instantiating metadata event notifier factory class {}", (Object)metadataEventNotifierClassName);
            MetadataEventNotifierFactory metadataEventNotifierFactory = (MetadataEventNotifierFactory)Class.forName(metadataEventNotifierClassName).newInstance();
            metadataEventNotifierFactory.init(configuration);
            return metadataEventNotifierFactory;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

