/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.controller.api.resources.StateType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Constants {
    private static final Logger LOGGER = LoggerFactory.getLogger(Constants.class);
    public static final String CLUSTER_TAG = "Cluster";
    public static final String TABLE_TAG = "Table";
    public static final String VERSION_TAG = "Version";
    public static final String HEALTH_TAG = "Health";
    public static final String INSTANCE_TAG = "Instance";
    public static final String SCHEMA_TAG = "Schema";
    public static final String TENANT_TAG = "Tenant";
    public static final String SEGMENT_TAG = "Segment";
    public static final String TASK_TAG = "Task";
    public static final String LEAD_CONTROLLER_TAG = "Leader";
    public static final String TABLE_NAME = "tableName";

    public static CommonConstants.Helix.TableType validateTableType(String tableTypeStr) {
        if (tableTypeStr == null || tableTypeStr.isEmpty()) {
            return null;
        }
        try {
            return CommonConstants.Helix.TableType.valueOf((String)tableTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Illegal table type '{}'", (Object)tableTypeStr);
            throw new WebApplicationException("Illegal table type '" + tableTypeStr + "'", Response.Status.BAD_REQUEST);
        }
    }

    public static StateType validateState(String stateStr) {
        if (stateStr == null) {
            return null;
        }
        try {
            return StateType.valueOf(stateStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            LOGGER.info("Illegal state '{}'", (Object)stateStr);
            throw new WebApplicationException("Illegal state '" + stateStr + "'", Response.Status.BAD_REQUEST);
        }
    }
}

