/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.helix.HelixManager;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.MasterSlaveSMD;
import org.apache.pinot.common.config.TableNameBuilder;
import org.apache.pinot.common.utils.helix.LeadControllerUtils;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Leader"})
@Path(value="/leader")
public class PinotLeadControllerRestletResource {
    public static Logger LOGGER = LoggerFactory.getLogger(PinotLeadControllerRestletResource.class);
    @Inject
    private PinotHelixResourceManager _pinotHelixResourceManager;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables")
    @ApiOperation(value="Gets leaders for all tables", notes="Gets leaders for all tables")
    public LeadControllerResponse getLeadersForAllTables() {
        boolean isLeadControllerResourceEnabled;
        LinkedHashMap<String, LeadControllerEntry> leadControllerEntryMap = new LinkedHashMap<String, LeadControllerEntry>();
        HelixManager helixManager = this._pinotHelixResourceManager.getHelixZkManager();
        try {
            isLeadControllerResourceEnabled = LeadControllerUtils.isLeadControllerResourceEnabled((HelixManager)helixManager);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Exception when checking whether lead controller resource is enabled or not.", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        if (!isLeadControllerResourceEnabled) {
            return new LeadControllerResponse(false, leadControllerEntryMap);
        }
        ExternalView leadControllerResourceExternalView = this.getLeadControllerResourceExternalView(helixManager);
        for (int partitionId = 0; partitionId < 24; ++partitionId) {
            String partitionName = LeadControllerUtils.generatePartitionName((int)partitionId);
            String participantInstanceId = this.getParticipantInstanceIdFromExternalView(leadControllerResourceExternalView, partitionName);
            leadControllerEntryMap.putIfAbsent(partitionName, new LeadControllerEntry(participantInstanceId, new ArrayList<String>()));
        }
        List<String> tableNames = this._pinotHelixResourceManager.getAllTables();
        for (String tableName : tableNames) {
            String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
            int partitionId = LeadControllerUtils.getPartitionIdForTable((String)rawTableName);
            String partitionName = LeadControllerUtils.generatePartitionName((int)partitionId);
            LeadControllerEntry leadControllerEntry = (LeadControllerEntry)leadControllerEntryMap.get(partitionName);
            leadControllerEntry.getTableNames().add(tableName);
        }
        return new LeadControllerResponse(true, leadControllerEntryMap);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}")
    @ApiOperation(value="Gets leader for a given table", notes="Gets leader for a given table")
    public LeadControllerResponse getLeaderForTable(@ApiParam(value="Table name", required=true) @PathParam(value="tableName") String tableName) {
        boolean isLeadControllerResourceEnabled;
        HashMap<String, LeadControllerEntry> leadControllerEntryMap = new HashMap<String, LeadControllerEntry>();
        HelixManager helixManager = this._pinotHelixResourceManager.getHelixZkManager();
        try {
            isLeadControllerResourceEnabled = LeadControllerUtils.isLeadControllerResourceEnabled((HelixManager)helixManager);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, "Exception when checking whether lead controller resource is enabled or not.", Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        if (!isLeadControllerResourceEnabled) {
            return new LeadControllerResponse(false, leadControllerEntryMap);
        }
        ExternalView leadControllerResourceExternalView = this.getLeadControllerResourceExternalView(helixManager);
        String rawTableName = TableNameBuilder.extractRawTableName((String)tableName);
        int partitionId = LeadControllerUtils.getPartitionIdForTable((String)rawTableName);
        String partitionName = LeadControllerUtils.generatePartitionName((int)partitionId);
        String leadControllerId = this.getParticipantInstanceIdFromExternalView(leadControllerResourceExternalView, partitionName);
        LeadControllerEntry leadControllerEntry = new LeadControllerEntry(leadControllerId, Collections.singletonList(tableName));
        leadControllerEntryMap.put(partitionName, leadControllerEntry);
        return new LeadControllerResponse(true, leadControllerEntryMap);
    }

    private ExternalView getLeadControllerResourceExternalView(HelixManager helixManager) {
        return helixManager.getClusterManagmentTool().getResourceExternalView(helixManager.getClusterName(), "leadControllerResource");
    }

    private String getParticipantInstanceIdFromExternalView(ExternalView leadControllerResourceExternalView, String partitionName) {
        if (leadControllerResourceExternalView == null) {
            LOGGER.warn("External view of lead controller resource is null!");
            return null;
        }
        Map partitionStateMap = leadControllerResourceExternalView.getStateMap(partitionName);
        for (Map.Entry entry : partitionStateMap.entrySet()) {
            if (!MasterSlaveSMD.States.MASTER.name().equals(entry.getValue())) continue;
            return (String)entry.getKey();
        }
        return null;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LeadControllerResponse {
        private boolean _isLeadControllerResourceEnabled;
        private Map<String, LeadControllerEntry> _leadControllerEntryMap;

        @JsonCreator
        public LeadControllerResponse(boolean isLeadControllerResourceEnabled, Map<String, LeadControllerEntry> leadControllerEntryMap) {
            this._isLeadControllerResourceEnabled = isLeadControllerResourceEnabled;
            this._leadControllerEntryMap = leadControllerEntryMap;
        }

        public boolean isLeadControllerResourceEnabled() {
            return this._isLeadControllerResourceEnabled;
        }

        public Map<String, LeadControllerEntry> getLeadControllerEntryMap() {
            return this._leadControllerEntryMap;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class LeadControllerEntry {
        private String _leadControllerId;
        private List<String> _tableNames;

        @JsonCreator
        public LeadControllerEntry(String leadControllerId, List<String> tableNames) {
            this._leadControllerId = leadControllerId;
            this._tableNames = tableNames;
        }

        @JsonProperty
        public String getLeadControllerId() {
            return this._leadControllerId;
        }

        @JsonProperty
        public List<String> getTableNames() {
            return this._tableNames;
        }
    }
}

