/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.Utils;
import org.apache.pinot.common.config.TableNameBuilder;
import org.apache.pinot.common.exception.QueryException;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.response.ProcessingException;
import org.apache.pinot.controller.api.access.AccessControl;
import org.apache.pinot.controller.api.access.AccessControlFactory;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.pql.parsers.Pql2Compiler;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.sql.parsers.CalciteSqlCompiler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class PinotQueryResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotQueryResource.class);
    private static final Pql2Compiler PQL_QUERY_COMPILER = new Pql2Compiler();
    private static final CalciteSqlCompiler SQL_QUERY_COMPILER = new CalciteSqlCompiler();
    private static final Random RANDOM = new Random();
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    AccessControlFactory _accessControlFactory;

    @Deprecated
    @POST
    @Path(value="pql")
    public String handlePostPql(String requestJsonStr, @Context HttpHeaders httpHeaders) {
        try {
            JsonNode requestJson = JsonUtils.stringToJsonNode((String)requestJsonStr);
            String pqlQuery = requestJson.get("pql").asText();
            String traceEnabled = "false";
            if (requestJson.has("trace")) {
                traceEnabled = requestJson.get("trace").toString();
            }
            String queryOptions = null;
            if (requestJson.has("queryOptions")) {
                queryOptions = requestJson.get("queryOptions").asText();
            }
            LOGGER.debug("Trace: {}, Running query: {}", (Object)traceEnabled, (Object)pqlQuery);
            return this.getQueryResponse(pqlQuery, traceEnabled, queryOptions, httpHeaders, "pql");
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while processing post request", (Throwable)e);
            return QueryException.getException((ProcessingException)QueryException.INTERNAL_ERROR, (Exception)e).toString();
        }
    }

    @Deprecated
    @GET
    @Path(value="pql")
    public String handleGetPql(@QueryParam(value="pql") String pqlQuery, @QueryParam(value="trace") String traceEnabled, @QueryParam(value="queryOptions") String queryOptions, @Context HttpHeaders httpHeaders) {
        try {
            LOGGER.debug("Trace: {}, Running query: {}", (Object)traceEnabled, (Object)pqlQuery);
            return this.getQueryResponse(pqlQuery, traceEnabled, queryOptions, httpHeaders, "pql");
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while processing get request", (Throwable)e);
            return QueryException.getException((ProcessingException)QueryException.INTERNAL_ERROR, (Exception)e).toString();
        }
    }

    @POST
    @Path(value="sql")
    public String handlePostSql(String requestJsonStr, @Context HttpHeaders httpHeaders) {
        try {
            JsonNode requestJson = JsonUtils.stringToJsonNode((String)requestJsonStr);
            String sqlQuery = requestJson.get("sql").asText();
            String traceEnabled = "false";
            if (requestJson.has("trace")) {
                traceEnabled = requestJson.get("trace").toString();
            }
            String queryOptions = null;
            if (requestJson.has("queryOptions")) {
                queryOptions = requestJson.get("queryOptions").asText();
            }
            LOGGER.debug("Trace: {}, Running query: {}", (Object)traceEnabled, (Object)sqlQuery);
            return this.getQueryResponse(sqlQuery, traceEnabled, queryOptions, httpHeaders, "sql");
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while processing post request", (Throwable)e);
            return QueryException.getException((ProcessingException)QueryException.INTERNAL_ERROR, (Exception)e).toString();
        }
    }

    @GET
    @Path(value="sql")
    public String handleGetSql(@QueryParam(value="sql") String sqlQuery, @QueryParam(value="trace") String traceEnabled, @QueryParam(value="queryOptions") String queryOptions, @Context HttpHeaders httpHeaders) {
        try {
            LOGGER.debug("Trace: {}, Running query: {}", (Object)traceEnabled, (Object)sqlQuery);
            return this.getQueryResponse(sqlQuery, traceEnabled, queryOptions, httpHeaders, "sql");
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while processing get request", (Throwable)e);
            return QueryException.getException((ProcessingException)QueryException.INTERNAL_ERROR, (Exception)e).toString();
        }
    }

    public String getQueryResponse(String query, String traceEnabled, String queryOptions, HttpHeaders httpHeaders, String querySyntax) {
        BrokerRequest brokerRequest;
        try {
            switch (querySyntax) {
                case "sql": {
                    brokerRequest = SQL_QUERY_COMPILER.compileToBrokerRequest(query);
                    break;
                }
                case "pql": {
                    brokerRequest = PQL_QUERY_COMPILER.compileToBrokerRequest(query);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported query syntax - " + querySyntax);
                }
            }
            String inputTableName = brokerRequest.getQuerySource().getTableName();
            brokerRequest.getQuerySource().setTableName(this._pinotHelixResourceManager.getActualTableName(inputTableName));
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while compiling {} query: {}", new Object[]{querySyntax.toUpperCase(), query, e});
            return QueryException.getException((ProcessingException)QueryException.PQL_PARSING_ERROR, (Exception)e).toString();
        }
        String tableName = TableNameBuilder.extractRawTableName((String)brokerRequest.getQuerySource().getTableName());
        AccessControl accessControl = this._accessControlFactory.create();
        if (!accessControl.hasDataAccess(httpHeaders, tableName)) {
            return QueryException.ACCESS_DENIED_ERROR.toString();
        }
        List<String> instanceIds = this._pinotHelixResourceManager.getBrokerInstancesFor(tableName);
        if (instanceIds.isEmpty()) {
            return QueryException.BROKER_RESOURCE_MISSING_ERROR.toString();
        }
        instanceIds.retainAll(this._pinotHelixResourceManager.getOnlineInstanceList());
        if (instanceIds.isEmpty()) {
            return QueryException.BROKER_INSTANCE_MISSING_ERROR.toString();
        }
        String instanceId = instanceIds.get(RANDOM.nextInt(instanceIds.size()));
        InstanceConfig instanceConfig = this._pinotHelixResourceManager.getHelixInstanceConfig(instanceId);
        if (instanceConfig == null) {
            LOGGER.error("Instance {} not found", (Object)instanceId);
            return QueryException.INTERNAL_ERROR.toString();
        }
        String hostNameWithPrefix = instanceConfig.getHostName();
        String url = this.getQueryURL(hostNameWithPrefix.substring(hostNameWithPrefix.indexOf("_") + 1), instanceConfig.getPort(), querySyntax);
        ObjectNode requestJson = this.getRequestJson(query, traceEnabled, queryOptions, querySyntax);
        return this.sendRequestRaw(url, query, requestJson);
    }

    private ObjectNode getRequestJson(String query, String traceEnabled, String queryOptions, String querySyntax) {
        ObjectNode requestJson = JsonUtils.newObjectNode();
        switch (querySyntax) {
            case "sql": {
                requestJson.put("sql", query);
                break;
            }
            case "pql": {
                requestJson.put("pql", query);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported query syntax - " + querySyntax);
            }
        }
        if (traceEnabled != null && !traceEnabled.isEmpty()) {
            requestJson.put("trace", traceEnabled);
        }
        if (queryOptions != null && !queryOptions.isEmpty()) {
            requestJson.put("queryOptions", queryOptions);
        }
        return requestJson;
    }

    private String getQueryURL(String hostName, String port, String querySyntax) {
        switch (querySyntax) {
            case "sql": {
                return String.format("http://%s:%s/query/sql", hostName, port);
            }
            case "pql": {
                return String.format("http://%s:%s/query", hostName, port);
            }
        }
        throw new UnsupportedOperationException("Unsupported query syntax - " + querySyntax);
    }

    public String sendPostRaw(String urlStr, String requestStr, Map<String, String> headers) {
        HttpURLConnection conn = null;
        try {
            String output;
            LOGGER.info("url string passed is : " + urlStr);
            URL url = new URL(urlStr);
            conn = (HttpURLConnection)url.openConnection();
            conn.setDoOutput(true);
            conn.setRequestMethod("POST");
            conn.setRequestProperty("Accept-Encoding", "gzip");
            String string = requestStr;
            byte[] requestBytes = string.getBytes(StandardCharsets.UTF_8);
            conn.setRequestProperty("Content-Length", String.valueOf(requestBytes.length));
            conn.setRequestProperty("http.keepAlive", String.valueOf(true));
            conn.setRequestProperty("default", String.valueOf(true));
            if (headers != null && headers.size() > 0) {
                Set<Map.Entry<String, String>> entries = headers.entrySet();
                for (Map.Entry<String, String> entry : entries) {
                    conn.setRequestProperty(entry.getKey(), entry.getValue());
                }
            }
            BufferedOutputStream os = new BufferedOutputStream(conn.getOutputStream());
            ((OutputStream)os).write(requestBytes);
            ((OutputStream)os).flush();
            ((OutputStream)os).close();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                throw new IOException("Failed : HTTP error code : " + responseCode);
            }
            byte[] bytes = this.drain(new BufferedInputStream(conn.getInputStream()));
            String string2 = output = new String(bytes, StandardCharsets.UTF_8);
            return string2;
        }
        catch (Exception ex) {
            LOGGER.error("Caught exception while sending query request", (Throwable)ex);
            Utils.rethrowException((Throwable)ex);
            throw new AssertionError((Object)"Should not reach this");
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] drain(InputStream inputStream) throws IOException {
        try {
            int len;
            byte[] buf = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while ((len = inputStream.read(buf)) > 0) {
                byteArrayOutputStream.write(buf, 0, len);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            return byArray;
        }
        finally {
            inputStream.close();
        }
    }

    public String sendRequestRaw(String url, String query, ObjectNode requestJson) {
        try {
            long startTime = System.currentTimeMillis();
            String pinotResultString = this.sendPostRaw(url, requestJson.toString(), null);
            long queryTime = System.currentTimeMillis() - startTime;
            LOGGER.info("Query: " + query + " Time: " + queryTime);
            return pinotResultString;
        }
        catch (Exception ex) {
            LOGGER.error("Caught exception in sendQueryRaw", (Throwable)ex);
            Utils.rethrowException((Throwable)ex);
            throw new AssertionError((Object)"Should not reach this");
        }
    }
}

