/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"})
@Path(value="/")
public class PinotTableIndexingConfigs {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotTableIndexingConfigs.class);
    @Inject
    PinotHelixResourceManager pinotHelixResourceManager;

    @Deprecated
    @PUT
    @Path(value="/tables/{tableName}/indexingConfigs")
    @ApiOperation(value="Update table indexing configuration")
    @Produces(value={"application/json"})
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Table not found"), @ApiResponse(code=500, message="Server error updating configuration")})
    public SuccessResponse updateIndexingConfig(@ApiParam(value="Table name (without type)", required=true) @PathParam(value="tableName") String tableName, String body) {
        try {
            TableConfig tableConfig = TableConfig.fromJsonString((String)body);
            this.pinotHelixResourceManager.updateIndexingConfigFor(tableConfig.getTableName(), tableConfig.getTableType(), tableConfig.getIndexingConfig());
            return new SuccessResponse("Updated indexing config for table " + tableName);
        }
        catch (IOException e) {
            String errStr = "Error converting request to table config for table: " + tableName;
            throw new ControllerApplicationException(LOGGER, errStr, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        catch (Exception e) {
            String errStr = "Failed to update indexing config for table: " + tableName;
            throw new ControllerApplicationException(LOGGER, errStr, Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

