/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.commons.configuration.BaseConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.pinot.common.config.SegmentsValidationAndRetentionConfig;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.config.TableNameBuilder;
import org.apache.pinot.common.exception.TableNotFoundException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.api.resources.Constants;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.StateType;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.rebalance.RebalanceResult;
import org.apache.pinot.core.util.ReplicationUtils;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"})
@Path(value="/")
public class PinotTableRestletResource {
    public static Logger LOGGER = LoggerFactory.getLogger(PinotTableRestletResource.class);
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;
    @Inject
    ControllerConf _controllerConf;
    @Inject
    ControllerMetrics _controllerMetrics;
    @Inject
    ExecutorService _executorService;

    @POST
    @Produces(value={"application/json"})
    @Path(value="/tables")
    @ApiOperation(value="Adds a table", notes="Adds a table")
    public SuccessResponse addTable(String tableConfigStr) {
        String tableName;
        TableConfig tableConfig;
        try {
            tableConfig = TableConfig.fromJsonString((String)tableConfigStr);
            tableName = tableConfig.getTableName();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        try {
            this.ensureMinReplicas(tableConfig);
            this.verifyTableConfigs(tableConfig);
            this._pinotHelixResourceManager.addTable(tableConfig);
            return new SuccessResponse("Table " + tableName + " succesfully added");
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_ADD_ERROR, 1L);
            if (e instanceof PinotHelixResourceManager.InvalidTableConfigException) {
                String errStr = String.format("Invalid table config for table %s: %s", tableName, e.getMessage());
                throw new ControllerApplicationException(LOGGER, errStr, Response.Status.BAD_REQUEST, (Throwable)e);
            }
            if (e instanceof PinotHelixResourceManager.TableAlreadyExistsException) {
                throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.CONFLICT, (Throwable)e);
            }
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables")
    @ApiOperation(value="Lists all tables in cluster", notes="Lists all tables in cluster")
    public String listTableConfigs(@ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr) {
        try {
            CommonConstants.Helix.TableType tableType = null;
            if (tableTypeStr != null) {
                tableType = CommonConstants.Helix.TableType.valueOf((String)tableTypeStr.toUpperCase());
            }
            List<String> tableNames = tableType == null ? this._pinotHelixResourceManager.getAllRawTables() : (tableType == CommonConstants.Helix.TableType.REALTIME ? this._pinotHelixResourceManager.getAllRealtimeTables() : this._pinotHelixResourceManager.getAllOfflineTables());
            Collections.sort(tableNames);
            return JsonUtils.newObjectNode().set("tables", JsonUtils.objectToJsonNode(tableNames)).toString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    private String listTableConfigs(String tableName, @Nullable String tableTypeStr) {
        try {
            TableConfig tableConfig;
            ObjectNode ret = JsonUtils.newObjectNode();
            if ((tableTypeStr == null || CommonConstants.Helix.TableType.OFFLINE.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
                tableConfig = this._pinotHelixResourceManager.getOfflineTableConfig(tableName);
                Preconditions.checkNotNull((Object)tableConfig);
                ret.set(CommonConstants.Helix.TableType.OFFLINE.name(), (JsonNode)tableConfig.toJsonConfig());
            }
            if ((tableTypeStr == null || CommonConstants.Helix.TableType.REALTIME.name().equalsIgnoreCase(tableTypeStr)) && this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                tableConfig = this._pinotHelixResourceManager.getRealtimeTableConfig(tableName);
                Preconditions.checkNotNull((Object)tableConfig);
                ret.set(CommonConstants.Helix.TableType.REALTIME.name(), (JsonNode)tableConfig.toJsonConfig());
            }
            return ret.toString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}")
    @ApiOperation(value="Get/Enable/Disable/Drop a table", notes="Get/Enable/Disable/Drop a table. If table name is the only parameter specified , the tableconfig will be printed")
    public String alterTableStateOrListTableConfig(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="enable|disable|drop") @QueryParam(value="state") String stateStr, @ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr) {
        try {
            if (stateStr == null) {
                return this.listTableConfigs(tableName, tableTypeStr);
            }
            StateType stateType = Constants.validateState(stateStr);
            CommonConstants.Helix.TableType tableType = Constants.validateTableType(tableTypeStr);
            ArrayNode ret = JsonUtils.newArrayNode();
            boolean tableExists = false;
            if (tableType != CommonConstants.Helix.TableType.REALTIME && this._pinotHelixResourceManager.hasOfflineTable(tableName)) {
                String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(tableName);
                ObjectNode offline = JsonUtils.newObjectNode();
                tableExists = true;
                offline.put("tableName", offlineTableName);
                offline.set("state", JsonUtils.objectToJsonNode((Object)this._pinotHelixResourceManager.toggleTableState(offlineTableName, stateType)));
                ret.add((JsonNode)offline);
            }
            if (tableType != CommonConstants.Helix.TableType.OFFLINE && this._pinotHelixResourceManager.hasRealtimeTable(tableName)) {
                String realtimeTableName = TableNameBuilder.REALTIME.tableNameWithType(tableName);
                ObjectNode realtime = JsonUtils.newObjectNode();
                tableExists = true;
                realtime.put("tableName", realtimeTableName);
                realtime.set("state", JsonUtils.objectToJsonNode((Object)this._pinotHelixResourceManager.toggleTableState(realtimeTableName, stateType)));
                ret.add((JsonNode)realtime);
            }
            if (tableExists) {
                return ret.toString();
            }
            throw new ControllerApplicationException(LOGGER, "Table '" + tableName + "' does not exist", Response.Status.BAD_REQUEST);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/tables/{tableName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Deletes a table", notes="Deletes a table")
    public SuccessResponse deleteTable(@ApiParam(value="Name of the table to delete", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline") @QueryParam(value="type") String tableTypeStr) {
        CommonConstants.Helix.TableType tableType = Constants.validateTableType(tableTypeStr);
        LinkedList<String> tablesDeleted = new LinkedList<String>();
        try {
            boolean tableExist = false;
            if (this.verifyTableType(tableName, tableType, CommonConstants.Helix.TableType.OFFLINE)) {
                tableExist = this._pinotHelixResourceManager.hasOfflineTable(tableName);
                this._pinotHelixResourceManager.deleteOfflineTable(tableName);
                if (tableExist) {
                    tablesDeleted.add(TableNameBuilder.OFFLINE.tableNameWithType(tableName));
                }
            }
            if (this.verifyTableType(tableName, tableType, CommonConstants.Helix.TableType.REALTIME)) {
                tableExist = this._pinotHelixResourceManager.hasRealtimeTable(tableName);
                this._pinotHelixResourceManager.deleteRealtimeTable(tableName);
                if (tableExist) {
                    tablesDeleted.add(TableNameBuilder.REALTIME.tableNameWithType(tableName));
                }
            }
            if (!tablesDeleted.isEmpty()) {
                return new SuccessResponse("Tables: " + tablesDeleted + " deleted");
            }
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        throw new ControllerApplicationException(LOGGER, "Table '" + tableName + "' with type " + tableType + " does not exist", Response.Status.NOT_FOUND);
    }

    private boolean verifyTableType(String tableName, CommonConstants.Helix.TableType tableType, CommonConstants.Helix.TableType expectedType) {
        if (tableType != null && tableType != expectedType) {
            return false;
        }
        CommonConstants.Helix.TableType typeFromTableName = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        return typeFromTableName == null || typeFromTableName == expectedType;
    }

    @PUT
    @Path(value="/tables/{tableName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Updates table config for a table", notes="Updates table config for a table")
    public SuccessResponse updateTableConfig(@ApiParam(value="Name of the table to update", required=true) @PathParam(value="tableName") String tableName, String tableConfigStr) throws Exception {
        TableConfig tableConfig;
        try {
            tableConfig = TableConfig.fromJsonString((String)tableConfigStr);
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST);
        }
        try {
            String tableNameWithType = tableConfig.getTableName();
            if (!TableNameBuilder.forType((CommonConstants.Helix.TableType)tableConfig.getTableType()).tableNameWithType(tableName).equals(tableNameWithType)) {
                throw new ControllerApplicationException(LOGGER, "Request table " + tableName + " does not match table name in the body " + tableNameWithType, Response.Status.BAD_REQUEST);
            }
            if (!this._pinotHelixResourceManager.hasTable(tableNameWithType)) {
                throw new ControllerApplicationException(LOGGER, "Table " + tableNameWithType + " does not exist", Response.Status.NOT_FOUND);
            }
            this.ensureMinReplicas(tableConfig);
            this.verifyTableConfigs(tableConfig);
            this._pinotHelixResourceManager.updateTableConfig(tableConfig);
        }
        catch (PinotHelixResourceManager.InvalidTableConfigException e) {
            String errStr = String.format("Failed to update configuration for %s due to: %s", tableName, e.getMessage());
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_UPDATE_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, errStr, Response.Status.BAD_REQUEST, (Throwable)e);
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_UPDATE_ERROR, 1L);
            throw e;
        }
        return new SuccessResponse("Table config updated for " + tableName);
    }

    @POST
    @Path(value="/tables/validate")
    @Produces(value={"application/json"})
    @ApiOperation(value="Validate table config for a table", notes="This API returns the table config that matches the one you get from 'GET /tables/{tableName}'. This allows us to validate table config before apply.")
    public String checkTableConfig(String tableConfigStr) {
        try {
            ObjectNode tableConfigValidateStr = JsonUtils.newObjectNode();
            TableConfig tableConfig = TableConfig.fromJsonString((String)tableConfigStr);
            if (tableConfig.getTableType() == CommonConstants.Helix.TableType.OFFLINE) {
                tableConfigValidateStr.set(CommonConstants.Helix.TableType.OFFLINE.name(), (JsonNode)tableConfig.toJsonConfig());
            } else {
                tableConfigValidateStr.set(CommonConstants.Helix.TableType.REALTIME.name(), (JsonNode)tableConfig.toJsonConfig());
            }
            return tableConfigValidateStr.toString();
        }
        catch (Exception e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.BAD_REQUEST);
        }
    }

    private void ensureMinReplicas(TableConfig tableConfig) {
        boolean verifyReplication;
        boolean verifyReplicasPerPartition;
        SegmentsValidationAndRetentionConfig segmentsConfig = tableConfig.getValidationConfig();
        int configMinReplication = this._controllerConf.getDefaultTableMinReplicas();
        try {
            verifyReplicasPerPartition = ReplicationUtils.useReplicasPerPartition((TableConfig)tableConfig);
            verifyReplication = ReplicationUtils.useReplication((TableConfig)tableConfig);
        }
        catch (Exception e) {
            String errorMsg = String.format("Invalid tableIndexConfig or streamConfig: %s", e.getMessage());
            throw new PinotHelixResourceManager.InvalidTableConfigException(errorMsg, e);
        }
        if (verifyReplication) {
            try {
                int requestReplication = segmentsConfig.getReplicationNumber();
                if (requestReplication < configMinReplication) {
                    LOGGER.info("Creating table with minimum replication factor of: {} instead of requested replication: {}", (Object)configMinReplication, (Object)requestReplication);
                    segmentsConfig.setReplication(String.valueOf(configMinReplication));
                }
            }
            catch (NumberFormatException e) {
                throw new PinotHelixResourceManager.InvalidTableConfigException("Invalid replication number", e);
            }
        }
        if (verifyReplicasPerPartition) {
            String replicasPerPartitionStr = segmentsConfig.getReplicasPerPartition();
            if (replicasPerPartitionStr == null) {
                throw new PinotHelixResourceManager.InvalidTableConfigException("Field replicasPerPartition needs to be specified");
            }
            try {
                int replicasPerPartition = Integer.valueOf(replicasPerPartitionStr);
                if (replicasPerPartition < configMinReplication) {
                    LOGGER.info("Creating table with minimum replicasPerPartition of: {} instead of requested replicasPerPartition: {}", (Object)configMinReplication, (Object)replicasPerPartition);
                    segmentsConfig.setReplicasPerPartition(String.valueOf(configMinReplication));
                }
            }
            catch (NumberFormatException e) {
                throw new PinotHelixResourceManager.InvalidTableConfigException("Invalid value for replicasPerPartition: '" + replicasPerPartitionStr + "'", e);
            }
        }
    }

    private void verifyTableConfigs(TableConfig newTableConfig) {
        TimeUnit newTimeColumnType;
        String rawTableName = TableNameBuilder.extractRawTableName((String)newTableConfig.getTableName());
        LOGGER.info("Validating table configs for Table: {}", (Object)rawTableName);
        TableConfig tableConfigToCompare = null;
        if (newTableConfig.getTableType() == CommonConstants.Helix.TableType.REALTIME) {
            if (this._pinotHelixResourceManager.hasOfflineTable(rawTableName)) {
                tableConfigToCompare = this._pinotHelixResourceManager.getOfflineTableConfig(rawTableName);
            }
        } else if (this._pinotHelixResourceManager.hasRealtimeTable(rawTableName)) {
            tableConfigToCompare = this._pinotHelixResourceManager.getRealtimeTableConfig(rawTableName);
        }
        if (tableConfigToCompare == null) {
            LOGGER.info("Table: {} is not a hybrid table. Skipping consistency check across realtime and offline parts of the table.", (Object)rawTableName);
            return;
        }
        SegmentsValidationAndRetentionConfig newSegmentConfig = newTableConfig.getValidationConfig();
        SegmentsValidationAndRetentionConfig SegmentConfigToCompare = tableConfigToCompare.getValidationConfig();
        String newTimeColumnName = newSegmentConfig.getTimeColumnName();
        String existingTimeColumnName = SegmentConfigToCompare.getTimeColumnName();
        if (!Objects.equal((Object)existingTimeColumnName, (Object)newTimeColumnName)) {
            throw new PinotHelixResourceManager.InvalidTableConfigException(String.format("Time column names are different! Existing time column name: %s. New time column name: %s", existingTimeColumnName, newTimeColumnName));
        }
        TimeUnit existingTimeColumnType = SegmentConfigToCompare.getTimeType();
        if (existingTimeColumnType != (newTimeColumnType = newSegmentConfig.getTimeType())) {
            throw new PinotHelixResourceManager.InvalidTableConfigException(String.format("Time column types are different! Existing time column type: %s. New time column type: %s", new Object[]{existingTimeColumnType, newTimeColumnType}));
        }
        LOGGER.info("Finished validating tables config for Table: {}", (Object)rawTableName);
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/rebalance")
    @ApiOperation(value="Rebalances a table (reassign instances and segments for a table)", notes="Rebalances a table (reassign instances and segments for a table)")
    public RebalanceResult rebalance(@ApiParam(value="Name of the table to rebalance", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="OFFLINE|REALTIME", required=true) @QueryParam(value="type") String tableTypeStr, @ApiParam(value="Whether to rebalance table in dry-run mode") @DefaultValue(value="false") @QueryParam(value="dryRun") boolean dryRun, @ApiParam(value="Whether to reassign instances before reassigning segments") @DefaultValue(value="false") @QueryParam(value="reassignInstances") boolean reassignInstances, @ApiParam(value="Whether to reassign CONSUMING segments for real-time table") @DefaultValue(value="false") @QueryParam(value="includeConsuming") boolean includeConsuming, @ApiParam(value="Whether to allow downtime for the rebalance") @DefaultValue(value="false") @QueryParam(value="downtime") boolean downtime, @ApiParam(value="For no-downtime rebalance, minimum number of replicas to keep alive during rebalance, or maximum number of replicas allowed to be unavailable if value is negative") @DefaultValue(value="1") @QueryParam(value="minAvailableReplicas") int minAvailableReplicas, @ApiParam(value="Whether to use best-efforts to rebalance (not fail the rebalance when the no-downtime contract cannot be achieved)") @DefaultValue(value="false") @QueryParam(value="bestEfforts") boolean bestEfforts) {
        CommonConstants.Helix.TableType tableType;
        try {
            tableType = CommonConstants.Helix.TableType.valueOf((String)tableTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new ControllerApplicationException(LOGGER, "Illegal table type: " + tableTypeStr, Response.Status.BAD_REQUEST);
        }
        String tableNameWithType = TableNameBuilder.forType((CommonConstants.Helix.TableType)tableType).tableNameWithType(tableName);
        BaseConfiguration rebalanceConfig = new BaseConfiguration();
        rebalanceConfig.addProperty("dryRun", (Object)dryRun);
        rebalanceConfig.addProperty("reassignInstances", (Object)reassignInstances);
        rebalanceConfig.addProperty("includeConsuming", (Object)includeConsuming);
        rebalanceConfig.addProperty("downtime", (Object)downtime);
        rebalanceConfig.addProperty("minReplicasToKeepUpForNoDowntime", (Object)minAvailableReplicas);
        rebalanceConfig.addProperty("bestEfforts", (Object)bestEfforts);
        try {
            if (dryRun || downtime) {
                return this._pinotHelixResourceManager.rebalanceTable(tableNameWithType, (Configuration)rebalanceConfig);
            }
            rebalanceConfig.setProperty("dryRun", (Object)true);
            RebalanceResult dryRunResult = this._pinotHelixResourceManager.rebalanceTable(tableNameWithType, (Configuration)rebalanceConfig);
            if (dryRunResult.getStatus() == RebalanceResult.Status.DONE) {
                rebalanceConfig.setProperty("dryRun", (Object)false);
                this._executorService.submit(() -> this.lambda$rebalance$0(tableNameWithType, (Configuration)rebalanceConfig));
                return new RebalanceResult(RebalanceResult.Status.IN_PROGRESS, "In progress, check controller logs for updates", dryRunResult.getInstanceAssignment(), dryRunResult.getSegmentAssignment());
            }
            return dryRunResult;
        }
        catch (TableNotFoundException e) {
            throw new ControllerApplicationException(LOGGER, e.getMessage(), Response.Status.NOT_FOUND);
        }
    }

    private /* synthetic */ void lambda$rebalance$0(String tableNameWithType, Configuration rebalanceConfig) {
        try {
            this._pinotHelixResourceManager.rebalanceTable(tableNameWithType, rebalanceConfig);
        }
        catch (Throwable t) {
            LOGGER.error("Caught exception/error while rebalancing table: {}", (Object)tableNameWithType, (Object)t);
        }
    }
}

