/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import javax.inject.Inject;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"})
@Path(value="/")
public class PinotTableSegmentConfigs {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotTableSegmentConfigs.class);
    @Inject
    PinotHelixResourceManager pinotHelixResourceManager;
    @Inject
    ControllerMetrics metrics;

    @Deprecated
    @PUT
    @Path(value="/tables/{tableName}/segmentConfigs")
    @Produces(value={"application/json"})
    @ApiOperation(value="Update segments configuration", notes="Updates segmentsConfig section (validation and retention) of a table")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Table not found"), @ApiResponse(code=500, message="Internal server error")})
    public SuccessResponse put(@ApiParam(value="Table name", required=true) @PathParam(value="tableName") String tableName, String requestBody) {
        try {
            TableConfig tableConfig = TableConfig.fromJsonString((String)requestBody);
            this.pinotHelixResourceManager.updateSegmentsValidationAndRetentionConfigFor(tableConfig.getTableName(), tableConfig.getTableType(), tableConfig.getValidationConfig());
            return new SuccessResponse("Update segmentsConfig for table: " + tableName);
        }
        catch (IOException e) {
            this.metrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_SCHEMA_UPDATE_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, String.format("Invalid json while updating segments config for table: %s", tableName), Response.Status.BAD_REQUEST, (Throwable)e);
        }
        catch (Exception e) {
            this.metrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_SCHEMA_UPDATE_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, String.format("Failed to update segments config for table: %s", tableName), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }
}

