/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.QueryParam;
import org.apache.helix.task.TaskState;
import org.apache.pinot.common.config.PinotTaskConfig;
import org.apache.pinot.controller.api.resources.StringResultResponse;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.minion.PinotHelixTaskResourceManager;
import org.apache.pinot.controller.helix.core.minion.PinotTaskManager;

@Api(tags={"Task"})
@Path(value="/")
public class PinotTaskRestletResource {
    private static final String TASK_QUEUE_STATE_STOP = "STOP";
    private static final String TASK_QUEUE_STATE_RESUME = "RESUME";
    @Inject
    PinotHelixTaskResourceManager _pinotHelixTaskResourceManager;
    @Inject
    PinotTaskManager _pinotTaskManager;

    @GET
    @Path(value="/tasks/tasktypes")
    @ApiOperation(value="List all task types")
    public Set<String> listTaskTypes() {
        return this._pinotHelixTaskResourceManager.getTaskTypes();
    }

    @Deprecated
    @GET
    @Path(value="/tasks/taskqueues")
    @ApiOperation(value="List all task queues (deprecated)")
    public Set<String> getTaskQueues() {
        return this._pinotHelixTaskResourceManager.getTaskQueues();
    }

    @GET
    @Path(value="/tasks/{taskType}/state")
    @ApiOperation(value="Get the state (task queue state) for the given task type")
    public TaskState getTaskQueueState(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        return this._pinotHelixTaskResourceManager.getTaskQueueState(taskType);
    }

    @Deprecated
    @GET
    @Path(value="/tasks/taskqueuestate/{taskType}")
    @ApiOperation(value="Get the state (task queue state) for the given task type (deprecated)")
    public StringResultResponse getTaskQueueStateDeprecated(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        return new StringResultResponse(this._pinotHelixTaskResourceManager.getTaskQueueState(taskType).toString());
    }

    @GET
    @Path(value="/tasks/{taskType}/tasks")
    @ApiOperation(value="List all tasks for the given task type")
    public Set<String> getTasks(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        return this._pinotHelixTaskResourceManager.getTasks(taskType);
    }

    @Deprecated
    @GET
    @Path(value="/tasks/tasks/{taskType}")
    @ApiOperation(value="List all tasks for the given task type (deprecated)")
    public Set<String> getTasksDeprecated(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        return this._pinotHelixTaskResourceManager.getTasks(taskType);
    }

    @GET
    @Path(value="/tasks/{taskType}/taskstates")
    @ApiOperation(value="Get a map from task to task state for the given task type")
    public Map<String, TaskState> getTaskStates(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        return this._pinotHelixTaskResourceManager.getTaskStates(taskType);
    }

    @Deprecated
    @GET
    @Path(value="/tasks/taskstates/{taskType}")
    @ApiOperation(value="Get a map from task to task state for the given task type (deprecated)")
    public Map<String, TaskState> getTaskStatesDeprecated(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        return this._pinotHelixTaskResourceManager.getTaskStates(taskType);
    }

    @GET
    @Path(value="/tasks/task/{taskName}/state")
    @ApiOperation(value="Get the task state for the given task")
    public TaskState getTaskState(@ApiParam(value="Task name", required=true) @PathParam(value="taskName") String taskName) {
        return this._pinotHelixTaskResourceManager.getTaskState(taskName);
    }

    @Deprecated
    @GET
    @Path(value="/tasks/taskstate/{taskName}")
    @ApiOperation(value="Get the task state for the given task (deprecated)")
    public StringResultResponse getTaskStateDeprecated(@ApiParam(value="Task name", required=true) @PathParam(value="taskName") String taskName) {
        return new StringResultResponse(this._pinotHelixTaskResourceManager.getTaskState(taskName).toString());
    }

    @GET
    @Path(value="/tasks/task/{taskName}/config")
    @ApiOperation(value="Get the task config (a list of child task configs) for the given task")
    public List<PinotTaskConfig> getTaskConfigs(@ApiParam(value="Task name", required=true) @PathParam(value="taskName") String taskName) {
        return this._pinotHelixTaskResourceManager.getTaskConfigs(taskName);
    }

    @Deprecated
    @GET
    @Path(value="/tasks/taskconfig/{taskName}")
    @ApiOperation(value="Get the task config (a list of child task configs) for the given task (deprecated)")
    public List<PinotTaskConfig> getTaskConfigsDeprecated(@ApiParam(value="Task name", required=true) @PathParam(value="taskName") String taskName) {
        return this._pinotHelixTaskResourceManager.getTaskConfigs(taskName);
    }

    @POST
    @Path(value="/tasks/schedule")
    @ApiOperation(value="Schedule tasks")
    public Map<String, String> scheduleTasks() {
        return this._pinotTaskManager.scheduleTasks();
    }

    @Deprecated
    @PUT
    @Path(value="/tasks/scheduletasks")
    @ApiOperation(value="Schedule tasks (deprecated)")
    public Map<String, String> scheduleTasksDeprecated() {
        return this._pinotTaskManager.scheduleTasks();
    }

    @PUT
    @Path(value="/tasks/{taskType}/cleanup")
    @ApiOperation(value="Clean up finished tasks (COMPLETED, FAILED) for the given task type")
    public SuccessResponse cleanUpTasks(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        this._pinotHelixTaskResourceManager.cleanUpTaskQueue(taskType);
        return new SuccessResponse("Successfully cleaned up tasks for task type: " + taskType);
    }

    @Deprecated
    @PUT
    @Path(value="/tasks/cleanuptasks/{taskType}")
    @ApiOperation(value="Clean up finished tasks (COMPLETED, FAILED) for the given task type (deprecated)")
    public SuccessResponse cleanUpTasksDeprecated(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        this._pinotHelixTaskResourceManager.cleanUpTaskQueue(taskType);
        return new SuccessResponse("Successfully cleaned up tasks for task type: " + taskType);
    }

    @PUT
    @Path(value="/tasks/{taskType}/stop")
    @ApiOperation(value="Stop all running/pending tasks (as well as the task queue) for the given task type")
    public SuccessResponse stopTasks(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        this._pinotHelixTaskResourceManager.stopTaskQueue(taskType);
        return new SuccessResponse("Successfully stopped tasks for task type: " + taskType);
    }

    @PUT
    @Path(value="/tasks/{taskType}/resume")
    @ApiOperation(value="Resume all stopped tasks (as well as the task queue) for the given task type")
    public SuccessResponse resumeTasks(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType) {
        this._pinotHelixTaskResourceManager.resumeTaskQueue(taskType);
        return new SuccessResponse("Successfully resumed tasks for task type: " + taskType);
    }

    @Deprecated
    @PUT
    @Path(value="/tasks/taskqueue/{taskType}")
    @ApiOperation(value="Stop/resume a task queue (deprecated)")
    public SuccessResponse toggleTaskQueueState(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType, @ApiParam(value="state", required=true) @QueryParam(value="state") String state) {
        switch (state.toUpperCase()) {
            case "STOP": {
                this._pinotHelixTaskResourceManager.stopTaskQueue(taskType);
                return new SuccessResponse("Successfully stopped task queue for task type: " + taskType);
            }
            case "RESUME": {
                this._pinotHelixTaskResourceManager.resumeTaskQueue(taskType);
                return new SuccessResponse("Successfully resumed task queue for task type: " + taskType);
            }
        }
        throw new IllegalArgumentException("Unsupported state: " + state);
    }

    @DELETE
    @Path(value="/tasks/{taskType}")
    @ApiOperation(value="Delete all tasks (as well as the task queue) for the given task type")
    public SuccessResponse deleteTasks(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType, @ApiParam(value="Whether to force deleting the tasks (expert only option, enable with cautious") @DefaultValue(value="false") @QueryParam(value="forceDelete") boolean forceDelete) {
        this._pinotHelixTaskResourceManager.deleteTaskQueue(taskType, forceDelete);
        return new SuccessResponse("Successfully deleted tasks for task type: " + taskType);
    }

    @Deprecated
    @DELETE
    @Path(value="/tasks/taskqueue/{taskType}")
    @ApiOperation(value="Delete a task queue (deprecated)")
    public SuccessResponse deleteTaskQueue(@ApiParam(value="Task type", required=true) @PathParam(value="taskType") String taskType, @ApiParam(value="Whether to force delete the task queue (expert only option, enable with cautious") @DefaultValue(value="false") @QueryParam(value="forceDelete") boolean forceDelete) {
        this._pinotHelixTaskResourceManager.deleteTaskQueue(taskType, forceDelete);
        return new SuccessResponse("Successfully deleted task queue for task type: " + taskType);
    }
}

