/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.config.Tenant;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerMeter;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.utils.TenantRole;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.StateType;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.PinotResourceManagerResponse;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Tenant"})
@Path(value="/")
public class PinotTenantRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotTenantRestletResource.class);
    private static final String TENANT_NAME = "tenantName";
    private static final String TABLES = "tables";
    @Inject
    PinotHelixResourceManager pinotHelixResourceManager;
    @Inject
    ControllerMetrics _controllerMetrics;

    @POST
    @Path(value="/tenants")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value=" Create a tenant")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Error creating tenant")})
    public SuccessResponse createTenant(Tenant tenant) {
        PinotResourceManagerResponse response;
        switch (tenant.getTenantRole()) {
            case BROKER: {
                response = this.pinotHelixResourceManager.createBrokerTenant(tenant);
                break;
            }
            case SERVER: {
                response = this.pinotHelixResourceManager.createServerTenant(tenant);
                break;
            }
            default: {
                throw new RuntimeException("Not a valid tenant creation call");
            }
        }
        if (response.isSuccessful()) {
            return new SuccessResponse("Successfully created tenant");
        }
        this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_TENANT_CREATE_ERROR, 1L);
        throw new ControllerApplicationException(LOGGER, "Failed to create tenant", Response.Status.INTERNAL_SERVER_ERROR);
    }

    @PUT
    @Path(value="/tenants")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update a tenant")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Failed to update the tenant")})
    public SuccessResponse updateTenant(Tenant tenant) {
        PinotResourceManagerResponse response;
        switch (tenant.getTenantRole()) {
            case BROKER: {
                response = this.pinotHelixResourceManager.updateBrokerTenant(tenant);
                break;
            }
            case SERVER: {
                response = this.pinotHelixResourceManager.updateServerTenant(tenant);
                break;
            }
            default: {
                throw new RuntimeException("Not a valid tenant update call");
            }
        }
        if (response.isSuccessful()) {
            return new SuccessResponse("Updated tenant");
        }
        this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_TENANT_UPDATE_ERROR, 1L);
        throw new ControllerApplicationException(LOGGER, "Failed to update tenant", Response.Status.INTERNAL_SERVER_ERROR);
    }

    @GET
    @Path(value="/tenants")
    @Produces(value={"application/json"})
    @ApiOperation(value="List all tenants")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Error reading tenants list")})
    public TenantsList getAllTenants(@ApiParam(value="Tenant type", required=false, allowableValues="BROKER, SERVER", defaultValue="") @QueryParam(value="type") @DefaultValue(value="") String type) {
        TenantsList tenants = new TenantsList();
        if (type == null || type.isEmpty() || type.equalsIgnoreCase("server")) {
            tenants.serverTenants = this.pinotHelixResourceManager.getAllServerTenantNames();
        }
        if (type == null || type.isEmpty() || type.equalsIgnoreCase("broker")) {
            tenants.brokerTenants = this.pinotHelixResourceManager.getAllBrokerTenantNames();
        }
        return tenants;
    }

    @GET
    @Path(value="/tenants/{tenantName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="List instance for a tenant, or enable/disable/drop a tenant")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Error reading tenants list")})
    public String listInstanceOrToggleTenantState(@ApiParam(value="Tenant name", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="Tenant type (server|broker)") @QueryParam(value="type") String tenantType, @ApiParam(value="state") @QueryParam(value="state") String stateStr) throws Exception {
        if (stateStr == null) {
            return this.listInstancesForTenant(tenantName, tenantType);
        }
        return this.toggleTenantState(tenantName, stateStr, tenantType);
    }

    @GET
    @Path(value="/tenants/{tenantName}/tables")
    @Produces(value={"application/json"})
    @ApiOperation(value="List tables on a a server tenant")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Error reading list")})
    public String getTablesOnTenant(@ApiParam(value="Tenant name", required=true) @PathParam(value="tenantName") String tenantName) {
        return this.getTablesServedFromTenant(tenantName);
    }

    private String getTablesServedFromTenant(String tenantName) {
        HashSet<String> tables = new HashSet<String>();
        ObjectNode resourceGetRet = JsonUtils.newObjectNode();
        for (String table : this.pinotHelixResourceManager.getAllTables()) {
            TableConfig tableConfig = this.pinotHelixResourceManager.getTableConfig(table);
            String tableConfigTenant = tableConfig.getTenantConfig().getServer();
            if (!tenantName.equals(tableConfigTenant)) continue;
            tables.add(table);
        }
        resourceGetRet.set(TABLES, JsonUtils.objectToJsonNode(tables));
        return resourceGetRet.toString();
    }

    private String toggleTenantState(String tenantName, String stateStr, @Nullable String tenantType) {
        Set<Object> serverInstances = new HashSet();
        Set<Object> brokerInstances = new HashSet();
        ObjectNode instanceResult = JsonUtils.newObjectNode();
        if (tenantType == null || tenantType.equalsIgnoreCase("server")) {
            serverInstances = this.pinotHelixResourceManager.getAllInstancesForServerTenant(tenantName);
        }
        if (tenantType == null || tenantType.equalsIgnoreCase("broker")) {
            brokerInstances = this.pinotHelixResourceManager.getAllInstancesForBrokerTenant(tenantName);
        }
        HashSet allInstances = new HashSet(serverInstances);
        allInstances.addAll(brokerInstances);
        if (StateType.DROP.name().equalsIgnoreCase(stateStr)) {
            if (!allInstances.isEmpty()) {
                throw new ControllerApplicationException(LOGGER, "Error: Tenant " + tenantName + " has live instances, cannot be dropped.", Response.Status.BAD_REQUEST);
            }
            this.pinotHelixResourceManager.deleteBrokerTenantFor(tenantName);
            this.pinotHelixResourceManager.deleteOfflineServerTenantFor(tenantName);
            this.pinotHelixResourceManager.deleteRealtimeServerTenantFor(tenantName);
            return new SuccessResponse("Dropped tenant " + tenantName + " successfully.").toString();
        }
        boolean enable = StateType.ENABLE.name().equalsIgnoreCase(stateStr);
        for (String instance : allInstances) {
            if (enable) {
                instanceResult.put(instance, JsonUtils.objectToJsonNode((Object)this.pinotHelixResourceManager.enableInstance(instance)));
                continue;
            }
            instanceResult.put(instance, JsonUtils.objectToJsonNode((Object)this.pinotHelixResourceManager.disableInstance(instance)));
        }
        return null;
    }

    private String listInstancesForTenant(String tenantName, String tenantType) {
        ObjectNode resourceGetRet = JsonUtils.newObjectNode();
        List<InstanceConfig> instanceConfigList = this.pinotHelixResourceManager.getAllHelixInstanceConfigs();
        if (tenantType == null) {
            Set<String> allServerInstances = this.pinotHelixResourceManager.getAllInstancesForServerTenant(instanceConfigList, tenantName);
            Set<String> allBrokerInstances = this.pinotHelixResourceManager.getAllInstancesForBrokerTenant(instanceConfigList, tenantName);
            if (allServerInstances.isEmpty() && allBrokerInstances.isEmpty()) {
                throw new ControllerApplicationException(LOGGER, "Failed to find any instances for broker and server tenants: " + tenantName, Response.Status.NOT_FOUND);
            }
            resourceGetRet.set("ServerInstances", JsonUtils.objectToJsonNode(allServerInstances));
            resourceGetRet.set("BrokerInstances", JsonUtils.objectToJsonNode(allBrokerInstances));
        } else {
            if (tenantType.equalsIgnoreCase("server")) {
                Set<String> allServerInstances = this.pinotHelixResourceManager.getAllInstancesForServerTenant(instanceConfigList, tenantName);
                if (allServerInstances.isEmpty()) {
                    throw new ControllerApplicationException(LOGGER, "Failed to find any instances for server tenant: " + tenantName, Response.Status.NOT_FOUND);
                }
                resourceGetRet.set("ServerInstances", JsonUtils.objectToJsonNode(allServerInstances));
            }
            if (tenantType.equalsIgnoreCase("broker")) {
                Set<String> allBrokerInstances = this.pinotHelixResourceManager.getAllInstancesForBrokerTenant(instanceConfigList, tenantName);
                if (allBrokerInstances.isEmpty()) {
                    throw new ControllerApplicationException(LOGGER, "Failed to find any instances for broker tenant: " + tenantName, Response.Status.NOT_FOUND);
                }
                resourceGetRet.set("BrokerInstances", JsonUtils.objectToJsonNode(allBrokerInstances));
            }
        }
        resourceGetRet.put(TENANT_NAME, tenantName);
        return resourceGetRet.toString();
    }

    @GET
    @Path(value="/tenants/{tenantName}/metadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get tenant information")
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=TenantMetadata.class), @ApiResponse(code=404, message="Tenant not found"), @ApiResponse(code=500, message="Server error reading tenant information")})
    public TenantMetadata getTenantMetadata(@ApiParam(value="Tenant name", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="tenant type", required=false, defaultValue="", allowableValues="SERVER, BROKER") @QueryParam(value="type") @DefaultValue(value="") String type) {
        TenantMetadata tenantMeta = new TenantMetadata();
        if (type == null || type.isEmpty()) {
            tenantMeta.serverInstances = this.pinotHelixResourceManager.getAllInstancesForServerTenant(tenantName);
            tenantMeta.brokerInstances = this.pinotHelixResourceManager.getAllInstancesForBrokerTenant(tenantName);
        } else {
            if (type.equalsIgnoreCase("server")) {
                tenantMeta.serverInstances = this.pinotHelixResourceManager.getAllInstancesForServerTenant(tenantName);
            }
            if (type.equalsIgnoreCase("broker")) {
                tenantMeta.brokerInstances = this.pinotHelixResourceManager.getAllInstancesForBrokerTenant(tenantName);
            }
        }
        tenantMeta.tenantName = tenantName;
        return tenantMeta;
    }

    @POST
    @Path(value="/tenants/{tenantName}/metadata")
    @Produces(value={"application/json"})
    @ApiOperation(value="Change tenant state")
    @ApiResponses(value={@ApiResponse(code=200, message="Success", response=String.class), @ApiResponse(code=404, message="Tenant not found"), @ApiResponse(code=500, message="Server error reading tenant information")})
    public String changeTenantState(@ApiParam(value="Tenant name", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="tenant type", required=false, defaultValue="", allowableValues="SERVER, BROKER") @QueryParam(value="type") String type, @ApiParam(value="state", required=true, defaultValue="", allowableValues="enable, disable, drop") @QueryParam(value="state") @DefaultValue(value="") String state) {
        TenantMetadata tenantMetadata = this.getTenantMetadata(tenantName, type);
        HashSet<String> allInstances = new HashSet<String>();
        if (tenantMetadata.brokerInstances != null) {
            allInstances.addAll(tenantMetadata.brokerInstances);
        }
        if (tenantMetadata.serverInstances != null) {
            allInstances.addAll(tenantMetadata.serverInstances);
        }
        if (StateType.DROP.name().equalsIgnoreCase(state)) {
            if (!allInstances.isEmpty()) {
                throw new ControllerApplicationException(LOGGER, "Tenant " + tenantName + " has live instance", Response.Status.BAD_REQUEST);
            }
            this.pinotHelixResourceManager.deleteBrokerTenantFor(tenantName);
            this.pinotHelixResourceManager.deleteOfflineServerTenantFor(tenantName);
            this.pinotHelixResourceManager.deleteRealtimeServerTenantFor(tenantName);
            try {
                return JsonUtils.objectToString((Object)new SuccessResponse("Deleted tenant " + tenantName));
            }
            catch (JsonProcessingException e) {
                LOGGER.error("Error serializing response to json");
                return "{\"message\" : \"Deleted tenant\" " + tenantName + "}";
            }
        }
        boolean enable = StateType.ENABLE.name().equalsIgnoreCase(state);
        ObjectNode instanceResult = JsonUtils.newObjectNode();
        String instance = null;
        try {
            Iterator iterator = allInstances.iterator();
            while (iterator.hasNext()) {
                String i;
                instance = i = (String)iterator.next();
                if (enable) {
                    instanceResult.set(instance, JsonUtils.objectToJsonNode((Object)this.pinotHelixResourceManager.enableInstance(instance)));
                    continue;
                }
                instanceResult.set(instance, JsonUtils.objectToJsonNode((Object)this.pinotHelixResourceManager.disableInstance(instance)));
            }
        }
        catch (Exception e) {
            this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_INSTANCE_POST_ERROR, 1L);
            throw new ControllerApplicationException(LOGGER, String.format("Error during %s operation for instance: %s", type, instance), Response.Status.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        return instanceResult.toString();
    }

    @DELETE
    @Path(value="/tenants/{tenantName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Delete a tenant")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Tenant can not be deleted"), @ApiResponse(code=404, message="Tenant not found"), @ApiResponse(code=500, message="Error deleting tenant")})
    public SuccessResponse deleteTenant(@ApiParam(value="Tenant name", required=true) @PathParam(value="tenantName") String tenantName, @ApiParam(value="Tenant type", required=true, allowableValues="SERVER, BROKER") @QueryParam(value="type") @DefaultValue(value="") String type) {
        if (type == null || type.isEmpty()) {
            throw new ControllerApplicationException(LOGGER, "Tenant type (BROKER | SERVER) is required as query parameter", Response.Status.INTERNAL_SERVER_ERROR);
        }
        TenantRole tenantRole = TenantRole.valueOf((String)type.toUpperCase());
        PinotResourceManagerResponse res = null;
        switch (tenantRole) {
            case BROKER: {
                if (this.pinotHelixResourceManager.isBrokerTenantDeletable(tenantName)) {
                    res = this.pinotHelixResourceManager.deleteBrokerTenantFor(tenantName);
                    break;
                }
                throw new ControllerApplicationException(LOGGER, "Broker tenant is not null, can not delete it", Response.Status.BAD_REQUEST);
            }
            case SERVER: {
                if (this.pinotHelixResourceManager.isServerTenantDeletable(tenantName)) {
                    res = this.pinotHelixResourceManager.deleteOfflineServerTenantFor(tenantName);
                    if (!res.isSuccessful()) break;
                    res = this.pinotHelixResourceManager.deleteRealtimeServerTenantFor(tenantName);
                    break;
                }
                throw new ControllerApplicationException(LOGGER, "Server tenant is not null, can not delete it", Response.Status.BAD_REQUEST);
            }
        }
        if (res.isSuccessful()) {
            return new SuccessResponse("Successfully deleted tenant " + tenantName);
        }
        this._controllerMetrics.addMeteredGlobalValue((AbstractMetrics.Meter)ControllerMeter.CONTROLLER_TABLE_TENANT_DELETE_ERROR, 1L);
        throw new ControllerApplicationException(LOGGER, "Error deleting tenant", Response.Status.INTERNAL_SERVER_ERROR);
    }

    public static class TenantsList {
        @JsonProperty(value="SERVER_TENANTS")
        Set<String> serverTenants;
        @JsonProperty(value="BROKER_TENANTS")
        Set<String> brokerTenants;
    }

    public static class TenantMetadata {
        @JsonProperty(value="ServerInstances")
        Set<String> serverInstances;
        @JsonProperty(value="BrokerInstances")
        Set<String> brokerInstances;
        @JsonProperty(value="tenantName")
        String tenantName;
    }
}

