/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.apache.helix.model.ExternalView;
import org.apache.helix.model.IdealState;
import org.apache.pinot.common.config.TableNameBuilder;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Table"})
@Path(value="/")
public class TableViews {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableViews.class);
    public static final String IDEALSTATE = "idealstate";
    public static final String EXTERNALVIEW = "externalview";
    @Inject
    PinotHelixResourceManager _pinotHelixResourceManager;

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/idealstate")
    @ApiOperation(value="Get table ideal state", notes="Get table ideal state")
    public TableView getIdealState(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline", required=false) @QueryParam(value="tableType") String tableTypeStr) {
        CommonConstants.Helix.TableType tableType = this.validateTableType(tableTypeStr);
        return this.getTableState(tableName, IDEALSTATE, tableType);
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/tables/{tableName}/externalview")
    @ApiOperation(value="Get table external view", notes="Get table external view")
    public TableView getExternalView(@ApiParam(value="Name of the table", required=true) @PathParam(value="tableName") String tableName, @ApiParam(value="realtime|offline", required=false) @QueryParam(value="tableType") String tableTypeStr) {
        CommonConstants.Helix.TableType tableType = this.validateTableType(tableTypeStr);
        return this.getTableState(tableName, EXTERNALVIEW, tableType);
    }

    private TableView getTableState(String tableName, String view, CommonConstants.Helix.TableType tableType) {
        TableView tableView;
        if (view.equalsIgnoreCase(IDEALSTATE)) {
            tableView = this.getTableIdealState(tableName, tableType);
        } else if (view.equalsIgnoreCase(EXTERNALVIEW)) {
            tableView = this.getTableExternalView(tableName, tableType);
        } else {
            throw new ControllerApplicationException(LOGGER, "Bad view name: " + view + ". Expected idealstate or externalview", Response.Status.BAD_REQUEST);
        }
        if (tableView.offline == null && tableView.realtime == null) {
            throw new ControllerApplicationException(LOGGER, "Table not found", Response.Status.NOT_FOUND);
        }
        return tableView;
    }

    private TableView getTableIdealState(String tableNameOptType, CommonConstants.Helix.TableType tableType) {
        TableView tableView = new TableView();
        if (tableType == null || tableType == CommonConstants.Helix.TableType.OFFLINE) {
            tableView.offline = this.getIdealState(tableNameOptType, CommonConstants.Helix.TableType.OFFLINE);
        }
        if (tableType == null || tableType == CommonConstants.Helix.TableType.REALTIME) {
            tableView.realtime = this.getIdealState(tableNameOptType, CommonConstants.Helix.TableType.REALTIME);
        }
        return tableView;
    }

    private TableView getTableExternalView(@Nonnull String tableNameOptType, @Nullable CommonConstants.Helix.TableType tableType) {
        TableView tableView = new TableView();
        if (tableType == null || tableType == CommonConstants.Helix.TableType.OFFLINE) {
            tableView.offline = this.getExternalView(tableNameOptType, CommonConstants.Helix.TableType.OFFLINE);
        }
        if (tableType == null || tableType == CommonConstants.Helix.TableType.REALTIME) {
            tableView.realtime = this.getExternalView(tableNameOptType, CommonConstants.Helix.TableType.REALTIME);
        }
        return tableView;
    }

    private CommonConstants.Helix.TableType validateTableType(String tableTypeStr) {
        if (tableTypeStr == null) {
            return null;
        }
        try {
            return CommonConstants.Helix.TableType.valueOf((String)tableTypeStr.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            String errStr = "Illegal table type '" + tableTypeStr + "'";
            throw new ControllerApplicationException(LOGGER, errStr, Response.Status.BAD_REQUEST, (Throwable)e);
        }
    }

    @Nullable
    public Map<String, Map<String, String>> getIdealState(@Nonnull String tableNameOptType, @Nullable CommonConstants.Helix.TableType tableType) {
        String tableNameWithType = this.getTableNameWithType(tableNameOptType, tableType);
        IdealState resourceIdealState = this._pinotHelixResourceManager.getHelixAdmin().getResourceIdealState(this._pinotHelixResourceManager.getHelixClusterName(), tableNameWithType);
        return resourceIdealState == null ? null : resourceIdealState.getRecord().getMapFields();
    }

    @Nullable
    public Map<String, Map<String, String>> getExternalView(@Nonnull String tableNameOptType, CommonConstants.Helix.TableType tableType) {
        String tableNameWithType = this.getTableNameWithType(tableNameOptType, tableType);
        ExternalView resourceEV = this._pinotHelixResourceManager.getHelixAdmin().getResourceExternalView(this._pinotHelixResourceManager.getHelixClusterName(), tableNameWithType);
        return resourceEV == null ? null : resourceEV.getRecord().getMapFields();
    }

    private String getTableNameWithType(@Nonnull String tableNameOptType, @Nullable CommonConstants.Helix.TableType tableType) {
        if (tableType != null) {
            if (tableType == CommonConstants.Helix.TableType.OFFLINE) {
                return TableNameBuilder.OFFLINE.tableNameWithType(tableNameOptType);
            }
            return TableNameBuilder.REALTIME.tableNameWithType(tableNameOptType);
        }
        return tableNameOptType;
    }

    public static class TableView {
        @JsonProperty(value="OFFLINE")
        public Map<String, Map<String, String>> offline;
        @JsonProperty(value="REALTIME")
        public Map<String, Map<String, String>> realtime;
    }
}

