/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix;

import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.common.assignment.InstancePartitionsType;
import org.apache.pinot.common.utils.StringUtil;
import org.apache.pinot.common.utils.URIUtils;

public class ControllerRequestURLBuilder {
    private final String _baseUrl;

    private ControllerRequestURLBuilder(String baseUrl) {
        this._baseUrl = StringUtils.chomp((String)baseUrl, (String)"/");
    }

    public static ControllerRequestURLBuilder baseUrl(String baseUrl) {
        return new ControllerRequestURLBuilder(baseUrl);
    }

    public String forDataFileUpload() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "segments"});
    }

    public String forInstanceCreate() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "instances"});
    }

    public String forInstanceDelete(String instanceName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "instances", instanceName});
    }

    public String forInstanceState(String instanceName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "instances", instanceName, "state"});
    }

    public String forInstanceInformation(String instanceName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "instances", instanceName});
    }

    public String forInstanceList() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "instances"});
    }

    public String forTablesFromTenant(String tenantName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants", tenantName, "tables"});
    }

    public String forTenantCreate() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants"});
    }

    public String forTenantGet() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants"});
    }

    public String forTenantGet(String tenantName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants", tenantName});
    }

    public String forBrokerTenantGet(String tenantName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants", tenantName, "?type=broker"});
    }

    public String forServerTenantGet(String tenantName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants", tenantName, "?type=server"});
    }

    public String forBrokerTenantDelete(String tenantName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants", tenantName, "?type=broker"});
    }

    public String forServerTenantDelete(String tenantName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tenants", tenantName, "?type=server"});
    }

    public String forTableCreate() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables"});
    }

    public String forUpdateTableConfig(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName});
    }

    public String forTableRebalance(String tableName, String tableType) {
        return this.forTableRebalance(tableName, tableType, false, false, false, false, 1);
    }

    public String forTableRebalance(String tableName, String tableType, boolean dryRun, boolean reassignInstances, boolean includeConsuming, boolean downtime, int minAvailableReplicas) {
        StringBuilder stringBuilder = new StringBuilder(StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "rebalance?type=" + tableType}));
        if (dryRun) {
            stringBuilder.append("&dryRun=").append(dryRun);
        }
        if (reassignInstances) {
            stringBuilder.append("&reassignInstances=").append(reassignInstances);
        }
        if (includeConsuming) {
            stringBuilder.append("&includeConsuming=").append(includeConsuming);
        }
        if (downtime) {
            stringBuilder.append("&downtime=").append(downtime);
        }
        if (minAvailableReplicas != 1) {
            stringBuilder.append("&minAvailableReplicas=").append(minAvailableReplicas);
        }
        return stringBuilder.toString();
    }

    public String forTableReload(String tableName, String tableType) {
        String query = "reload?type=" + tableType;
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "segments", query});
    }

    public String forTableUpdateIndexingConfigs(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "indexingConfigs"});
    }

    public String forTableGetServerInstances(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "instances?type=server"});
    }

    public String forTableGetBrokerInstances(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "instances?type=broker"});
    }

    public String forTableGet(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName});
    }

    public String forTableDelete(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName});
    }

    public String forTableView(String tableName, String view, @Nullable String tableType) {
        String url = StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, view});
        if (tableType != null) {
            url = url + "?tableType=" + tableType;
        }
        return url;
    }

    public String forSchemaCreate() {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "schemas"});
    }

    public String forSchemaUpdate(String schemaName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "schemas", schemaName});
    }

    public String forSchemaGet(String schemaName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "schemas", schemaName});
    }

    public String forSegmentDownload(String tableName, String segmentName) {
        return URIUtils.constructDownloadUrl((String)this._baseUrl, (String)tableName, (String)segmentName);
    }

    public String forSegmentDelete(String resourceName, String segmentName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "datafiles", resourceName, segmentName});
    }

    public String forSegmentDeleteAPI(String tableName, String segmentName, String tableType) {
        return URIUtils.getPath((String)this._baseUrl, (String[])new String[]{"segments", tableName, URIUtils.encode((String)segmentName)}) + "?type=" + tableType;
    }

    public String forSegmentDeleteAllAPI(String tableName, String tableType) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "segments", tableName + "?type=" + tableType});
    }

    public String forListAllSegments(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "segments"});
    }

    public String forListAllCrcInformationForTable(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "segments", "crc"});
    }

    public String forDeleteTableWithType(String tableName, String tableType) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName + "?type=" + tableType});
    }

    public String forSegmentListAPIWithTableType(String tableName, String tableType) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "segments", tableName + "?type=" + tableType});
    }

    public String forSegmentListAPI(String tableName) {
        return StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "segments", tableName});
    }

    public String forInstancePartitions(String tableName, @Nullable InstancePartitionsType instancePartitionsType) {
        String url = StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "instancePartitions"});
        if (instancePartitionsType != null) {
            url = url + "?type=" + instancePartitionsType;
        }
        return url;
    }

    public String forInstanceAssign(String tableName, @Nullable InstancePartitionsType instancePartitionsType, boolean dryRun) {
        String url = StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "assignInstances"});
        if (instancePartitionsType != null) {
            url = url + "?type=" + instancePartitionsType;
            if (dryRun) {
                url = url + "&dryRun=true";
            }
        } else if (dryRun) {
            url = url + "?dryRun=true";
        }
        return url;
    }

    public String forInstanceReplace(String tableName, @Nullable InstancePartitionsType instancePartitionsType, String oldInstanceId, String newInstanceId) {
        String url = StringUtil.join((String)"/", (String[])new String[]{this._baseUrl, "tables", tableName, "replaceInstance"}) + "?oldInstanceId=" + oldInstanceId + "&newInstanceId=" + newInstanceId;
        if (instancePartitionsType != null) {
            url = url + "&type=" + instancePartitionsType;
        }
        return url;
    }
}

