/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.assignment.instance;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.assignment.InstancePartitions;
import org.apache.pinot.common.assignment.InstancePartitionsType;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.config.TableNameBuilder;
import org.apache.pinot.common.config.instance.InstanceAssignmentConfig;
import org.apache.pinot.common.config.instance.InstanceAssignmentConfigUtils;
import org.apache.pinot.common.config.instance.InstanceConstraintConfig;
import org.apache.pinot.controller.helix.core.assignment.instance.HashBasedRotateInstanceConstraintApplier;
import org.apache.pinot.controller.helix.core.assignment.instance.InstanceConstraintApplier;
import org.apache.pinot.controller.helix.core.assignment.instance.InstanceReplicaGroupPartitionSelector;
import org.apache.pinot.controller.helix.core.assignment.instance.InstanceTagPoolSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceAssignmentDriver {
    private static final Logger LOGGER = LoggerFactory.getLogger(InstanceAssignmentDriver.class);
    private final TableConfig _tableConfig;

    public InstanceAssignmentDriver(TableConfig tableConfig) {
        this._tableConfig = tableConfig;
    }

    public InstancePartitions assignInstances(InstancePartitionsType instancePartitionsType, List<InstanceConfig> instanceConfigs) {
        String tableNameWithType = this._tableConfig.getTableName();
        LOGGER.info("Starting {} instance assignment for table: {}", (Object)instancePartitionsType, (Object)tableNameWithType);
        InstanceAssignmentConfig assignmentConfig = InstanceAssignmentConfigUtils.getInstanceAssignmentConfig((TableConfig)this._tableConfig, (InstancePartitionsType)instancePartitionsType);
        InstanceTagPoolSelector tagPoolSelector = new InstanceTagPoolSelector(assignmentConfig.getTagPoolConfig(), tableNameWithType);
        Map<Integer, List<InstanceConfig>> poolToInstanceConfigsMap = tagPoolSelector.selectInstances(instanceConfigs);
        InstanceConstraintConfig constraintConfig = assignmentConfig.getConstraintConfig();
        ArrayList<HashBasedRotateInstanceConstraintApplier> constraintAppliers = new ArrayList<HashBasedRotateInstanceConstraintApplier>();
        if (constraintConfig == null) {
            LOGGER.info("No instance constraint is configured, using default hash-based-rotate instance constraint");
            constraintAppliers.add(new HashBasedRotateInstanceConstraintApplier(tableNameWithType));
        }
        for (InstanceConstraintApplier instanceConstraintApplier : constraintAppliers) {
            poolToInstanceConfigsMap = instanceConstraintApplier.applyConstraint(poolToInstanceConfigsMap);
        }
        InstanceReplicaGroupPartitionSelector replicaPartitionSelector = new InstanceReplicaGroupPartitionSelector(assignmentConfig.getReplicaGroupPartitionConfig(), tableNameWithType);
        InstancePartitions instancePartitions = new InstancePartitions(instancePartitionsType.getInstancePartitionsName(TableNameBuilder.extractRawTableName((String)tableNameWithType)));
        replicaPartitionSelector.selectInstances(poolToInstanceConfigsMap, instancePartitions);
        return instancePartitions;
    }
}

