/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.helix.task.JobConfig;
import org.apache.helix.task.JobQueue;
import org.apache.helix.task.TaskConfig;
import org.apache.helix.task.TaskDriver;
import org.apache.helix.task.TaskState;
import org.apache.helix.task.WorkflowConfig;
import org.apache.pinot.common.config.PinotTaskConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PinotHelixTaskResourceManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotHelixTaskResourceManager.class);
    public static final String TASK_NAME_SEPARATOR = "_";
    private static final String TASK_QUEUE_PREFIX = "TaskQueue_";
    private static final String TASK_PREFIX = "Task_";
    private final TaskDriver _taskDriver;

    public PinotHelixTaskResourceManager(TaskDriver taskDriver) {
        this._taskDriver = taskDriver;
    }

    public synchronized Set<String> getTaskTypes() {
        Set helixJobQueues = this._taskDriver.getWorkflows().keySet();
        HashSet<String> taskTypes = new HashSet<String>(helixJobQueues.size());
        for (String helixJobQueue : helixJobQueues) {
            taskTypes.add(PinotHelixTaskResourceManager.getTaskType(helixJobQueue));
        }
        return taskTypes;
    }

    public void ensureTaskQueueExists(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        WorkflowConfig workflowConfig = this._taskDriver.getWorkflowConfig(helixJobQueueName);
        if (workflowConfig == null) {
            LOGGER.info("Creating task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
            JobQueue jobQueue = new JobQueue.Builder(helixJobQueueName).setWorkflowConfig(new WorkflowConfig.Builder().setParallelJobs(Integer.MAX_VALUE).build()).build();
            this._taskDriver.createQueue(jobQueue);
        }
        while (this._taskDriver.getWorkflowContext(helixJobQueueName) == null) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    public synchronized void cleanUpTaskQueue(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        LOGGER.info("Cleaning up task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        this._taskDriver.cleanupQueue(helixJobQueueName);
    }

    public synchronized void stopTaskQueue(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        LOGGER.info("Stopping task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        this._taskDriver.stop(helixJobQueueName);
    }

    public synchronized void resumeTaskQueue(String taskType) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        LOGGER.info("Resuming task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        this._taskDriver.resume(helixJobQueueName);
    }

    public synchronized void deleteTaskQueue(String taskType, boolean forceDelete) {
        String helixJobQueueName = PinotHelixTaskResourceManager.getHelixJobQueueName(taskType);
        if (forceDelete) {
            LOGGER.warn("Force deleting task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        } else {
            LOGGER.info("Deleting task queue: {} for task type: {}", (Object)helixJobQueueName, (Object)taskType);
        }
        this._taskDriver.delete(helixJobQueueName, forceDelete);
    }

    public synchronized Set<String> getTaskQueues() {
        return this._taskDriver.getWorkflows().keySet();
    }

    public synchronized TaskState getTaskQueueState(String taskType) {
        return this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType)).getWorkflowState();
    }

    public synchronized String submitTask(List<PinotTaskConfig> pinotTaskConfigs, int numConcurrentTasksPerInstance) {
        return this.submitTask(pinotTaskConfigs, "minion_untagged", numConcurrentTasksPerInstance);
    }

    public synchronized String submitTask(List<PinotTaskConfig> pinotTaskConfigs, String minionInstanceTag, int numConcurrentTasksPerInstance) {
        int numChildTasks = pinotTaskConfigs.size();
        Preconditions.checkState((numChildTasks > 0 ? 1 : 0) != 0);
        Preconditions.checkState((numConcurrentTasksPerInstance > 0 ? 1 : 0) != 0);
        String taskType = pinotTaskConfigs.get(0).getTaskType();
        String parentTaskName = TASK_PREFIX + taskType + TASK_NAME_SEPARATOR + System.currentTimeMillis();
        LOGGER.info("Submitting parent task: {} of type: {} with {} child task configs: {} to Minion instances with tag: {}", new Object[]{parentTaskName, taskType, numChildTasks, pinotTaskConfigs, minionInstanceTag});
        ArrayList<TaskConfig> helixTaskConfigs = new ArrayList<TaskConfig>(numChildTasks);
        for (int i = 0; i < numChildTasks; ++i) {
            PinotTaskConfig pinotTaskConfig = pinotTaskConfigs.get(i);
            Preconditions.checkState((boolean)pinotTaskConfig.getTaskType().equals(taskType));
            helixTaskConfigs.add(pinotTaskConfig.toHelixTaskConfig(parentTaskName + TASK_NAME_SEPARATOR + i));
        }
        JobConfig.Builder jobBuilder = new JobConfig.Builder().addTaskConfigs(helixTaskConfigs).setInstanceGroupTag(minionInstanceTag).setNumConcurrentTasksPerInstance(numConcurrentTasksPerInstance).setIgnoreDependentJobFailure(true).setMaxAttemptsPerTask(1).setFailureThreshold(Integer.MAX_VALUE);
        this._taskDriver.enqueueJob(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType), parentTaskName, jobBuilder);
        while (this.getTaskState(parentTaskName) == null) {
            Uninterruptibles.sleepUninterruptibly((long)100L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
        return parentTaskName;
    }

    public synchronized Set<String> getTasks(String taskType) {
        Set helixJobs = this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType)).getJobStates().keySet();
        HashSet<String> tasks = new HashSet<String>(helixJobs.size());
        for (String helixJobName : helixJobs) {
            tasks.add(PinotHelixTaskResourceManager.getPinotTaskName(helixJobName));
        }
        return tasks;
    }

    public synchronized Map<String, TaskState> getTaskStates(String taskType) {
        Map helixJobStates = this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType)).getJobStates();
        HashMap<String, TaskState> taskStates = new HashMap<String, TaskState>(helixJobStates.size());
        for (Map.Entry entry : helixJobStates.entrySet()) {
            taskStates.put(PinotHelixTaskResourceManager.getPinotTaskName((String)entry.getKey()), (TaskState)entry.getValue());
        }
        return taskStates;
    }

    public synchronized TaskState getTaskState(String taskName) {
        String taskType = PinotHelixTaskResourceManager.getTaskType(taskName);
        return this._taskDriver.getWorkflowContext(PinotHelixTaskResourceManager.getHelixJobQueueName(taskType)).getJobState(PinotHelixTaskResourceManager.getHelixJobName(taskName));
    }

    public synchronized List<PinotTaskConfig> getTaskConfigs(String taskName) {
        Collection helixTaskConfigs = this._taskDriver.getJobConfig(PinotHelixTaskResourceManager.getHelixJobName(taskName)).getTaskConfigMap().values();
        ArrayList<PinotTaskConfig> taskConfigs = new ArrayList<PinotTaskConfig>(helixTaskConfigs.size());
        for (TaskConfig helixTaskConfig : helixTaskConfigs) {
            taskConfigs.add(PinotTaskConfig.fromHelixTaskConfig((TaskConfig)helixTaskConfig));
        }
        return taskConfigs;
    }

    public static String getHelixJobQueueName(String taskType) {
        return TASK_QUEUE_PREFIX + taskType;
    }

    private static String getHelixJobName(String pinotTaskName) {
        return PinotHelixTaskResourceManager.getHelixJobQueueName(PinotHelixTaskResourceManager.getTaskType(pinotTaskName)) + TASK_NAME_SEPARATOR + pinotTaskName;
    }

    private static String getPinotTaskName(String helixJobName) {
        return helixJobName.substring(TASK_QUEUE_PREFIX.length() + PinotHelixTaskResourceManager.getTaskType(helixJobName).length() + 1);
    }

    private static String getTaskType(String name) {
        return name.split(TASK_NAME_SEPARATOR)[1];
    }
}

