/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion.generator;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.pinot.common.config.PinotTaskConfig;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.config.TableTaskConfig;
import org.apache.pinot.common.data.Segment;
import org.apache.pinot.common.metadata.segment.OfflineSegmentZKMetadata;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoProvider;
import org.apache.pinot.controller.helix.core.minion.generator.PinotTaskGenerator;
import org.apache.pinot.controller.helix.core.minion.generator.TaskGeneratorUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConvertToRawIndexTaskGenerator
implements PinotTaskGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConvertToRawIndexTaskGenerator.class);
    private final ClusterInfoProvider _clusterInfoProvider;

    public ConvertToRawIndexTaskGenerator(ClusterInfoProvider clusterInfoProvider) {
        this._clusterInfoProvider = clusterInfoProvider;
    }

    @Override
    @Nonnull
    public String getTaskType() {
        return "ConvertToRawIndexTask";
    }

    @Override
    @Nonnull
    public List<PinotTaskConfig> generateTasks(@Nonnull List<TableConfig> tableConfigs) {
        ArrayList<PinotTaskConfig> pinotTaskConfigs = new ArrayList<PinotTaskConfig>();
        Set<Segment> runningSegments = TaskGeneratorUtils.getRunningSegments("ConvertToRawIndexTask", this._clusterInfoProvider);
        block2: for (TableConfig tableConfig : tableConfigs) {
            int tableMaxNumTasks;
            String offlineTableName = tableConfig.getTableName();
            if (tableConfig.getTableType() != CommonConstants.Helix.TableType.OFFLINE) {
                LOGGER.warn("Skip generating ConvertToRawIndexTask for non-OFFLINE table: {}", (Object)offlineTableName);
                continue;
            }
            TableTaskConfig tableTaskConfig = tableConfig.getTaskConfig();
            Preconditions.checkNotNull((Object)tableTaskConfig);
            Map taskConfigs = tableTaskConfig.getConfigsForTaskType("ConvertToRawIndexTask");
            Preconditions.checkNotNull((Object)taskConfigs, (String)"Task config shouldn't be null for Table: {}", (Object)offlineTableName);
            String tableMaxNumTasksConfig = (String)taskConfigs.get("tableMaxNumTasks");
            if (tableMaxNumTasksConfig != null) {
                try {
                    tableMaxNumTasks = Integer.valueOf(tableMaxNumTasksConfig);
                }
                catch (Exception e) {
                    tableMaxNumTasks = Integer.MAX_VALUE;
                }
            } else {
                tableMaxNumTasks = Integer.MAX_VALUE;
            }
            String columnsToConvertConfig = (String)taskConfigs.get("columnsToConvert");
            int tableNumTasks = 0;
            for (OfflineSegmentZKMetadata offlineSegmentZKMetadata : this._clusterInfoProvider.getOfflineSegmentsMetadata(offlineTableName)) {
                Map customMap;
                if (tableNumTasks == tableMaxNumTasks) continue block2;
                String segmentName = offlineSegmentZKMetadata.getSegmentName();
                if (runningSegments.contains(new Segment(offlineTableName, segmentName)) || (customMap = offlineSegmentZKMetadata.getCustomMap()) != null && customMap.containsKey("columnsToConvert.time")) continue;
                HashMap<String, String> configs = new HashMap<String, String>();
                configs.put("tableName", offlineTableName);
                configs.put("segmentName", segmentName);
                configs.put("downloadURL", offlineSegmentZKMetadata.getDownloadUrl());
                configs.put("uploadURL", this._clusterInfoProvider.getVipUrl() + "/segments");
                configs.put("crc", String.valueOf(offlineSegmentZKMetadata.getCrc()));
                if (columnsToConvertConfig != null) {
                    configs.put("columnsToConvert", columnsToConvertConfig);
                }
                pinotTaskConfigs.add(new PinotTaskConfig("ConvertToRawIndexTask", configs));
                ++tableNumTasks;
            }
        }
        return pinotTaskConfigs;
    }

    @Override
    public int getNumConcurrentTasksPerInstance() {
        return 1;
    }

    @Override
    public void nonLeaderCleanUp() {
    }
}

