/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.minion.generator;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.helix.task.TaskState;
import org.apache.pinot.common.config.PinotTaskConfig;
import org.apache.pinot.common.data.Segment;
import org.apache.pinot.controller.helix.core.minion.ClusterInfoProvider;

public class TaskGeneratorUtils {
    private static final long ONE_DAY_IN_MILLIS = 86400000L;

    public static Set<Segment> getRunningSegments(@Nonnull String taskType, @Nonnull ClusterInfoProvider clusterInfoProvider) {
        HashSet<Segment> runningSegments = new HashSet<Segment>();
        Map<String, TaskState> taskStates = clusterInfoProvider.getTaskStates(taskType);
        for (Map.Entry<String, TaskState> entry : taskStates.entrySet()) {
            if (entry.getValue() == TaskState.COMPLETED) continue;
            String taskName = entry.getKey();
            long scheduleTimeMs = Long.parseLong(taskName.substring(taskName.lastIndexOf("_") + 1));
            if (System.currentTimeMillis() - scheduleTimeMs > 86400000L) continue;
            for (PinotTaskConfig pinotTaskConfig : clusterInfoProvider.getTaskConfigs(entry.getKey())) {
                Map configs = pinotTaskConfig.getConfigs();
                runningSegments.add(new Segment((String)configs.get("tableName"), (String)configs.get("segmentName")));
            }
        }
        return runningSegments;
    }
}

