/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.realtime;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.helix.ZNRecord;
import org.apache.helix.store.zk.ZkHelixPropertyStore;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.metadata.ZKMetadataProvider;

public class TableConfigCache {
    private static final long DEFAULT_CACHE_SIZE = 50L;
    private static final long DEFAULT_CACHE_TIMEOUT_IN_MINUTE = 60L;
    private final LoadingCache<String, TableConfig> _tableConfigCache;

    public TableConfigCache(final ZkHelixPropertyStore<ZNRecord> propertyStore) {
        this._tableConfigCache = CacheBuilder.newBuilder().maximumSize(50L).expireAfterWrite(60L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, TableConfig>(){

            public TableConfig load(@Nonnull String tableNameWithType) {
                TableConfig tableConfig = ZKMetadataProvider.getTableConfig((ZkHelixPropertyStore)propertyStore, (String)tableNameWithType);
                Preconditions.checkState((tableConfig != null ? 1 : 0) != 0, (String)"Failed to find table config for table: %s", (Object)tableNameWithType);
                return tableConfig;
            }
        });
    }

    public TableConfig getTableConfig(String tableNameWithType) throws ExecutionException {
        return (TableConfig)this._tableConfigCache.get((Object)tableNameWithType);
    }
}

