/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.helix.core.realtime.segment;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import org.apache.pinot.common.metadata.segment.LLCRealtimeSegmentZKMetadata;
import org.apache.pinot.controller.helix.core.realtime.segment.CommittingSegmentDescriptor;
import org.apache.pinot.controller.helix.core.realtime.segment.FlushThresholdUpdater;
import org.apache.pinot.spi.stream.PartitionLevelStreamConfig;

public class DefaultFlushThresholdUpdater
implements FlushThresholdUpdater {
    private final int _tableFlushSize;

    DefaultFlushThresholdUpdater(int tableFlushSize) {
        this._tableFlushSize = tableFlushSize;
    }

    @Override
    public void updateFlushThreshold(PartitionLevelStreamConfig streamConfig, LLCRealtimeSegmentZKMetadata newSegmentZKMetadata, CommittingSegmentDescriptor committingSegmentDescriptor, @Nullable LLCRealtimeSegmentZKMetadata committingSegmentZKMetadata, int maxNumPartitionsPerInstance) {
        newSegmentZKMetadata.setSizeThresholdToFlushSegment(this._tableFlushSize / maxNumPartitionsPerInstance);
    }

    @VisibleForTesting
    int getTableFlushSize() {
        return this._tableFlushSize;
    }
}

