/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.util;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.pinot.common.config.TableNameBuilder;
import org.apache.pinot.common.exception.InvalidConfigException;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.ControllerGauge;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.common.restlet.resources.SegmentSizeInfo;
import org.apache.pinot.common.utils.CommonConstants;
import org.apache.pinot.controller.api.resources.ServerTableSizeReader;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableSizeReader {
    private static final Logger LOGGER = LoggerFactory.getLogger(TableSizeReader.class);
    private final Executor _executor;
    private final HttpConnectionManager _connectionManager;
    private final PinotHelixResourceManager _helixResourceManager;
    private final ControllerMetrics _controllerMetrics;

    public TableSizeReader(Executor executor, HttpConnectionManager connectionManager, ControllerMetrics controllerMetrics, PinotHelixResourceManager helixResourceManager) {
        this._executor = executor;
        this._connectionManager = connectionManager;
        this._controllerMetrics = controllerMetrics;
        this._helixResourceManager = helixResourceManager;
    }

    @Nullable
    public TableSizeDetails getTableSizeDetails(@Nonnull String tableName, @Nonnegative int timeoutMsec) throws InvalidConfigException {
        Preconditions.checkNotNull((Object)tableName, (Object)"Table name should not be null");
        Preconditions.checkArgument((timeoutMsec > 0 ? 1 : 0) != 0, (Object)"Timeout value must be greater than 0");
        boolean hasRealtimeTable = false;
        boolean hasOfflineTable = false;
        CommonConstants.Helix.TableType tableType = TableNameBuilder.getTableTypeFromTableName((String)tableName);
        if (tableType != null) {
            hasRealtimeTable = tableType == CommonConstants.Helix.TableType.REALTIME;
            hasOfflineTable = tableType == CommonConstants.Helix.TableType.OFFLINE;
        } else {
            hasRealtimeTable = this._helixResourceManager.hasRealtimeTable(tableName);
            hasOfflineTable = this._helixResourceManager.hasOfflineTable(tableName);
        }
        if (!hasOfflineTable && !hasRealtimeTable) {
            return null;
        }
        TableSizeDetails tableSizeDetails = new TableSizeDetails(tableName);
        if (hasRealtimeTable) {
            String realtimeTableName = TableNameBuilder.REALTIME.tableNameWithType(tableName);
            tableSizeDetails.realtimeSegments = this.getTableSubtypeSize(realtimeTableName, timeoutMsec);
            tableSizeDetails.reportedSizeInBytes += tableSizeDetails.realtimeSegments.reportedSizeInBytes;
            tableSizeDetails.estimatedSizeInBytes += tableSizeDetails.realtimeSegments.estimatedSizeInBytes;
        }
        if (hasOfflineTable) {
            String offlineTableName = TableNameBuilder.OFFLINE.tableNameWithType(tableName);
            tableSizeDetails.offlineSegments = this.getTableSubtypeSize(offlineTableName, timeoutMsec);
            tableSizeDetails.reportedSizeInBytes += tableSizeDetails.offlineSegments.reportedSizeInBytes;
            tableSizeDetails.estimatedSizeInBytes += tableSizeDetails.offlineSegments.estimatedSizeInBytes;
        }
        return tableSizeDetails;
    }

    public TableSubTypeSizeDetails getTableSubtypeSize(String tableNameWithType, int timeoutMs) throws InvalidConfigException {
        Map<String, List<String>> serverToSegmentsMap = this._helixResourceManager.getServerToSegmentsMap(tableNameWithType);
        ServerTableSizeReader serverTableSizeReader = new ServerTableSizeReader(this._executor, this._connectionManager);
        BiMap<String, String> endpoints = this._helixResourceManager.getDataInstanceAdminEndpoints(serverToSegmentsMap.keySet());
        Map<String, List<SegmentSizeInfo>> serverToSegmentSizeInfoListMap = serverTableSizeReader.getSegmentSizeInfoFromServers(endpoints, tableNameWithType, timeoutMs);
        TableSubTypeSizeDetails subTypeSizeDetails = new TableSubTypeSizeDetails();
        Map<String, SegmentSizeDetails> segmentToSizeDetailsMap = subTypeSizeDetails.segments;
        for (Map.Entry<String, List<String>> entry : serverToSegmentsMap.entrySet()) {
            SegmentSizeInfo segmentSizeInfo22;
            String string = entry.getKey();
            List<SegmentSizeInfo> segmentSizeInfoList = serverToSegmentSizeInfoListMap.get(string);
            if (segmentSizeInfoList != null) {
                for (SegmentSizeInfo segmentSizeInfo22 : segmentSizeInfoList) {
                    SegmentSizeDetails segmentSizeDetails = segmentToSizeDetailsMap.computeIfAbsent(segmentSizeInfo22.segmentName, k -> new SegmentSizeDetails());
                    segmentSizeDetails.serverInfo.put(string, segmentSizeInfo22);
                }
                continue;
            }
            List segments = (List)entry.getValue();
            segmentSizeInfo22 = segments.iterator();
            while (segmentSizeInfo22.hasNext()) {
                String segment = (String)segmentSizeInfo22.next();
                SegmentSizeDetails segmentSizeDetails = segmentToSizeDetailsMap.computeIfAbsent(segment, k -> new SegmentSizeDetails());
                segmentSizeDetails.serverInfo.put(string, new SegmentSizeInfo(segment, -1L));
            }
        }
        ArrayList<String> missingSegments = new ArrayList<String>();
        for (Map.Entry entry : segmentToSizeDetailsMap.entrySet()) {
            String segment = (String)entry.getKey();
            SegmentSizeDetails sizeDetails = (SegmentSizeDetails)entry.getValue();
            long segmentLevelMax = -1L;
            int errors = 0;
            for (SegmentSizeInfo sizeInfo : sizeDetails.serverInfo.values()) {
                if (sizeInfo.diskSizeInBytes != -1L) {
                    sizeDetails.reportedSizeInBytes += sizeInfo.diskSizeInBytes;
                    segmentLevelMax = Math.max(segmentLevelMax, sizeInfo.diskSizeInBytes);
                    continue;
                }
                ++errors;
            }
            if (errors != sizeDetails.serverInfo.size()) {
                sizeDetails.estimatedSizeInBytes = sizeDetails.reportedSizeInBytes + (long)errors * segmentLevelMax;
                subTypeSizeDetails.reportedSizeInBytes += sizeDetails.reportedSizeInBytes;
                subTypeSizeDetails.estimatedSizeInBytes += sizeDetails.estimatedSizeInBytes;
                continue;
            }
            missingSegments.add(segment);
            sizeDetails.reportedSizeInBytes = -1L;
            sizeDetails.estimatedSizeInBytes = -1L;
            ++subTypeSizeDetails.missingSegments;
        }
        if (subTypeSizeDetails.missingSegments > 0) {
            int numSegments = segmentToSizeDetailsMap.size();
            int n = subTypeSizeDetails.missingSegments * 100 / numSegments;
            this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.TABLE_STORAGE_EST_MISSING_SEGMENT_PERCENT, (long)n);
            if (subTypeSizeDetails.missingSegments == numSegments) {
                LOGGER.warn("Failed to get size report for all {} segments of table: {}", (Object)numSegments, (Object)tableNameWithType);
                subTypeSizeDetails.reportedSizeInBytes = -1L;
                subTypeSizeDetails.estimatedSizeInBytes = -1L;
            } else {
                LOGGER.warn("Missing size report for {} out of {} segments for table {}", new Object[]{subTypeSizeDetails.missingSegments, numSegments, tableNameWithType});
            }
        } else {
            this._controllerMetrics.setValueOfTableGauge(tableNameWithType, (AbstractMetrics.Gauge)ControllerGauge.TABLE_STORAGE_EST_MISSING_SEGMENT_PERCENT, 0L);
        }
        return subTypeSizeDetails;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class SegmentSizeDetails {
        public long reportedSizeInBytes = 0L;
        public long estimatedSizeInBytes = 0L;
        public Map<String, SegmentSizeInfo> serverInfo = new HashMap<String, SegmentSizeInfo>();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TableSubTypeSizeDetails {
        public long reportedSizeInBytes = 0L;
        public long estimatedSizeInBytes = 0L;
        public int missingSegments = 0;
        public Map<String, SegmentSizeDetails> segments = new HashMap<String, SegmentSizeDetails>();
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    public static class TableSizeDetails {
        public String tableName;
        public long reportedSizeInBytes = 0L;
        public long estimatedSizeInBytes = 0L;
        public TableSubTypeSizeDetails offlineSegments;
        public TableSubTypeSizeDetails realtimeSegments;

        public TableSizeDetails(String tableName) {
            this.tableName = tableName;
        }
    }
}

