/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.validation;

import java.util.List;
import java.util.Set;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.config.TableConfig;
import org.apache.pinot.common.metrics.ControllerMetrics;
import org.apache.pinot.controller.ControllerConf;
import org.apache.pinot.controller.LeadControllerManager;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.periodictask.ControllerPeriodicTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerResourceValidationManager
extends ControllerPeriodicTask<Context> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerResourceValidationManager.class);

    public BrokerResourceValidationManager(ControllerConf config, PinotHelixResourceManager pinotHelixResourceManager, LeadControllerManager leadControllerManager, ControllerMetrics controllerMetrics) {
        super("BrokerResourceValidationManager", config.getBrokerResourceValidationFrequencyInSeconds(), config.getBrokerResourceValidationInitialDelayInSeconds(), pinotHelixResourceManager, leadControllerManager, controllerMetrics);
    }

    @Override
    protected Context preprocess() {
        Context context = new Context();
        context._instanceConfigs = this._pinotHelixResourceManager.getAllHelixInstanceConfigs();
        return context;
    }

    @Override
    protected void processTable(String tableNameWithType, Context context) {
        TableConfig tableConfig = this._pinotHelixResourceManager.getTableConfig(tableNameWithType);
        if (tableConfig == null) {
            LOGGER.warn("Failed to find table config for table: {}, skipping broker resource validation", (Object)tableNameWithType);
            return;
        }
        Set<String> brokerInstances = this._pinotHelixResourceManager.getAllInstancesForBrokerTenant(context._instanceConfigs, tableConfig.getTenantConfig().getBroker());
        this._pinotHelixResourceManager.rebuildBrokerResource(tableNameWithType, brokerInstances);
    }

    public static final class Context {
        private List<InstanceConfig> _instanceConfigs;
    }
}

