/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import org.apache.commons.configuration.Configuration;
import org.apache.helix.controller.rebalancer.strategy.AutoRebalanceStrategy;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.filesystem.LocalPinotFS;

public class ControllerConf
extends PinotConfiguration {
    public static final String CONTROLLER_VIP_HOST = "controller.vip.host";
    public static final String CONTROLLER_VIP_PORT = "controller.vip.port";
    public static final String CONTROLLER_VIP_PROTOCOL = "controller.vip.protocol";
    public static final String CONTROLLER_HOST = "controller.host";
    public static final String CONTROLLER_PORT = "controller.port";
    public static final String CONTROLLER_ACCESS_PROTOCOLS = "controller.access.protocols";
    public static final String DATA_DIR = "controller.data.dir";
    public static final String LOCAL_TEMP_DIR = "controller.local.temp.dir";
    public static final String ZK_STR = "controller.zk.str";
    public static final String UPDATE_SEGMENT_STATE_MODEL = "controller.update_segment_state_model";
    public static final String HELIX_CLUSTER_NAME = "controller.helix.cluster.name";
    public static final String CLUSTER_TENANT_ISOLATION_ENABLE = "cluster.tenant.isolation.enable";
    public static final String CONSOLE_WEBAPP_ROOT_PATH = "controller.query.console";
    public static final String CONSOLE_WEBAPP_USE_HTTPS = "controller.query.console.useHttps";
    public static final String EXTERNAL_VIEW_ONLINE_TO_OFFLINE_TIMEOUT = "controller.upload.onlineToOfflineTimeout";
    public static final String CONTROLLER_MODE = "controller.mode";
    public static final String LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY = "controller.resource.rebalance.strategy";
    private static final String SERVER_ADMIN_REQUEST_TIMEOUT_SECONDS = "server.request.timeoutSeconds";
    private static final String SEGMENT_COMMIT_TIMEOUT_SECONDS = "controller.realtime.segment.commit.timeoutSeconds";
    private static final String DELETED_SEGMENTS_RETENTION_IN_DAYS = "controller.deleted.segments.retentionInDays";
    public static final String TABLE_MIN_REPLICAS = "table.minReplicas";
    public static final String ENABLE_SPLIT_COMMIT = "controller.enable.split.commit";
    private static final String JERSEY_ADMIN_API_PORT = "jersey.admin.api.port";
    private static final String JERSEY_ADMIN_IS_PRIMARY = "jersey.admin.isprimary";
    public static final String ACCESS_CONTROL_FACTORY_CLASS = "controller.admin.access.control.factory.class";
    private static final String SEGMENT_UPLOAD_TIMEOUT_IN_MILLIS = "controller.segment.upload.timeoutInMillis";
    private static final String REALTIME_SEGMENT_METADATA_COMMIT_NUMLOCKS = "controller.realtime.segment.metadata.commit.numLocks";
    private static final String ENABLE_STORAGE_QUOTA_CHECK = "controller.enable.storage.quota.check";
    private static final String ENABLE_BATCH_MESSAGE_MODE = "controller.enable.batch.message.mode";
    public static final String ALLOW_HLC_TABLES = "controller.allow.hlc.tables";
    private static final String PINOT_FS_FACTORY_CLASS_LOCAL = "controller.storage.factory.class.file";
    private static final long DEFAULT_EXTERNAL_VIEW_ONLINE_TO_OFFLINE_TIMEOUT_MILLIS = 120000L;
    private static final int DEFAULT_SERVER_ADMIN_REQUEST_TIMEOUT_SECONDS = 30;
    private static final int DEFAULT_DELETED_SEGMENTS_RETENTION_IN_DAYS = 7;
    private static final int DEFAULT_TABLE_MIN_REPLICAS = 1;
    private static final boolean DEFAULT_ENABLE_SPLIT_COMMIT = false;
    private static final int DEFAULT_JERSEY_ADMIN_PORT = 21000;
    private static final String DEFAULT_ACCESS_CONTROL_FACTORY_CLASS = "org.apache.pinot.controller.api.access.AllowAllAccessFactory";
    private static final long DEFAULT_SEGMENT_UPLOAD_TIMEOUT_IN_MILLIS = 600000L;
    private static final int DEFAULT_REALTIME_SEGMENT_METADATA_COMMIT_NUMLOCKS = 64;
    private static final boolean DEFAULT_ENABLE_STORAGE_QUOTA_CHECK = true;
    private static final boolean DEFAULT_ENABLE_BATCH_MESSAGE_MODE = false;
    private static final boolean DEFAULT_ALLOW_HLC_TABLES = true;
    private static final String DEFAULT_CONTROLLER_MODE = ControllerMode.DUAL.name();
    private static final String DEFAULT_LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY = AutoRebalanceStrategy.class.getName();
    private static final String DEFAULT_PINOT_FS_FACTORY_CLASS_LOCAL = LocalPinotFS.class.getName();

    public ControllerConf() {
        super(new HashMap());
    }

    public ControllerConf(Map<String, Object> baseProperties) {
        super(baseProperties);
    }

    public ControllerConf(Configuration baseConfiguration) {
        super(baseConfiguration);
    }

    public void setLocalTempDir(String localTempDir) {
        this.setProperty(LOCAL_TEMP_DIR, localTempDir);
    }

    public String getLocalTempDir() {
        return this.getProperty(LOCAL_TEMP_DIR);
    }

    public void setPinotFSFactoryClasses(Configuration pinotFSFactoryClasses) {
        this.setProperty(PINOT_FS_FACTORY_CLASS_LOCAL, DEFAULT_PINOT_FS_FACTORY_CLASS_LOCAL);
        if (pinotFSFactoryClasses != null) {
            pinotFSFactoryClasses.getKeys().forEachRemaining(key -> this.setProperty((String)key, pinotFSFactoryClasses.getProperty(key)));
        }
    }

    public void setSplitCommit(boolean isSplitCommit) {
        this.setProperty(ENABLE_SPLIT_COMMIT, isSplitCommit);
    }

    public void setQueryConsolePath(String path) {
        this.setProperty(CONSOLE_WEBAPP_ROOT_PATH, path);
    }

    public String getQueryConsoleWebappPath() {
        return Optional.ofNullable(this.getProperty(CONSOLE_WEBAPP_ROOT_PATH)).orElseGet(() -> ControllerConf.class.getClassLoader().getResource("webapp").toExternalForm());
    }

    public void setQueryConsoleUseHttps(boolean useHttps) {
        this.setProperty(CONSOLE_WEBAPP_USE_HTTPS, useHttps);
    }

    public boolean getQueryConsoleUseHttps() {
        return this.getProperty(CONSOLE_WEBAPP_USE_HTTPS, false);
    }

    public void setJerseyAdminPrimary(String jerseyAdminPrimary) {
        this.setProperty(JERSEY_ADMIN_IS_PRIMARY, jerseyAdminPrimary);
    }

    public void setHelixClusterName(String clusterName) {
        this.setProperty(HELIX_CLUSTER_NAME, clusterName);
    }

    public void setControllerHost(String host) {
        this.setProperty(CONTROLLER_HOST, host);
    }

    public void setControllerVipHost(String vipHost) {
        this.setProperty(CONTROLLER_VIP_HOST, vipHost);
    }

    public void setControllerVipPort(String vipPort) {
        this.setProperty(CONTROLLER_VIP_PORT, vipPort);
    }

    public void setControllerVipProtocol(String vipProtocol) {
        this.setProperty(CONTROLLER_VIP_PROTOCOL, vipProtocol);
    }

    public void setControllerPort(String port) {
        this.setProperty(CONTROLLER_PORT, port);
    }

    public void setDataDir(String dataDir) {
        this.setProperty(DATA_DIR, dataDir);
    }

    public void setRealtimeSegmentCommitTimeoutSeconds(int timeoutSec) {
        this.setProperty(SEGMENT_COMMIT_TIMEOUT_SECONDS, Integer.toString(timeoutSec));
    }

    public void setUpdateSegmentStateModel(String updateStateModel) {
        this.setProperty(UPDATE_SEGMENT_STATE_MODEL, updateStateModel);
    }

    public void setZkStr(String zkStr) {
        this.setProperty(ZK_STR, zkStr);
    }

    public boolean isJerseyAdminPrimary() {
        return this.getProperty(JERSEY_ADMIN_IS_PRIMARY, true);
    }

    public String getHelixClusterName() {
        return this.getProperty(HELIX_CLUSTER_NAME);
    }

    public String getControllerHost() {
        return this.getProperty(CONTROLLER_HOST);
    }

    public String getControllerPort() {
        return this.getProperty(CONTROLLER_PORT);
    }

    public List<String> getControllerAccessProtocols() {
        return this.getProperty(CONTROLLER_ACCESS_PROTOCOLS, this.getControllerPort() == null ? Arrays.asList("http") : Arrays.asList(new String[0]));
    }

    public String getControllerAccessProtocolProperty(String protocol, String property) {
        return this.getProperty("controller.access.protocols." + protocol + "." + property);
    }

    public String getControllerAccessProtocolProperty(String protocol, String property, String defaultValue) {
        return this.getProperty("controller.access.protocols." + protocol + "." + property, defaultValue);
    }

    public boolean getControllerAccessProtocolProperty(String protocol, String property, boolean defaultValue) {
        return this.getProperty("controller.access.protocols." + protocol + "." + property, defaultValue);
    }

    public String getDataDir() {
        return this.getProperty(DATA_DIR);
    }

    public int getSegmentCommitTimeoutSeconds() {
        return this.getProperty(SEGMENT_COMMIT_TIMEOUT_SECONDS, SegmentCompletionProtocol.getDefaultMaxSegmentCommitTimeSeconds());
    }

    public boolean isUpdateSegmentStateModel() {
        return this.getProperty(UPDATE_SEGMENT_STATE_MODEL, false);
    }

    public String generateVipUrl() {
        return this.getControllerVipProtocol() + "://" + this.getControllerVipHost() + ":" + this.getControllerVipPort();
    }

    public String getZkStr() {
        return this.getProperty(ZK_STR);
    }

    public String toString() {
        return super.toString();
    }

    public boolean getAcceptSplitCommit() {
        return this.getProperty(ENABLE_SPLIT_COMMIT, false);
    }

    public String getControllerVipHost() {
        return Optional.ofNullable(this.getProperty(CONTROLLER_VIP_HOST)).filter(controllerVipHost -> !controllerVipHost.isEmpty()).orElseGet(() -> this.getProperty(CONTROLLER_HOST));
    }

    public String getControllerVipPort() {
        return Optional.ofNullable(this.getProperty(CONTROLLER_VIP_PORT)).filter(controllerVipPort -> !controllerVipPort.isEmpty()).orElseGet(() -> this.getControllerAccessProtocols().stream().filter(protocol -> this.getControllerAccessProtocolProperty((String)protocol, "vip", false)).map(protocol -> Optional.ofNullable(this.getControllerAccessProtocolProperty((String)protocol, "port"))).filter(Optional::isPresent).map(Optional::get).findFirst().orElseGet(this::getControllerPort));
    }

    public String getControllerVipProtocol() {
        return Optional.ofNullable(this.getProperty(CONTROLLER_VIP_PROTOCOL)).filter(protocol -> "https".equals(protocol)).orElse("http");
    }

    public int getRetentionControllerFrequencyInSeconds() {
        return this.getProperty("controller.retention.frequencyInSeconds", 21600);
    }

    public void setRetentionControllerFrequencyInSeconds(int retentionFrequencyInSeconds) {
        this.setProperty("controller.retention.frequencyInSeconds", Integer.toString(retentionFrequencyInSeconds));
    }

    public int getOfflineSegmentIntervalCheckerFrequencyInSeconds() {
        return this.getProperty("controller.offline.segment.interval.checker.frequencyInSeconds", 86400);
    }

    public void setOfflineSegmentIntervalCheckerFrequencyInSeconds(int validationFrequencyInSeconds) {
        this.setProperty("controller.offline.segment.interval.checker.frequencyInSeconds", Integer.toString(validationFrequencyInSeconds));
    }

    public int getRealtimeSegmentValidationFrequencyInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.realtime.segment.validation.frequencyInSeconds", Integer.class)).orElseGet(() -> this.getProperty("controller.validation.frequencyInSeconds", 3600));
    }

    public void setRealtimeSegmentValidationFrequencyInSeconds(int validationFrequencyInSeconds) {
        this.setProperty("controller.realtime.segment.validation.frequencyInSeconds", Integer.toString(validationFrequencyInSeconds));
    }

    public int getBrokerResourceValidationFrequencyInSeconds() {
        return Optional.ofNullable(this.getProperty("controller.broker.resource.validation.frequencyInSeconds", Integer.class)).orElseGet(() -> this.getProperty("controller.validation.frequencyInSeconds", 3600));
    }

    public void setBrokerResourceValidationFrequencyInSeconds(int validationFrequencyInSeconds) {
        this.setProperty("controller.broker.resource.validation.frequencyInSeconds", Integer.toString(validationFrequencyInSeconds));
    }

    public long getBrokerResourceValidationInitialDelayInSeconds() {
        return this.getProperty("controller.broker.resource.validation.initialDelayInSeconds", this.getPeriodicTaskInitialDelayInSeconds());
    }

    public int getStatusCheckerFrequencyInSeconds() {
        return this.getProperty("controller.statuschecker.frequencyInSeconds", 300);
    }

    public void setStatusCheckerFrequencyInSeconds(int statusCheckerFrequencyInSeconds) {
        this.setProperty("controller.statuschecker.frequencyInSeconds", Integer.toString(statusCheckerFrequencyInSeconds));
    }

    public String getRealtimeSegmentRelocatorFrequency() {
        return this.getProperty("controller.realtime.segment.relocator.frequency", "1h");
    }

    public void setRealtimeSegmentRelocatorFrequency(String relocatorFrequency) {
        this.setProperty("controller.realtime.segment.relocator.frequency", relocatorFrequency);
    }

    public int getStatusCheckerWaitForPushTimeInSeconds() {
        return this.getProperty("controller.statuschecker.waitForPushTimeInSeconds", 600);
    }

    public void setStatusCheckerWaitForPushTimeInSeconds(int statusCheckerWaitForPushTimeInSeconds) {
        this.setProperty("controller.statuschecker.waitForPushTimeInSeconds", Integer.toString(statusCheckerWaitForPushTimeInSeconds));
    }

    public long getExternalViewOnlineToOfflineTimeout() {
        return this.getProperty(EXTERNAL_VIEW_ONLINE_TO_OFFLINE_TIMEOUT, 120000L);
    }

    public void setExternalViewOnlineToOfflineTimeout(long timeout) {
        this.setProperty(EXTERNAL_VIEW_ONLINE_TO_OFFLINE_TIMEOUT, timeout);
    }

    public boolean tenantIsolationEnabled() {
        return this.getProperty(CLUSTER_TENANT_ISOLATION_ENABLE, true);
    }

    public void setTenantIsolationEnabled(boolean isSingleTenant) {
        this.setProperty(CLUSTER_TENANT_ISOLATION_ENABLE, isSingleTenant);
    }

    public void setServerAdminRequestTimeoutSeconds(int timeoutSeconds) {
        this.setProperty(SERVER_ADMIN_REQUEST_TIMEOUT_SECONDS, timeoutSeconds);
    }

    public int getServerAdminRequestTimeoutSeconds() {
        return this.getProperty(SERVER_ADMIN_REQUEST_TIMEOUT_SECONDS, 30);
    }

    public int getDeletedSegmentsRetentionInDays() {
        return this.getProperty(DELETED_SEGMENTS_RETENTION_IN_DAYS, 7);
    }

    public void setDeletedSegmentsRetentionInDays(int retentionInDays) {
        this.setProperty(DELETED_SEGMENTS_RETENTION_IN_DAYS, retentionInDays);
    }

    public int getTaskManagerFrequencyInSeconds() {
        return this.getProperty("controller.task.frequencyInSeconds", -1);
    }

    public void setTaskManagerFrequencyInSeconds(int frequencyInSeconds) {
        this.setProperty("controller.task.frequencyInSeconds", Integer.toString(frequencyInSeconds));
    }

    public int getDefaultTableMinReplicas() {
        return this.getProperty(TABLE_MIN_REPLICAS, 1);
    }

    public void setTableMinReplicas(int minReplicas) {
        this.setProperty(TABLE_MIN_REPLICAS, minReplicas);
    }

    public String getJerseyAdminApiPort() {
        return this.getProperty(JERSEY_ADMIN_API_PORT, String.valueOf(21000));
    }

    public String getAccessControlFactoryClass() {
        return this.getProperty(ACCESS_CONTROL_FACTORY_CLASS, DEFAULT_ACCESS_CONTROL_FACTORY_CLASS);
    }

    public void setAccessControlFactoryClass(String accessControlFactoryClass) {
        this.setProperty(ACCESS_CONTROL_FACTORY_CLASS, accessControlFactoryClass);
    }

    public long getSegmentUploadTimeoutInMillis() {
        return this.getProperty(SEGMENT_UPLOAD_TIMEOUT_IN_MILLIS, 600000L);
    }

    public void setSegmentUploadTimeoutInMillis(long segmentUploadTimeoutInMillis) {
        this.setProperty(SEGMENT_UPLOAD_TIMEOUT_IN_MILLIS, segmentUploadTimeoutInMillis);
    }

    public int getRealtimeSegmentMetadataCommitNumLocks() {
        return this.getProperty(REALTIME_SEGMENT_METADATA_COMMIT_NUMLOCKS, 64);
    }

    public void setRealtimeSegmentMetadataCommitNumLocks(int realtimeSegmentMetadataCommitNumLocks) {
        this.setProperty(REALTIME_SEGMENT_METADATA_COMMIT_NUMLOCKS, realtimeSegmentMetadataCommitNumLocks);
    }

    public boolean getEnableStorageQuotaCheck() {
        return this.getProperty(ENABLE_STORAGE_QUOTA_CHECK, true);
    }

    public boolean getEnableBatchMessageMode() {
        return this.getProperty(ENABLE_BATCH_MESSAGE_MODE, false);
    }

    public int getSegmentLevelValidationIntervalInSeconds() {
        return this.getProperty("controller.segment.level.validation.intervalInSeconds", 86400);
    }

    public long getStatusCheckerInitialDelayInSeconds() {
        return this.getProperty("controller.statusChecker.initialDelayInSeconds", ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds());
    }

    public long getRetentionManagerInitialDelayInSeconds() {
        return this.getProperty("controller.retentionManager.initialDelayInSeconds", ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds());
    }

    public long getRealtimeSegmentRelocationInitialDelayInSeconds() {
        return this.getProperty("controller.realtimeSegmentRelocation.initialDelayInSeconds", ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds());
    }

    public long getOfflineSegmentIntervalCheckerInitialDelayInSeconds() {
        return this.getProperty("controller.offlineSegmentIntervalChecker.initialDelayInSeconds", ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds());
    }

    public long getRealtimeSegmentValidationManagerInitialDelaySeconds() {
        return this.getPeriodicTaskInitialDelayInSeconds();
    }

    public long getPinotTaskManagerInitialDelaySeconds() {
        return this.getPeriodicTaskInitialDelayInSeconds();
    }

    public long getPeriodicTaskInitialDelayInSeconds() {
        return ControllerPeriodicTasksConf.getRandomInitialDelayInSeconds();
    }

    public void setControllerMode(ControllerMode controllerMode) {
        this.setProperty(CONTROLLER_MODE, controllerMode.name());
    }

    public ControllerMode getControllerMode() {
        return ControllerMode.valueOf(this.getProperty(CONTROLLER_MODE, DEFAULT_CONTROLLER_MODE.toString()).toUpperCase());
    }

    public void setLeadControllerResourceRebalanceStrategy(String rebalanceStrategy) {
        this.setProperty(LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY, rebalanceStrategy);
    }

    public String getLeadControllerResourceRebalanceStrategy() {
        return this.getProperty(LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY, DEFAULT_LEAD_CONTROLLER_RESOURCE_REBALANCE_STRATEGY);
    }

    public boolean getHLCTablesAllowed() {
        return this.getProperty(ALLOW_HLC_TABLES, true);
    }

    public void setHLCTablesAllowed(boolean allowHLCTables) {
        this.setProperty(ALLOW_HLC_TABLES, allowHLCTables);
    }

    public String getMetricsPrefix() {
        return this.getProperty("controller.metrics.prefix", "pinot.controller");
    }

    public static class ControllerPeriodicTasksConf {
        public static final String RETENTION_MANAGER_FREQUENCY_IN_SECONDS = "controller.retention.frequencyInSeconds";
        @Deprecated
        public static final String DEPRECATED_VALIDATION_MANAGER_FREQUENCY_IN_SECONDS = "controller.validation.frequencyInSeconds";
        public static final String OFFLINE_SEGMENT_INTERVAL_CHECKER_FREQUENCY_IN_SECONDS = "controller.offline.segment.interval.checker.frequencyInSeconds";
        public static final String REALTIME_SEGMENT_VALIDATION_FREQUENCY_IN_SECONDS = "controller.realtime.segment.validation.frequencyInSeconds";
        public static final String BROKER_RESOURCE_VALIDATION_FREQUENCY_IN_SECONDS = "controller.broker.resource.validation.frequencyInSeconds";
        public static final String BROKER_RESOURCE_VALIDATION_INITIAL_DELAY_IN_SECONDS = "controller.broker.resource.validation.initialDelayInSeconds";
        public static final String STATUS_CHECKER_FREQUENCY_IN_SECONDS = "controller.statuschecker.frequencyInSeconds";
        public static final String STATUS_CHECKER_WAIT_FOR_PUSH_TIME_IN_SECONDS = "controller.statuschecker.waitForPushTimeInSeconds";
        public static final String TASK_MANAGER_FREQUENCY_IN_SECONDS = "controller.task.frequencyInSeconds";
        public static final String REALTIME_SEGMENT_RELOCATOR_FREQUENCY = "controller.realtime.segment.relocator.frequency";
        public static final String SEGMENT_LEVEL_VALIDATION_INTERVAL_IN_SECONDS = "controller.segment.level.validation.intervalInSeconds";
        public static final String STATUS_CHECKER_INITIAL_DELAY_IN_SECONDS = "controller.statusChecker.initialDelayInSeconds";
        public static final String RETENTION_MANAGER_INITIAL_DELAY_IN_SECONDS = "controller.retentionManager.initialDelayInSeconds";
        public static final String OFFLINE_SEGMENT_INTERVAL_CHECKER_INITIAL_DELAY_IN_SECONDS = "controller.offlineSegmentIntervalChecker.initialDelayInSeconds";
        public static final String REALTIME_SEGMENT_RELOCATION_INITIAL_DELAY_IN_SECONDS = "controller.realtimeSegmentRelocation.initialDelayInSeconds";
        public static final int MIN_INITIAL_DELAY_IN_SECONDS = 120;
        public static final int MAX_INITIAL_DELAY_IN_SECONDS = 300;
        private static final Random RANDOM = new Random();
        private static final int DEFAULT_RETENTION_CONTROLLER_FREQUENCY_IN_SECONDS = 21600;
        private static final int DEFAULT_OFFLINE_SEGMENT_INTERVAL_CHECKER_FREQUENCY_IN_SECONDS = 86400;
        private static final int DEFAULT_REALTIME_SEGMENT_VALIDATION_FREQUENCY_IN_SECONDS = 3600;
        private static final int DEFAULT_BROKER_RESOURCE_VALIDATION_FREQUENCY_IN_SECONDS = 3600;
        private static final int DEFAULT_STATUS_CONTROLLER_FREQUENCY_IN_SECONDS = 300;
        private static final int DEFAULT_STATUS_CONTROLLER_WAIT_FOR_PUSH_TIME_IN_SECONDS = 600;
        private static final int DEFAULT_TASK_MANAGER_FREQUENCY_IN_SECONDS = -1;
        private static final String DEFAULT_REALTIME_SEGMENT_RELOCATOR_FREQUENCY = "1h";
        private static final int DEFAULT_SEGMENT_LEVEL_VALIDATION_INTERVAL_IN_SECONDS = 86400;

        private static long getRandomInitialDelayInSeconds() {
            return 120 + RANDOM.nextInt(180);
        }
    }

    public static enum ControllerMode {
        DUAL,
        PINOT_ONLY,
        HELIX_ONLY;

    }
}

