/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api;

import com.google.common.base.Preconditions;
import io.swagger.jaxrs.config.BeanConfig;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.List;
import java.util.stream.Collectors;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import org.apache.pinot.controller.api.listeners.ListenerConfig;
import org.apache.pinot.controller.api.listeners.TlsConfiguration;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.internal.guava.ThreadFactoryBuilder;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.process.JerseyProcessingUncaughtExceptionHandler;
import org.glassfish.jersey.server.ResourceConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerAdminApiApplication
extends ResourceConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(ControllerAdminApiApplication.class);
    private HttpServer _httpServer;
    private static final String RESOURCE_PACKAGE = "org.apache.pinot.controller.api.resources";

    public ControllerAdminApiApplication() {
        this.packages(new String[]{RESOURCE_PACKAGE});
        this.register(JacksonFeature.class);
        this.register(MultiPartFeature.class);
        this.registerClasses(new Class[]{ApiListingResource.class});
        this.registerClasses(new Class[]{SwaggerSerializers.class});
        this.register(new CorsFilter());
    }

    private SSLEngineConfigurator buildSSLEngineConfigurator(TlsConfiguration tlsConfiguration) {
        SSLContextConfigurator sslContextConfigurator = new SSLContextConfigurator();
        sslContextConfigurator.setKeyStoreFile(tlsConfiguration.getKeyStorePath());
        sslContextConfigurator.setKeyStorePass(tlsConfiguration.getKeyStorePassword());
        sslContextConfigurator.setTrustStoreFile(tlsConfiguration.getTrustStorePath());
        sslContextConfigurator.setTrustStorePass(tlsConfiguration.getTrustStorePassword());
        return new SSLEngineConfigurator(sslContextConfigurator).setClientMode(false).setWantClientAuth(tlsConfiguration.isRequiresClientAuth()).setEnabledProtocols(new String[]{"TLSv1.2 "});
    }

    public void registerBinder(AbstractBinder binder) {
        this.register(binder);
    }

    private void configureListener(ListenerConfig listenerConfig, HttpServer httpServer) {
        NetworkListener listener = new NetworkListener(listenerConfig.getName() + "-" + listenerConfig.getPort(), listenerConfig.getHost(), listenerConfig.getPort());
        listener.getTransport().getWorkerThreadPoolConfig().setThreadFactory(new ThreadFactoryBuilder().setNameFormat("grizzly-http-server-%d").setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new JerseyProcessingUncaughtExceptionHandler()).build());
        listener.setSecure(listenerConfig.getTlsConfiguration() != null);
        if (listener.isSecure()) {
            listener.setSSLEngineConfig(this.buildSSLEngineConfigurator(listenerConfig.getTlsConfiguration()));
        }
        httpServer.addListener(listener);
    }

    public void start(List<ListenerConfig> listenerConfigs, boolean advertiseHttps) {
        Preconditions.checkNotNull(listenerConfigs);
        this._httpServer = GrizzlyHttpServerFactory.createHttpServer((URI)URI.create("http://0.0.0.0/"), (ResourceConfig)this, (boolean)false);
        this._httpServer.removeListener("grizzly");
        listenerConfigs.forEach(listenerConfig -> this.configureListener((ListenerConfig)listenerConfig, this._httpServer));
        try {
            this._httpServer.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to start Http Server", e);
        }
        this.setupSwagger(this._httpServer, advertiseHttps);
        ClassLoader classLoader = ControllerAdminApiApplication.class.getClassLoader();
        this._httpServer.getServerConfiguration().addHttpHandler((HttpHandler)new CLStaticHttpHandler(classLoader, new String[]{"/webapp/"}), new String[]{"/index.html"});
        this._httpServer.getServerConfiguration().addHttpHandler((HttpHandler)new CLStaticHttpHandler(classLoader, new String[]{"/webapp/js/"}), new String[]{"/js/"});
        LOGGER.info("Admin API started on ports: {}", (Object)listenerConfigs.stream().map(ListenerConfig::getPort).map(port -> port.toString()).collect(Collectors.joining(",")));
    }

    private void setupSwagger(HttpServer httpServer, boolean advertiseHttps) {
        BeanConfig beanConfig = new BeanConfig();
        beanConfig.setTitle("Pinot Controller API");
        beanConfig.setDescription("APIs for accessing Pinot Controller information");
        beanConfig.setContact("https://github.com/apache/incubator-pinot");
        beanConfig.setVersion("1.0");
        if (advertiseHttps) {
            beanConfig.setSchemes(new String[]{"https"});
        } else {
            beanConfig.setSchemes(new String[]{"http"});
        }
        beanConfig.setBasePath("/");
        beanConfig.setResourcePackage(RESOURCE_PACKAGE);
        beanConfig.setScan(true);
        ClassLoader loader = ((Object)((Object)this)).getClass().getClassLoader();
        CLStaticHttpHandler apiStaticHttpHandler = new CLStaticHttpHandler(loader, new String[]{"/api/"});
        httpServer.getServerConfiguration().addHttpHandler((HttpHandler)apiStaticHttpHandler, new String[]{"/api/"});
        httpServer.getServerConfiguration().addHttpHandler((HttpHandler)apiStaticHttpHandler, new String[]{"/help/"});
        URL swaggerDistLocation = loader.getResource("META-INF/resources/webjars/swagger-ui/2.2.2/");
        CLStaticHttpHandler swaggerDist = new CLStaticHttpHandler((ClassLoader)new URLClassLoader(new URL[]{swaggerDistLocation}), new String[0]);
        httpServer.getServerConfiguration().addHttpHandler((HttpHandler)swaggerDist, new String[]{"/swaggerui-dist/"});
    }

    public void stop() {
        if (!this._httpServer.isStarted()) {
            return;
        }
        this._httpServer.shutdownNow();
    }

    private class CorsFilter
    implements ContainerResponseFilter {
        private CorsFilter() {
        }

        public void filter(ContainerRequestContext containerRequestContext, ContainerResponseContext containerResponseContext) throws IOException {
            containerResponseContext.getHeaders().add((Object)"Access-Control-Allow-Origin", (Object)"*");
        }
    }
}

