/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import java.io.IOException;
import java.net.URI;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PreMatching
@Provider
@Priority(value=1)
public class HeaderAdder
implements ContainerRequestFilter {
    public static final Logger LOGGER = LoggerFactory.getLogger(HeaderAdder.class);

    private String modifiedContentType(String path) {
        if (path.startsWith("tenants")) {
            return "application/json";
        }
        if (path.startsWith("instances")) {
            String[] pathParts = path.split("/");
            if (pathParts[pathParts.length - 1].equals("state")) {
                return "text/plain";
            }
            return "application/json";
        }
        return null;
    }

    public void filter(ContainerRequestContext req) throws IOException {
        String mediaType;
        String incomingReqUri = req.getUriInfo().getRequestUri().toString();
        String incomingBaseUri = req.getUriInfo().getBaseUri().toASCIIString();
        try {
            String relativeUri;
            String baseUriWithoutSlash = incomingBaseUri;
            if (incomingBaseUri.endsWith("/")) {
                baseUriWithoutSlash = incomingBaseUri.substring(0, incomingBaseUri.length() - 1);
            }
            if (incomingReqUri.startsWith(baseUriWithoutSlash) && !(relativeUri = incomingReqUri.substring(baseUriWithoutSlash.length())).startsWith("/")) {
                URI newReqUri = new URI(baseUriWithoutSlash + "/" + relativeUri);
                LOGGER.warn("Rewriting new Request URI {} (incomingBaseUri = {}, incomingReqUri = {})", new Object[]{newReqUri.toString(), incomingBaseUri, incomingReqUri});
                req.setRequestUri(newReqUri);
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception handling incoming URI {}, base URI {}", (Object)incomingReqUri, (Object)incomingBaseUri);
        }
        String path = req.getUriInfo().getPath();
        if ((req.getMethod().equalsIgnoreCase("PUT") || req.getMethod().equalsIgnoreCase("POST")) && (mediaType = this.modifiedContentType(path)) != null) {
            req.getHeaders().remove((Object)"Content-Type");
            req.getHeaders().add((Object)"Content-Type", (Object)mediaType);
        }
    }
}

