/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.common.protocols.SegmentCompletionProtocol;
import org.apache.pinot.common.utils.LLCSegmentName;
import org.apache.pinot.common.utils.TarGzCompressionUtils;
import org.apache.pinot.common.utils.URIUtils;
import org.apache.pinot.common.utils.fetcher.SegmentFetcherFactory;
import org.apache.pinot.controller.api.resources.ControllerFilePathProvider;
import org.apache.pinot.controller.api.resources.PinotSegmentUploadDownloadRestletResource;
import org.apache.pinot.controller.helix.core.realtime.SegmentCompletionManager;
import org.apache.pinot.controller.helix.core.realtime.segment.CommittingSegmentDescriptor;
import org.apache.pinot.controller.util.SegmentCompletionUtils;
import org.apache.pinot.core.segment.index.metadata.SegmentMetadataImpl;
import org.apache.pinot.spi.filesystem.PinotFS;
import org.apache.pinot.spi.filesystem.PinotFSFactory;
import org.glassfish.jersey.media.multipart.FormDataBodyPart;
import org.glassfish.jersey.media.multipart.FormDataMultiPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
public class LLCSegmentCompletionHandlers {
    private static final Logger LOGGER = LoggerFactory.getLogger(LLCSegmentCompletionHandlers.class);
    private static final Object SEGMENT_UPLOAD_LOCK = new Object();
    private static final String SCHEME = "file://";
    @Inject
    SegmentCompletionManager _segmentCompletionManager;

    @VisibleForTesting
    public static String getScheme() {
        return SCHEME;
    }

    @GET
    @Path(value="extendBuildTime")
    @Produces(value={"application/json"})
    public String extendBuildTime(@QueryParam(value="instance") String instanceId, @QueryParam(value="name") String segmentName, @QueryParam(value="offset") long offset, @QueryParam(value="streamPartitionMsgOffset") String streamPartitionMsgOffset, @QueryParam(value="extraTimeSec") int extraTimeSec) {
        if (instanceId == null || segmentName == null || offset == -1L && streamPartitionMsgOffset == null) {
            LOGGER.error("Invalid call: offset={}, segmentName={}, instanceId={}, streamPartitionMsgOffset={}", new Object[]{offset, segmentName, instanceId, streamPartitionMsgOffset});
            return SegmentCompletionProtocol.RESP_FAILED.toJsonString();
        }
        if (extraTimeSec <= 0) {
            LOGGER.warn("Invalid value {} for extra build time from instance {} for segment {}", new Object[]{extraTimeSec, instanceId, segmentName});
            extraTimeSec = SegmentCompletionProtocol.getDefaultMaxSegmentCommitTimeSeconds();
        }
        SegmentCompletionProtocol.Request.Params requestParams = new SegmentCompletionProtocol.Request.Params();
        requestParams.withInstanceId(instanceId).withSegmentName(segmentName).withExtraTimeSec(extraTimeSec);
        this.extractOffsetFromParams(requestParams, streamPartitionMsgOffset, offset);
        LOGGER.info("Processing extendBuildTime:{}", (Object)requestParams.toString());
        SegmentCompletionProtocol.Response response = this._segmentCompletionManager.extendBuildTime(requestParams);
        String responseStr = response.toJsonString();
        LOGGER.info("Response to extendBuildTime:{}", (Object)responseStr);
        return responseStr;
    }

    private void extractOffsetFromParams(SegmentCompletionProtocol.Request.Params requestParams, String streamPartitionMsgOffset, long offset) {
        if (streamPartitionMsgOffset != null) {
            requestParams.withStreamPartitionMsgOffset(streamPartitionMsgOffset);
        } else {
            requestParams.withStreamPartitionMsgOffset(Long.toString(offset));
        }
    }

    @GET
    @Path(value="segmentConsumed")
    @Produces(value={"application/json"})
    public String segmentConsumed(@QueryParam(value="instance") String instanceId, @QueryParam(value="name") String segmentName, @QueryParam(value="offset") long offset, @QueryParam(value="streamPartitionMsgOffset") String streamPartitionMsgOffset, @QueryParam(value="reason") String stopReason, @QueryParam(value="memoryUsedBytes") long memoryUsedBytes, @QueryParam(value="rowCount") int numRows) {
        if (instanceId == null || segmentName == null || offset == -1L && streamPartitionMsgOffset == null) {
            LOGGER.error("Invalid call: offset={}, segmentName={}, instanceId={}, streamPartitionMsgOffset={}", new Object[]{offset, segmentName, instanceId, streamPartitionMsgOffset});
            return SegmentCompletionProtocol.RESP_FAILED.toJsonString();
        }
        SegmentCompletionProtocol.Request.Params requestParams = new SegmentCompletionProtocol.Request.Params();
        requestParams.withInstanceId(instanceId).withSegmentName(segmentName).withReason(stopReason).withMemoryUsedBytes(memoryUsedBytes).withNumRows(numRows);
        this.extractOffsetFromParams(requestParams, streamPartitionMsgOffset, offset);
        LOGGER.info("Processing segmentConsumed:{}", (Object)requestParams.toString());
        SegmentCompletionProtocol.Response response = this._segmentCompletionManager.segmentConsumed(requestParams);
        String responseStr = response.toJsonString();
        LOGGER.info("Response to segmentConsumed for segment:{} is :{}", (Object)segmentName, (Object)responseStr);
        return responseStr;
    }

    @GET
    @Path(value="segmentStoppedConsuming")
    @Produces(value={"application/json"})
    public String segmentStoppedConsuming(@QueryParam(value="instance") String instanceId, @QueryParam(value="name") String segmentName, @QueryParam(value="offset") long offset, @QueryParam(value="streamPartitionMsgOffset") String streamPartitionMsgOffset, @QueryParam(value="reason") String stopReason) {
        if (instanceId == null || segmentName == null || offset == -1L && streamPartitionMsgOffset == null) {
            LOGGER.error("Invalid call: offset={}, segmentName={}, instanceId={}, streamPartitionMsgOffset={}", new Object[]{offset, segmentName, instanceId, streamPartitionMsgOffset});
            return SegmentCompletionProtocol.RESP_FAILED.toJsonString();
        }
        SegmentCompletionProtocol.Request.Params requestParams = new SegmentCompletionProtocol.Request.Params();
        requestParams.withInstanceId(instanceId).withSegmentName(segmentName).withReason(stopReason);
        this.extractOffsetFromParams(requestParams, streamPartitionMsgOffset, offset);
        LOGGER.info("Processing segmentStoppedConsuming:{}", (Object)requestParams.toString());
        SegmentCompletionProtocol.Response response = this._segmentCompletionManager.segmentStoppedConsuming(requestParams);
        String responseStr = response.toJsonString();
        LOGGER.info("Response to segmentStoppedConsuming for segment:{} is:{}", (Object)segmentName, (Object)responseStr);
        return responseStr;
    }

    @GET
    @Path(value="segmentCommitStart")
    @Produces(value={"application/json"})
    public String segmentCommitStart(@QueryParam(value="instance") String instanceId, @QueryParam(value="name") String segmentName, @QueryParam(value="offset") long offset, @QueryParam(value="streamPartitionMsgOffset") String streamPartitionMsgOffset, @QueryParam(value="memoryUsedBytes") long memoryUsedBytes, @QueryParam(value="buildTimeMillis") long buildTimeMillis, @QueryParam(value="waitTimeMillis") long waitTimeMillis, @QueryParam(value="rowCount") int numRows, @QueryParam(value="segmentSizeBytes") long segmentSizeBytes) {
        if (instanceId == null || segmentName == null || offset == -1L && streamPartitionMsgOffset == null) {
            LOGGER.error("Invalid call: offset={}, segmentName={}, instanceId={}, streamPartitionMsgOffset={}", new Object[]{offset, segmentName, instanceId, streamPartitionMsgOffset});
            LOGGER.error("Invalid call: offset={}, segmentName={}, instanceId={}", new Object[]{offset, segmentName, instanceId});
            return SegmentCompletionProtocol.RESP_FAILED.toJsonString();
        }
        SegmentCompletionProtocol.Request.Params requestParams = new SegmentCompletionProtocol.Request.Params();
        requestParams.withInstanceId(instanceId).withSegmentName(segmentName).withMemoryUsedBytes(memoryUsedBytes).withBuildTimeMillis(buildTimeMillis).withWaitTimeMillis(waitTimeMillis).withNumRows(numRows).withSegmentSizeBytes(segmentSizeBytes);
        this.extractOffsetFromParams(requestParams, streamPartitionMsgOffset, offset);
        LOGGER.info("Processing segmentCommitStart:{}", (Object)requestParams.toString());
        SegmentCompletionProtocol.Response response = this._segmentCompletionManager.segmentCommitStart(requestParams);
        String responseStr = response.toJsonString();
        LOGGER.info("Response to segmentCommitStart for segment:{} is:{}", (Object)segmentName, (Object)responseStr);
        return responseStr;
    }

    @GET
    @Path(value="segmentCommitEnd")
    @Produces(value={"application/json"})
    public String segmentCommitEnd(@QueryParam(value="instance") String instanceId, @QueryParam(value="name") String segmentName, @QueryParam(value="location") String segmentLocation, @QueryParam(value="offset") long offset, @QueryParam(value="streamPartitionMsgOffset") String streamPartitionMsgOffset, @QueryParam(value="memoryUsedBytes") long memoryUsedBytes, @QueryParam(value="buildTimeMillis") long buildTimeMillis, @QueryParam(value="waitTimeMillis") long waitTimeMillis, @QueryParam(value="rowCount") int numRows, @QueryParam(value="segmentSizeBytes") long segmentSizeBytes) {
        SegmentMetadataImpl segmentMetadata;
        if (instanceId == null || segmentName == null || segmentLocation == null || offset == -1L && streamPartitionMsgOffset == null) {
            LOGGER.error("Invalid call: offset={}, segmentName={}, instanceId={}, segmentLocation={}, streamPartitionMsgOffset={}", new Object[]{offset, segmentName, instanceId, segmentLocation, streamPartitionMsgOffset});
            return SegmentCompletionProtocol.RESP_FAILED.toJsonString();
        }
        try {
            segmentMetadata = LLCSegmentCompletionHandlers.extractMetadataFromSegmentFileURI(new URI(segmentLocation), segmentName);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while extracting metadata from segment: {} at location: {} from instance: {}", new Object[]{segmentName, segmentLocation, instanceId, e});
            return SegmentCompletionProtocol.RESP_FAILED.toJsonString();
        }
        SegmentCompletionProtocol.Request.Params requestParams = new SegmentCompletionProtocol.Request.Params();
        requestParams.withInstanceId(instanceId).withSegmentName(segmentName).withSegmentLocation(segmentLocation).withSegmentSizeBytes(segmentSizeBytes).withBuildTimeMillis(buildTimeMillis).withWaitTimeMillis(waitTimeMillis).withNumRows(numRows).withMemoryUsedBytes(memoryUsedBytes);
        this.extractOffsetFromParams(requestParams, streamPartitionMsgOffset, offset);
        LOGGER.info("Processing segmentCommitEnd:{}", (Object)requestParams.toString());
        boolean isSuccess = true;
        boolean isSplitCommit = true;
        CommittingSegmentDescriptor committingSegmentDescriptor = CommittingSegmentDescriptor.fromSegmentCompletionReqParamsAndMetadata(requestParams, segmentMetadata);
        SegmentCompletionProtocol.Response response = this._segmentCompletionManager.segmentCommitEnd(requestParams, true, true, committingSegmentDescriptor);
        String responseStr = response.toJsonString();
        LOGGER.info("Response to segmentCommitEnd for segment:{} is:{}", (Object)segmentName, (Object)responseStr);
        return responseStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="segmentCommit")
    @Consumes(value={"multipart/form-data"})
    @Produces(value={"application/json"})
    public String segmentCommit(@QueryParam(value="instance") String instanceId, @QueryParam(value="name") String segmentName, @QueryParam(value="offset") long offset, @QueryParam(value="streamPartitionMsgOffset") String streamPartitionMsgOffset, @QueryParam(value="memoryUsedBytes") long memoryUsedBytes, @QueryParam(value="buildTimeMillis") long buildTimeMillis, @QueryParam(value="waitTimeMillis") long waitTimeMillis, @QueryParam(value="segmentSizeBytes") long segmentSizeBytes, @QueryParam(value="rowCount") int numRows, FormDataMultiPart multiPart) {
        SegmentCompletionProtocol.Request.Params requestParams = new SegmentCompletionProtocol.Request.Params();
        requestParams.withInstanceId(instanceId).withSegmentName(segmentName).withSegmentSizeBytes(segmentSizeBytes).withBuildTimeMillis(buildTimeMillis).withWaitTimeMillis(waitTimeMillis).withNumRows(numRows).withMemoryUsedBytes(memoryUsedBytes);
        this.extractOffsetFromParams(requestParams, streamPartitionMsgOffset, offset);
        LOGGER.info("Processing segmentCommit:{}", (Object)requestParams.toString());
        SegmentCompletionManager segmentCompletionManager = this._segmentCompletionManager;
        SegmentCompletionProtocol.Response response = segmentCompletionManager.segmentCommitStart(requestParams);
        CommittingSegmentDescriptor committingSegmentDescriptor = CommittingSegmentDescriptor.fromSegmentCompletionReqParams(requestParams);
        boolean success = false;
        if (response.equals(SegmentCompletionProtocol.RESP_COMMIT_CONTINUE)) {
            File localTempFile = null;
            try {
                localTempFile = LLCSegmentCompletionHandlers.extractSegmentFromFormToLocalTempFile(multiPart, segmentName);
                SegmentMetadataImpl segmentMetadata = LLCSegmentCompletionHandlers.extractMetadataFromLocalSegmentFile(localTempFile);
                String rawTableName = new LLCSegmentName(segmentName).getTableName();
                URI segmentFileURI = URIUtils.getUri((String)ControllerFilePathProvider.getInstance().getDataDirURI().toString(), (String[])new String[]{rawTableName, URIUtils.encode((String)segmentName)});
                PinotFS pinotFS = PinotFSFactory.create((String)segmentFileURI.getScheme());
                Object object = SEGMENT_UPLOAD_LOCK;
                synchronized (object) {
                    if (pinotFS.exists(segmentFileURI)) {
                        LOGGER.warn("Segment file: {} already exists. Replacing it with segment: {} from instance: {}", new Object[]{segmentFileURI, segmentName, instanceId});
                        pinotFS.delete(segmentFileURI, true);
                    }
                    pinotFS.copyFromLocalFile(localTempFile, segmentFileURI);
                }
                committingSegmentDescriptor = CommittingSegmentDescriptor.fromSegmentCompletionReqParamsAndMetadata(requestParams, segmentMetadata);
                committingSegmentDescriptor.setSegmentLocation(segmentFileURI.toString());
                success = true;
            }
            catch (Exception e) {
                LOGGER.error("Caught exception while committing segment: {} from instance: {}", new Object[]{segmentName, instanceId, e});
            }
            finally {
                FileUtils.deleteQuietly((File)localTempFile);
            }
        }
        response = segmentCompletionManager.segmentCommitEnd(requestParams, success, false, committingSegmentDescriptor);
        LOGGER.info("Response to segmentCommit: instance={}  segment={} status={} offset={}, streamMsgOffset={}", new Object[]{requestParams.getInstanceId(), requestParams.getSegmentName(), response.getStatus(), response.getOffset(), response.getStreamPartitionMsgOffset()});
        return response.toJsonString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="segmentUpload")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public String segmentUpload(@QueryParam(value="instance") String instanceId, @QueryParam(value="name") String segmentName, @QueryParam(value="offset") long offset, @QueryParam(value="streamPartitionMsgOffset") String streamPartitionMsgOffset, FormDataMultiPart multiPart) {
        SegmentCompletionProtocol.Request.Params requestParams = new SegmentCompletionProtocol.Request.Params();
        requestParams.withInstanceId(instanceId).withSegmentName(segmentName);
        this.extractOffsetFromParams(requestParams, streamPartitionMsgOffset, offset);
        LOGGER.info("Processing segmentUpload:{}", (Object)requestParams.toString());
        File localTempFile = null;
        try {
            localTempFile = LLCSegmentCompletionHandlers.extractSegmentFromFormToLocalTempFile(multiPart, segmentName);
            String rawTableName = new LLCSegmentName(segmentName).getTableName();
            URI segmentFileURI = URIUtils.getUri((String)ControllerFilePathProvider.getInstance().getDataDirURI().toString(), (String[])new String[]{rawTableName, URIUtils.encode((String)SegmentCompletionUtils.generateSegmentFileName(segmentName))});
            PinotFSFactory.create((String)segmentFileURI.getScheme()).copyFromLocalFile(localTempFile, segmentFileURI);
            SegmentCompletionProtocol.Response.Params responseParams = new SegmentCompletionProtocol.Response.Params().withStreamPartitionMsgOffset(requestParams.getStreamPartitionMsgOffset()).withSegmentLocation(segmentFileURI.toString()).withStatus(SegmentCompletionProtocol.ControllerResponseStatus.UPLOAD_SUCCESS);
            String response = new SegmentCompletionProtocol.Response(responseParams).toJsonString();
            LOGGER.info("Response to segmentUpload for segment:{} is:{}", (Object)segmentName, (Object)response);
            String string = response;
            return string;
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while uploading segment: {} from instance: {}", new Object[]{segmentName, instanceId, e});
            String string = SegmentCompletionProtocol.RESP_FAILED.toJsonString();
            return string;
        }
        finally {
            FileUtils.deleteQuietly((File)localTempFile);
        }
    }

    @POST
    @Path(value="segmentCommitEndWithMetadata")
    @Produces(value={"application/json"})
    @Consumes(value={"multipart/form-data"})
    public String segmentCommitEndWithMetadata(@QueryParam(value="instance") String instanceId, @QueryParam(value="name") String segmentName, @QueryParam(value="location") String segmentLocation, @QueryParam(value="offset") long offset, @QueryParam(value="streamPartitionMsgOffset") String streamPartitionMsgOffset, @QueryParam(value="memoryUsedBytes") long memoryUsedBytes, @QueryParam(value="buildTimeMillis") long buildTimeMillis, @QueryParam(value="waitTimeMillis") long waitTimeMillis, @QueryParam(value="rowCount") int numRows, @QueryParam(value="segmentSizeBytes") long segmentSizeBytes, FormDataMultiPart metadataFiles) {
        SegmentMetadataImpl segmentMetadata;
        if (instanceId == null || segmentName == null || segmentLocation == null || metadataFiles == null || offset == -1L && streamPartitionMsgOffset == null) {
            LOGGER.error("Invalid call: offset={}, segmentName={}, instanceId={}, segmentLocation={}, streamPartitionMsgOffset={}", new Object[]{offset, segmentName, instanceId, segmentLocation, streamPartitionMsgOffset});
            return SegmentCompletionProtocol.RESP_FAILED.toJsonString();
        }
        SegmentCompletionProtocol.Request.Params requestParams = new SegmentCompletionProtocol.Request.Params();
        requestParams.withInstanceId(instanceId).withSegmentName(segmentName).withSegmentLocation(segmentLocation).withSegmentSizeBytes(segmentSizeBytes).withBuildTimeMillis(buildTimeMillis).withWaitTimeMillis(waitTimeMillis).withNumRows(numRows).withMemoryUsedBytes(memoryUsedBytes);
        this.extractOffsetFromParams(requestParams, streamPartitionMsgOffset, offset);
        LOGGER.info("Processing segmentCommitEndWithMetadata:{}", (Object)requestParams.toString());
        try {
            segmentMetadata = LLCSegmentCompletionHandlers.extractSegmentMetadataFromForm(metadataFiles, segmentName);
        }
        catch (Exception e) {
            LOGGER.error("Caught exception while extracting metadata for segment: {} from instance: {}", new Object[]{segmentName, instanceId, e});
            return SegmentCompletionProtocol.RESP_FAILED.toJsonString();
        }
        boolean isSuccess = true;
        boolean isSplitCommit = true;
        SegmentCompletionProtocol.Response response = this._segmentCompletionManager.segmentCommitEnd(requestParams, true, true, CommittingSegmentDescriptor.fromSegmentCompletionReqParamsAndMetadata(requestParams, segmentMetadata));
        String responseStr = response.toJsonString();
        LOGGER.info("Response to segmentCommitEndWithMetadata for segment:{} is:{}", (Object)segmentName, (Object)responseStr);
        return responseStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractSegmentFromFormToLocalTempFile(FormDataMultiPart form, String segmentName) throws IOException {
        try {
            Map map = form.getFields();
            Preconditions.checkState((boolean)PinotSegmentUploadDownloadRestletResource.validateMultiPart(map, segmentName), (String)"Invalid multi-part for segment: %s", (Object)segmentName);
            FormDataBodyPart bodyPart = (FormDataBodyPart)((List)map.values().iterator().next()).get(0);
            File localTempFile = new File(ControllerFilePathProvider.getInstance().getFileUploadTempDir(), LLCSegmentCompletionHandlers.getTempSegmentFileName(segmentName));
            try (InputStream inputStream = (InputStream)bodyPart.getValueAs(InputStream.class);){
                Files.copy(inputStream, localTempFile.toPath(), new CopyOption[0]);
            }
            catch (Exception e) {
                FileUtils.deleteQuietly((File)localTempFile);
                throw e;
            }
            File file = localTempFile;
            return file;
        }
        finally {
            form.cleanup();
        }
    }

    private static SegmentMetadataImpl extractMetadataFromLocalSegmentFile(File segmentFile) throws Exception {
        File tempIndexDir = new File(ControllerFilePathProvider.getInstance().getUntarredFileTempDir(), segmentFile.getName());
        try {
            FileUtils.forceMkdir((File)tempIndexDir);
            TarGzCompressionUtils.untarOneFile((File)segmentFile, (String)"metadata.properties", (File)new File(tempIndexDir, "metadata.properties"));
            TarGzCompressionUtils.untarOneFile((File)segmentFile, (String)"creation.meta", (File)new File(tempIndexDir, "creation.meta"));
            SegmentMetadataImpl segmentMetadataImpl = new SegmentMetadataImpl(tempIndexDir);
            return segmentMetadataImpl;
        }
        finally {
            FileUtils.deleteQuietly((File)tempIndexDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SegmentMetadataImpl extractSegmentMetadataFromForm(FormDataMultiPart form, String segmentName) throws IOException {
        File tempIndexDir = new File(ControllerFilePathProvider.getInstance().getUntarredFileTempDir(), LLCSegmentCompletionHandlers.getTempSegmentFileName(segmentName));
        try {
            FileUtils.forceMkdir((File)tempIndexDir);
            LLCSegmentCompletionHandlers.extractFileFromForm(form, "metadata.properties", tempIndexDir);
            LLCSegmentCompletionHandlers.extractFileFromForm(form, "creation.meta", tempIndexDir);
            SegmentMetadataImpl segmentMetadataImpl = new SegmentMetadataImpl(tempIndexDir);
            return segmentMetadataImpl;
        }
        finally {
            FileUtils.deleteQuietly((File)tempIndexDir);
        }
    }

    private static void extractFileFromForm(FormDataMultiPart form, String fileName, File outputDir) throws IOException {
        FormDataBodyPart bodyPart = form.getField(fileName);
        Preconditions.checkState((bodyPart != null ? 1 : 0) != 0, (String)"Failed to find: %s", (Object)fileName);
        try (InputStream inputStream = (InputStream)bodyPart.getValueAs(InputStream.class);){
            Files.copy(inputStream, new File(outputDir, fileName).toPath(), new CopyOption[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SegmentMetadataImpl extractMetadataFromSegmentFileURI(URI segmentFileURI, String segmentName) throws Exception {
        File localTempFile = new File(ControllerFilePathProvider.getInstance().getFileUploadTempDir(), LLCSegmentCompletionHandlers.getTempSegmentFileName(segmentName));
        try {
            SegmentFetcherFactory.fetchSegmentToLocal((URI)segmentFileURI, (File)localTempFile);
            SegmentMetadataImpl segmentMetadataImpl = LLCSegmentCompletionHandlers.extractMetadataFromLocalSegmentFile(localTempFile);
            return segmentMetadataImpl;
        }
        finally {
            FileUtils.deleteQuietly((File)localTempFile);
        }
    }

    private static String getTempSegmentFileName(String segmentName) {
        return segmentName + "." + UUID.randomUUID();
    }
}

