/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.controller.api.resources;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.helix.model.InstanceConfig;
import org.apache.pinot.common.utils.config.InstanceUtils;
import org.apache.pinot.controller.api.resources.ControllerApplicationException;
import org.apache.pinot.controller.api.resources.StateType;
import org.apache.pinot.controller.api.resources.SuccessResponse;
import org.apache.pinot.controller.helix.core.PinotHelixResourceManager;
import org.apache.pinot.controller.helix.core.PinotResourceManagerResponse;
import org.apache.pinot.spi.config.instance.Instance;
import org.apache.pinot.spi.utils.JsonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Api(tags={"Instance"})
@Path(value="/")
public class PinotInstanceRestletResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(PinotInstanceRestletResource.class);
    @Inject
    PinotHelixResourceManager pinotHelixResourceManager;

    @GET
    @Path(value="/instances")
    @Produces(value={"application/json"})
    @ApiOperation(value="List all instances")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public Instances getAllInstances() {
        return new Instances(this.pinotHelixResourceManager.getAllInstances());
    }

    @GET
    @Path(value="/instances/{instanceName}")
    @Produces(value={"application/json"})
    @ApiOperation(value="Get instance information", produces="application/json")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=500, message="Internal error")})
    public String getInstance(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName) {
        InstanceConfig instanceConfig = this.pinotHelixResourceManager.getHelixInstanceConfig(instanceName);
        if (instanceConfig == null) {
            throw new ControllerApplicationException(LOGGER, "Instance " + instanceName + " not found", Response.Status.NOT_FOUND);
        }
        ObjectNode response = JsonUtils.newObjectNode();
        response.put("instanceName", instanceConfig.getInstanceName());
        response.put("hostName", instanceConfig.getHostName());
        response.put("enabled", instanceConfig.getInstanceEnabled());
        response.put("port", instanceConfig.getPort());
        response.set("tags", JsonUtils.objectToJsonNode((Object)instanceConfig.getTags()));
        response.set("pools", JsonUtils.objectToJsonNode((Object)instanceConfig.getRecord().getMapField("pool")));
        return response.toString();
    }

    @POST
    @Path(value="/instances")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Create a new instance", consumes="application/json", notes="Creates a new instance with given instance config")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=409, message="Instance already exists"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse addInstance(Instance instance) {
        LOGGER.info("Instance creation request received for instance: {}", (Object)InstanceUtils.getHelixInstanceId((Instance)instance));
        if (!this.pinotHelixResourceManager.addInstance(instance).isSuccessful()) {
            throw new ControllerApplicationException(LOGGER, "Instance already exists", Response.Status.CONFLICT);
        }
        return new SuccessResponse("Instance successfully created");
    }

    @POST
    @Path(value="/instances/{instanceName}/state")
    @Produces(value={"application/json"})
    @Consumes(value={"text/plain"})
    @ApiOperation(value="Enable/disable/drop an instance", notes="Enable/disable/drop an instance")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=400, message="Bad Request"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=409, message="Instance cannot be dropped"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse toggleInstanceState(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName, String state) {
        if (!this.pinotHelixResourceManager.instanceExists(instanceName)) {
            throw new ControllerApplicationException(LOGGER, "Instance " + instanceName + " not found", Response.Status.NOT_FOUND);
        }
        if (StateType.ENABLE.name().equalsIgnoreCase(state)) {
            PinotResourceManagerResponse response = this.pinotHelixResourceManager.enableInstance(instanceName);
            if (!response.isSuccessful()) {
                throw new ControllerApplicationException(LOGGER, "Failed to enable instance " + instanceName + " - " + response.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else if (StateType.DISABLE.name().equalsIgnoreCase(state)) {
            PinotResourceManagerResponse response = this.pinotHelixResourceManager.disableInstance(instanceName);
            if (!response.isSuccessful()) {
                throw new ControllerApplicationException(LOGGER, "Failed to disable instance " + instanceName + " - " + response.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
            }
        } else if (StateType.DROP.name().equalsIgnoreCase(state)) {
            PinotResourceManagerResponse response = this.pinotHelixResourceManager.dropInstance(instanceName);
            if (!response.isSuccessful()) {
                throw new ControllerApplicationException(LOGGER, "Failed to drop instance " + instanceName + " - " + response.getMessage(), Response.Status.CONFLICT);
            }
        } else {
            throw new ControllerApplicationException(LOGGER, "Unknown state " + state + " for instance request", Response.Status.BAD_REQUEST);
        }
        return new SuccessResponse("Request to " + state + " instance " + instanceName + " is successful");
    }

    @DELETE
    @Path(value="/instances/{instanceName}")
    @Consumes(value={"text/plain"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Drop an instance", notes="Drop an instance")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=404, message="Instance not found"), @ApiResponse(code=409, message="Instance cannot be dropped"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse dropInstance(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName) {
        if (!this.pinotHelixResourceManager.instanceExists(instanceName)) {
            throw new ControllerApplicationException(LOGGER, "Instance " + instanceName + " not found", Response.Status.NOT_FOUND);
        }
        PinotResourceManagerResponse response = this.pinotHelixResourceManager.dropInstance(instanceName);
        if (!response.isSuccessful()) {
            throw new ControllerApplicationException(LOGGER, "Failed to drop instance " + instanceName + " - " + response.getMessage(), Response.Status.CONFLICT);
        }
        return new SuccessResponse("Successfully dropped instance");
    }

    @PUT
    @Path(value="/instances/{instanceName}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @ApiOperation(value="Update the specified instance", consumes="application/json", notes="Update specified instance with given instance config")
    @ApiResponses(value={@ApiResponse(code=200, message="Success"), @ApiResponse(code=500, message="Internal error")})
    public SuccessResponse updateInstance(@ApiParam(value="Instance name", required=true, example="Server_a.b.com_20000 | Broker_my.broker.com_30000") @PathParam(value="instanceName") String instanceName, Instance instance) {
        LOGGER.info("Instance update request received for instance: {}", (Object)instanceName);
        PinotResourceManagerResponse response = this.pinotHelixResourceManager.updateInstance(instanceName, instance);
        if (!response.isSuccessful()) {
            throw new ControllerApplicationException(LOGGER, "Failure to update instance. Reason: " + response.getMessage(), Response.Status.INTERNAL_SERVER_ERROR);
        }
        return new SuccessResponse("Instance successfully updated");
    }

    public static class Instances {
        List<String> instances;

        public Instances(@JsonProperty(value="instances") List<String> instances) {
            this.instances = instances;
        }

        public List<String> getInstances() {
            return this.instances;
        }

        public Instances setInstances(List<String> instances) {
            this.instances = instances;
            return this;
        }
    }
}

